# Hover

![PyPI Stage](https://img.shields.io/pypi/status/hover?style=for-the-badge)
![PyPI Version](https://img.shields.io/pypi/v/hover?style=for-the-badge)
![Travis CI](https://img.shields.io/travis/phurwicz/hover?style=for-the-badge)
![Codacy Grade](https://img.shields.io/codacy/grade/689827d9077b43ac8721c7658d122d1a?style=for-the-badge)

----

`Hover` is a machine learning **dev-time-helper** library that enables smooth and effective supervision. In other words, it's an interface where you _hover_ over and label your data.. differently. For instance, you can:

- :seedling: annotate an intuitively selected group of data points at a time [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/phurwicz/hover-binder/master?urlpath=/proxy/5006/app-simple-annotator) [Source](https://github.com/phurwicz/hover-binder/app-simple-annotator/main.py)

- :ferris_wheel: throw a model in the loop and exploit all kinds of active learning [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/phurwicz/hover-binder/master?urlpath=/proxy/5006/app-active-learning) [Source](https://github.com/phurwicz/hover-binder/app-active-learning/main.py)

- :whale: **UPCOMING** cross-check with Snorkel-based distant supervision [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/phurwicz/hover-binder/master?urlpath=/proxy/5006/app-snorkel-explorer) [Source](https://github.com/phurwicz/hover-binder/app-snorkel-explorer/main.py)

Check out [@phurwicz/hover-binder](https://github.com/phurwicz/hover-binder) for a complete list of demo apps.


## Installation

To get the latest release version, you can use pip:

```bash
pip install hover
```

Installation through `conda` is not yet supported.


## Resources

- [Documentation](https://phurwicz.github.io/hover/)

## Developer

- `./requirements.txt` lists the installation requirements.
- `./requirements-dev.txt` is for developers.
