# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/10_lo.ipynb.

# %% auto 0
__all__ = ['Lo']

# %% ../nbs/10_lo.ipynb 3
from typing import Union

import numpy as np
from fastcore.all import store_attr

from .utils import history_warning
from .repr_str import lovely
from .repr_rgb import rgb
from .repr_chans import chans


# %% ../nbs/10_lo.ipynb 4
class RGBProxy():
    """Flexible `PIL.Image.Image` wrapper"""
    
    def __init__(self, x:np.ndarray):
        # super().__init__()
        assert x.ndim >= 3, f"Expecting at least 3 dimensions, got shape{t.shape}={t.dim()}"
        self.x = x

    def __call__(   self,
                    denorm=None,
                    cl=True,
                    gutter_px=3, frame_px=1,
                    scale=1,
                    view_width=966):

        return rgb(self.x, denorm=denorm, cl=cl, gutter_px=gutter_px,
                frame_px=frame_px, view_width=view_width, scale=scale)
    
    def _repr_png_(self):
        return self.__call__()._repr_png_()

# %% ../nbs/10_lo.ipynb 5
class ChanProxy():
    def __init__(self, x: np.ndarray):
        self.t = x
    
    def __call__(self,
                 cmap = "coolwarm", 
                 cm_below="blue",
                 cm_above="red",
                 cm_ninf="cyan",
                 cm_pinf="fuchsia",
                 cm_nan="yellow",
                 view_width=966,
                 gutter_px=3,
                 frame_px=1,
                 scale=1):
        
        return chans(self.t,
                     cmap=cmap,
                     cm_below=cm_below,
                     cm_above=cm_above,
                     cm_ninf=cm_ninf,
                     cm_pinf=cm_pinf,
                     cm_nan=cm_nan,
                     view_width=view_width,
                     gutter_px=gutter_px,
                     frame_px=frame_px,
                     scale=scale)
    
    def _repr_png_(self):
        return self.__call__()._repr_png_()

# %% ../nbs/10_lo.ipynb 6
class Lo():
    """Lo and behold! What a lovely `numpy.ndarray`!"""
    def __init__(self, x: Union[np.ndarray, np.generic],    # Your data
                    plain       =False, # Show as plain text - values only
                    verbose     =False, # Verbose - show values too
                    depth       =0,     # Expand up to `depth`
                    color :bool =None): # Use ANSI colors
        store_attr()
        history_warning()

    def __repr__(self):
        return lovely(self.x, plain=self.plain, verbose=self.verbose,
                      depth=self.depth, color=self.color)

    @property
    def v(self):
        "Verbose"
        return Lo(self.x, verbose=True, color=self.color)

    @property
    def p(self):
        "Good old plain representation"
        return Lo(self.x, plain=True, color=self.color)

    @property
    def deeper(self):
        "Going deeper"
        return Lo(self.x, verbose=False, plain=False, depth=1, color=self.color)

    @property
    def rgb(self):
        "Show an image"
        return RGBProxy(self.x)

    @property
    def chans(self):
        "Show color channels"
        return ChanProxy(self.x)

    # This is used for .deeper attribute and .deeper(depth=...).
    # The second one results in a __call__.
    def __call__(self, depth=1):
        return Lo(self.x, depth=depth, color=self.color)
