from setuptools import setup

setup(name = 'sematch',
      packages=['sematch','sematch.semantic'],
      version = '1.0.2',
      description = 'Semantic similarity framework for knowledge graphs',
      long_description = 'Sematch is an integrated framework for the development, evaluation, and application of semantic similarity for Knowledge Graphs. Semantic similarity is a very useful metric for many applications that require to quantify the semantic similarity between concepts. Sematch focuses on knowledge-based semantic similarity using structural knowledge in taxonomy (e.g. depth, path length, least common subsumer), and statistical information contents (corpus-IC and graph-IC). Many applications share a common pipeline in using semantic similarity analysis. In textual applications, word similarity is measured based on WordNet with various semantic similarity metrics. Then text similarity (sentence level) is measured by composing word similarities, while document level text could be analysed by identifying important sentences based on text similarity, e.g. TextRank. This process starts from measuring concept similarity (word meanings or senses which are denoted as synsets in WordNet) which is normally referred as knowledge-based semantic similarity compared to its conterpart corpus-based approaches that are based on word coocurrence (e.g. Pointwise Mutual Information) or distributional semantics (Explict Semantic Analysis, Word2Vec, GLOVE and etc). Concept similarity are normally quantified using various information such as structural knowledge (e.g. path length, depth, least common subsumer) and statistical knowledge ( information content). KG based applications also meet the requirments in computing concept similarity (e.g. http://dbpedia.org/class/yago/Actor109765278) and entity similarity (e.g. http://dbpedia.org/resource/Madrid). Since entities usually contain several concepts to describe entity meanings, similar to word similarity, entity similarity can be quantified based on their concept similarity. Moreover, those concepts in KGs are usually constructed into hierarchical taxonomies, such as DBpedia ontology class, Wikipedia categories, therefore quantifying concept similarity in WordNet or DBpedia relies on similar semantic information (e.g. path length,  depth, least common subsumer, information content) and semantic similarity metrics (e.g. Path, Wu & Palmer,Li,  Resnik, Lin, Jiang & Conrad and WPath). Consequently,  Sematch provides an integrated framework to develop and evaluate semantic similarity metrics for concepts, words, entities and their applications.',
      author = 'Ganggao Zhu',
      author_email = 'gzhu@dit.upm.es',
      license='Apache 2.0',
      url = 'https://github.com/gsi-upm/sematch',
      keywords = ['semantic similarity', 'taxonomy', 'knowledge graph', 
      'semantic analysis', 'knowledge base', 'WordNet', 'DBpedia','YAGO', 'ontology'],
      include_package_data=True,
      package_data = {'models':['models/dbpedia_2015-04.owl',
                                'models/dbpedia_type_ic.txt',
                                'models/type-linkings.txt',
                                'models/yago_type_ic.txt',
                                'models/FoxStoplist.txt',
                                'models/SmartStoplist.txt'],
                      'dataset/aspect':['dataset/aspect/data.txt'],
                      'dataset/wordsim':['dataset/wordsim/noun_mc.txt',
                                         'dataset/wordsim/noun_rg.txt',
                                         'dataset/wordsim/noun_simlex.txt',
                                         'dataset/wordsim/noun_ws353-sim.txt',
                                         'dataset/wordsim/noun_ws353.txt',
                                         'dataset/wordsim/rg65_EN-ES.txt',
                                         'dataset/wordsim/rg65_spanish.txt',
                                         'dataset/wordsim/graph_mc.txt',
                                         'dataset/wordsim/graph_rg.txt',
                                         'dataset/wordsim/graph_simlex.txt',
                                         'dataset/wordsim/graph_ws353-sim.txt',
                                         'dataset/wordsim/graph_ws353.txt',
                                         'dataset/wordsim/type_mc.txt',
                                         'dataset/wordsim/type_rg.txt',
                                         'dataset/wordsim/type_simlex.txt',
                                         'dataset/wordsim/type_ws353-sim.txt',
                                         'dataset/wordsim/type_ws353.txt',],
                      'dataset/wordsim/results':['dataset/wordsim/results/noun_simlex-wpath.txt'],
                      },
      classifiers = ['Programming Language :: Python :: 2.7',],
      install_requires=['numpy==1.11.0','scipy==0.13.2','scikit-learn==0.17.1','networkx==1.11',
                        'nltk==3.2','rdflib==4.0.1','SPARQLWrapper==1.5.2'],
      )
