# Generated by Django 2.2.10 on 2020-03-08 05:52

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('django_eveonline_connector', '0022_auto_20200303_1841'),
    ]

    operations = [
        migrations.CreateModel(
            name='EveTransaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('client_id', models.IntegerField()),
                ('date', models.DateTimeField()),
                ('is_buy', models.BooleanField()),
                ('is_personal', models.BooleanField()),
                ('journal_ref_id', models.IntegerField()),
                ('location_id', models.IntegerField()),
                ('quantity', models.IntegerField()),
                ('transaction_id', models.IntegerField(unique=True)),
                ('type_id', models.IntegerField()),
                ('unit_price', models.FloatField()),
                ('client_name', models.CharField(max_length=64)),
                ('client_type', models.CharField(choices=[('character', 'character'), ('corporation', 'corporation'), ('alliance', 'alliance')], max_length=64)),
                ('location_name', models.CharField(max_length=64)),
                ('type_name', models.CharField(max_length=64)),
                ('entity', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_eveonline_connector.EveEntity')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EveJournalEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('external_id', models.IntegerField(unique=True)),
                ('amount', models.FloatField(blank=True, null=True)),
                ('balance', models.FloatField(blank=True, null=True)),
                ('tax', models.FloatField(blank=True, null=True)),
                ('tax_receiver_id', models.IntegerField(blank=True, null=True)),
                ('context_id', models.IntegerField(blank=True, null=True)),
                ('context_id_type', models.CharField(blank=True, max_length=32, null=True)),
                ('date', models.DateTimeField()),
                ('description', models.TextField()),
                ('reason', models.TextField()),
                ('ref_type', models.CharField(max_length=128)),
                ('first_party_id', models.IntegerField(blank=True, null=True)),
                ('second_party_id', models.IntegerField(blank=True, null=True)),
                ('first_party_name', models.CharField(max_length=64)),
                ('first_party_type', models.CharField(choices=[('character', 'character'), ('corporation', 'corporation'), ('alliance', 'alliance')], max_length=32)),
                ('second_party_name', models.CharField(max_length=64)),
                ('second_party_type', models.CharField(choices=[('character', 'character'), ('corporation', 'corporation'), ('alliance', 'alliance')], max_length=32)),
                ('entity', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_eveonline_connector.EveEntity')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EveContract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contract_id', models.IntegerField(unique=True)),
                ('acceptor_id', models.IntegerField()),
                ('assignee_id', models.IntegerField()),
                ('buyout', models.FloatField(blank=True, null=True)),
                ('collateral', models.FloatField(blank=True, null=True)),
                ('price', models.FloatField(blank=True, null=True)),
                ('reward', models.FloatField(blank=True, null=True)),
                ('volume', models.FloatField(blank=True, null=True)),
                ('date_accepted', models.DateTimeField(blank=True, null=True)),
                ('date_completed', models.DateTimeField(blank=True, null=True)),
                ('date_expired', models.DateTimeField()),
                ('date_issued', models.DateTimeField()),
                ('days_to_complete', models.IntegerField(blank=True, null=True)),
                ('for_corporation', models.BooleanField()),
                ('availability', models.CharField(max_length=32)),
                ('issuer_corporation_id', models.IntegerField()),
                ('issuer_id', models.IntegerField()),
                ('start_location_id', models.IntegerField(blank=True, null=True)),
                ('end_location_id', models.IntegerField(blank=True, null=True)),
                ('status', models.CharField(max_length=32)),
                ('title', models.TextField(blank=True, null=True)),
                ('type', models.CharField(max_length=16)),
                ('acceptor_name', models.CharField(max_length=64)),
                ('assignee_name', models.CharField(max_length=64)),
                ('issuer_name', models.CharField(max_length=64)),
                ('issuer_corporation_name', models.CharField(max_length=64)),
                ('acceptor_type', models.CharField(choices=[('character', 'character'), ('corporation', 'corporation'), ('alliance', 'alliance')], max_length=32)),
                ('assignee_type', models.CharField(choices=[('character', 'character'), ('corporation', 'corporation'), ('alliance', 'alliance')], max_length=32)),
                ('issuer_type', models.CharField(choices=[('character', 'character'), ('corporation', 'corporation'), ('alliance', 'alliance')], max_length=64)),
                ('items', models.TextField()),
                ('entity', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_eveonline_connector.EveEntity')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EveContact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contact_id', models.IntegerField()),
                ('is_blocked', models.BooleanField(default=False)),
                ('is_watched', models.BooleanField(default=False)),
                ('label_ids', models.TextField()),
                ('standing', models.FloatField()),
                ('contact_name', models.CharField(max_length=64)),
                ('contact_type', models.CharField(choices=[('character', 'character'), ('corporation', 'corporation'), ('alliance', 'alliance')], max_length=32)),
                ('entity', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_eveonline_connector.EveEntity')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EveSkill',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active_skill_level', models.IntegerField()),
                ('trained_skill_level', models.IntegerField()),
                ('skill_id', models.IntegerField()),
                ('skillpoints_in_skill', models.IntegerField()),
                ('skill_name', models.CharField(max_length=64)),
                ('skill_group', models.CharField(max_length=64)),
                ('entity', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_eveonline_connector.EveEntity')),
            ],
            options={
                'unique_together': {('entity', 'skill_name')},
            },
        ),
    ]
