# <img src="https://raw.githubusercontent.com/neka-nat/kinpy/master/assets/logo.png" width="400" />

[![Build status](https://github.com/neka-nat/kinpy/actions/workflows/ubuntu.yml/badge.svg)](https://github.com/neka-nat/kinpy/actions/workflows/ubuntu.yml/badge.svg)
[![PyPI version](https://badge.fury.io/py/kinpy.svg)](https://badge.fury.io/py/kinpy)
[![MIT License](http://img.shields.io/badge/license-MIT-blue.svg?style=flat)](LICENSE)
[![Downloads](https://pepy.tech/badge/kinpy)](https://pepy.tech/project/kinpy)

Simple kinematics body toolkit.

## Core features

* Pure python library.
* Support URDF, SDF and MJCF file.
* Calculate FK, IK and jacobian.

## Installation

```
pip install kinpy
```

## Getting started
Here is a program that reads urdf and generates a kinematic chain.

```py
import kinpy as kp

chain = kp.build_chain_from_urdf(open("kuka_iiwa/model.urdf").read())
print(chain)
# lbr_iiwa_link_0_frame
# └──── lbr_iiwa_link_1_frame
#       └──── lbr_iiwa_link_2_frame
#             └──── lbr_iiwa_link_3_frame
#                   └──── lbr_iiwa_link_4_frame
#                         └──── lbr_iiwa_link_5_frame
#                               └──── lbr_iiwa_link_6_frame
#                                     └──── lbr_iiwa_link_7_frame
```

Displays the parameter names of joint angles included in the chain.

```py
print(chain.get_joint_parameter_names())
# ['lbr_iiwa_joint_1', 'lbr_iiwa_joint_2', 'lbr_iiwa_joint_3', 'lbr_iiwa_joint_4', 'lbr_iiwa_joint_5', 'lbr_iiwa_joint_6', 'lbr_iiwa_joint_7']
```

Given joint angle values, calculate forward kinematics.

```py
import math
th = {'lbr_iiwa_joint_2': math.pi / 4.0, 'lbr_iiwa_joint_4': math.pi / 2.0}
ret = chain.forward_kinematics(th)
```

You can get the position and orientation of each link.

## Visualization

### KUKA IIWA
![kuka](https://raw.githubusercontent.com/neka-nat/kinpy/master/assets/kuka.png)

### Mujoco humanoid
![humanoid](https://raw.githubusercontent.com/neka-nat/kinpy/master/assets/humanoid.png)

### Mujoco ant
![ant](https://raw.githubusercontent.com/neka-nat/kinpy/master/assets/ant.png)

### Simple arm
![simple_arm](https://raw.githubusercontent.com/neka-nat/kinpy/master/assets/simple_arm.png)

## Citing

```
@software{kinpy,
    author = {{Kenta-Tanaka et al.}},
    title = {kinpy},
    url = {https://github.com/neka-nat/kinpy},
    version = {0.0.3},
    date = {2019-10-11},
}
```
