# Open Autonomy CLI tool

`open-autonomy` is a collection of tools from the {{open_autonomy}} framework packaged into a CLI tool.

## Deploy

```
$ autonomy deploy

Usage: autonomy deploy [OPTIONS] COMMAND [ARGS]...

  Deploy an AEA project.

Options:
  --help  Show this message and exit.

Commands:
  build  Build the agent and its components.
```

### Build tools.

1. Deployment

```bash
Usage: autonomy deploy build deployment [OPTIONS] PUBLIC_ID_OR_HASH KEYS_FILE

  Build deployment setup for n agents.

Options:
  --o PATH             Path to output dir.
  --n INTEGER          Number of agents.
  --docker             Use docker as a backend.
  --kubernetes         Use kubernetes as a backend.
  --packages-dir PATH  Path to packages folder (for local usage).
  --dev                Create development environment.
  --version TEXT       Specify deployment version.
  --force              Remove existing build and overwrite with new one.
  --skip-images        Specify whether to build images or not.
  --remote             To use a remote registry.
  --local              To use a local registry.
  -p                   Ask for password interactively
  --password PASSWORD  Set password for key encryption/decryption
  --help               Show this message and exit.
```

To create an environment you'll need a service id and a file containing keys with funds for the chain you want to use. The necessary images will be built during the build process.

`PUBLIC_ID_OR_HASH` refers to the public id of the service, eg. `valory/oracle_hardhat`. `KEYS_FILE` refers the the file containing funded keys for the agent instances.

Example keys file

```json
[
    {
        "address": "0xf39Fd6e51aad88F6F4ce6aB8827279cffFb92266",
        "private_key": "0xac0974bec39a17e36ba4a6b4d238ff944bacb478cbed5efcae784d7bf4f2ff80"
    },
    {
        "address": "0x70997970C51812dc3A010C7d01b50e0d17dc79C8",
        "private_key": "0x59c6995e998f97a5a0044966f0945389dc9e86dae88c7a8412f4603b6b78690d"
    },
    {
        "address": "0x3C44CdDdB6a900fa2b585dd299e03d12FA4293BC",
        "private_key": "0x5de4111afa1a4b94908f83103eb1f1706367c2e68ca870fc3fb9a804cdab365a"
    },
    {
        "address": "0x90F79bf6EB2c4f870365E785982E1f101E93b906",
        "private_key": "0x7c852118294e51e653712a81e05800f419141751be58f605c371e15141b007a6"
    }
]
```

These keys can be used for local deployments if you're using the default hardhat image for the local chain. Copy and paste this into `keys.json` file and run following command

```bash
# create a docker deployment
$ autonomy deploy build deployment valory/oracle_hardhat:0.1.0:bafybeicrxhuzkroycrb7dpzqaebi2gylmrt5hafqrwufndar7xmi7gkstq keys.json
```

This will create a deployment environment with following directory structure

```
abci_build/
├── Dockerfiles
│   ├── agent
│   ├── dev
│   ├── hardhat
│   ├── skaffold.yaml
│   └── tendermint
├── agent_keys
│   ├── agent_0
│   ├── agent_1
│   ├── agent_2
│   └── agent_3
├── docker-compose.yaml
├── nodes
│   ├── node0
│   ├── node1
│   ├── node2
│   └── node3
├── persistent_data
│   ├── benchmarks
│   ├── logs
│   ├── tm_state
│   └── venvs
└── service.yaml
```

To run this deployment go to the `abci_build` and run `docker-compose up`.


1. Deployment images

```bash
Usage: autonomy deploy build image [OPTIONS]

  Build image using skaffold.

Options:
  --build-dir PATH     Path to build dir.
  --packages-dir PATH  Path to packages folder (for local usage).
  --skaffold-dir PATH  Path to directory containing the skaffold config.
  --version TEXT       Image version.
  --push               Push image after build.
  --dependencies       To use the dependencies profile.
  --prod               To use the prod profile.
  --dev                To use the dev profile.
  --cluster            To use the cluster profile.
  --help               Show this message and exit.
```

```bash
#To build an image, navigate to the build dir and run
$ autonomy deploy build image
```

This will create and image with label `valory/open-autonomy-open-aea:oracle-0.1.0`. Images generated by this command will follow `valory/open-autonomy-open-aea:app_name-version` format for labels.

## Replay

Replay tools can be use the re run the agents using data dumps from previous runs.

**Note: Replay only works for deployments which were ran in dev mode**

```bash
Usage: autonomy replay [OPTIONS] COMMAND [ARGS]...

  Replay tools.

Options:
  --help  Show this message and exit.

Commands:
  agent       Agent runner.
  tendermint  Tendermint runner.
```

### agent

```bash
Usage: autonomy replay agent [OPTIONS] AGENT

  Agent runner.

Options:
  --build PATH     Path to build dir.
  --registry PATH  Path to registry folder.
  --help           Show this message and exit.
```

### tendermint

```bash
Usage: autonomy replay tendermint [OPTIONS]

  Tendermint runner.

Options:
  --build PATH  Path to build directory.
  --help        Show this message and exit.
```


## Replay agents runs from Tendermint dumps

1. Run your preferred app in dev mode, for example run oracle in dev using `make run-oracle-dev` and in a separate terminal run `make run-hardhat`.

2. Wait until at least one reset (`reset_and_pause` round) has occurred, because the Tendermint server will only dump Tendermint data on resets. Once you have a data dump stop the app.

3. Run `autonomy replay tendermint` . This will spawn a tendermint network with the available dumps.

4. Now  you can run replays for particular agents using `autonomy replay agent AGENT_ID`. `AGENT_ID` is a number between `0` and the number of available agents `-1`. E.g. `autonomy replay agent 0` will run the replay for the first agent.


## Analyse


### ABCI apps

```bash
Usage: autonomy analyse abci [OPTIONS] COMMAND [ARGS]...

  Analyse ABCI apps.

Options:
  --help  Show this message and exit.

Commands:
  check-app-specs     Check abci app specs.
  docstrings          Analyse ABCI docstring definitions.
  generate-app-specs  Generate abci app specs.
  logs                Parse logs.
```


**Generate ABCI App specifications**

```bash
Usage: autonomy analyse abci generate-app-specs [OPTIONS] APP_CLASS OUTPUT_FILE

  Generate abci app specs.

Options:
  --mermaid  Mermaid file.
  --yaml     Yaml file.
  --json     Json file.
  --help     Show this message and exit.
```

**Check ABCI App specifications**

```bash
Usage: autonomy analyse abci check-app-specs [OPTIONS]

  Check abci app specs.

Options:
  --check-all          Check all available definitions.
  --packages-dir PATH  Path to packages directory; Use with `--check-all` flag
  --yaml               Yaml file.
  --json               Json file.
  --app_class TEXT     Dotted path to app definition class.
  --infile PATH        Path to input file.
  --help               Show this message and exit.
```

**Check ABCI app docstrings**

```bash
Usage: autonomy analyse abci docstrings [OPTIONS] [PACKAGES_DIR]

  Analyse ABCI docstring definitions.

Options:
  --check
  --help   Show this message and exit.
```

**Parse logs from a deployment**

```bash
Usage: autonomy analyse abci logs [OPTIONS] FILE

  Parse logs.

Options:
  --help  Show this message and exit.
```

### benchmarks

```bash
Usage: autonomy analyse benchmarks [OPTIONS] PATH

  Benchmark Aggregator.

Options:
  -b, --block-type [local|consensus|total|all]
  -d, --period INTEGER
  -o, --output FILE
  --help                          Show this message and exit.
```

Aggregating results from deployments.

To use this tool you'll need benchmark data generated from agent runtime. To generate benchmark data run

```
$ autonomy deploy build deployment SERVICE_ID PATH_RO_KEYS --dev
```

By default this will create a 4 agent runtime where you can wait until all 4 agents are at the end of the first period (you can wait for more periods if you want) and then you can stop the runtime. The data will be stored in `abci_build/persistent_data/benchmarks` folder.

Run deployment using

```bash
$ cd abci_build/
$ docker-compose up
```

You can use this tool to aggregate this data.

```bash
autonomy analyse benchmarks abci_build/persistent_data/benchmarks
```

By default tool will generate output for all periods but you can specify which period to generate output for, same goes for block types as well.
