# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tinker']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1,<8.0', 'pyyaml>=5.4.1,<6.0.0', 'smqtk-core==0.15.0']

setup_kwargs = {
    'name': 'tinker-engine',
    'version': '0.9.0',
    'description': 'Framework for configuring and running machine learning algorithms',
    'long_description': '# tinker-engine\n\n## Documentation for Examples\n\nCheck out the [examples](examples/) to get started using Tinker Engine.\n\n## Developer setup\n\n### Build Tinker Engine\n\nThe easiest way to build Tinker Engine locally is by using [poetry](https://python-poetry.org/docs/).\nThese steps will create a vistual environment where Tinker Engine is built and installed and\navailable for use.\n\n1. Clone this repository.\n2. In the `tinker-engine` directory, install the dependencies with\n   `poetry install`.\n3. Activate the virtual environment using : `poetry shell`.\n4. Run Tinker Engine to ensure it works: `tinker --help`.\n\n### Running Tinker Engine\n\nThere is an example protocol definition in\n[`examples/helloworld/helloworld.py`](examples/helloworld/helloworld.py). You\ncan use this with Tinker Engine as follows:\n\n```\n$ tinker -c examples/helloworld/helloworld.yaml examples/helloworld/helloworld.py\n```\n\nSince Tinker Engine only finds a single protocol defined in the entrypoints\nsupplied to it, it will automatically instantiate and run the one it has found.\nBut you can also list the ones it knows about, like this:\n\n```\n$ tinker -c examples/helloworld.yaml examples/helloworld.py --list-protocols\n```\n\n### Other examples\n\nThe `examples` directory contains several protocols and configurations that you\ncan use to explore how Tinker Engine works.\n\n#### Configuration Directives\n\nThe `examples/config` directory contains examples showing various configuration\ndirectives, using a protocol that simple prints out the configuration passed to\nit:\n\n```\n$ tinker -c examples/config/iterate.yaml examples/config/show_config.py\n```\n\ndemonstrates how the `iterate` directive works combinatorially, and\n\n```\n$ tinker -c examples/config/iterate_nested.yaml examples/config/show_config.py\n```\n\ndemonstrates the semantics of nesting one `iterate` directive within another.\n\nWhen iteration is not needed, a "vanilla" configuration file will behave as\nexpected:\n\n```\n$ tinker -c examples/config/vanilla.yaml examples/config/show_config.py\n```\n\n##### SMQTK Directive \n\nThe examples/smqtk folder contains examples of a SMQTK implementation,\nSMQTK configuration files, and a protocol specifically for displaying\nSMQTK instantiations.\n\nFrom the root directory, we can test the SMQTK support.\n\n```\n$ SMQTK_PLUGIN_PATH=examples.smqtk.hello_smqtk tinker  -c examples/smqtk/hello_smqtk.yaml examples/smqtk/show_smqtk.py\n```\n\n### Command Line Documentation\n\n```\nusage: tinker [-h] -c CONFIG [--list-protocols] [--list-algorithms]\n              [--log-file LOG_FILE] [--log-level LOG_LEVEL]\n              protocol_file [protocol_file ...]\n\npositional arguments:\n  protocol_file         python file defining protocols/algorithms/etc.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -c CONFIG, --config CONFIG\n                        config file\n  --list-protocols      Print the available protocols\n  --list-algorithms     Print the available algorithms\n  --log-file LOG_FILE   Path to log file\n  --log-level LOG_LEVEL\n                        Logging level\n```\n\nGenerally, you will use the `tinker` utility by supplying a configuration file\nwith the `-c` option and at least one `protocol_file` listed as positional\narguments. Tinker Engine will read in the configuration file and use it to\ninstantiate a `Protocol` object defined in one of the `protocol_file`s listed.\n\nThe `--log-file` option sets a filename to use as the log file; by default it\nwill be a file named by the running computer\'s hostname and the current time.\n\nThe `--list-protcols` and `--list-algorithms` options are diagnostics to show\nwhat has been detected by Tinker Engine. The options will, respectively, print\nout all the `Protocol` and `Algorithm` objects found by Tinker Engine. These are\nthe objects available for use when Tinker Engine is run.\n\n### Publishing on PYPI\n\nTinker uses github actions to publish packages on pypi. The action is triggered\nwhen a [semver](https://semver.org/) tag is pushed to tinker.\n\nWe support the following version format `<major>.<minor>.<patch>` and\n`<major>.<minor>.<patch>-alpha.<alpha-version>` for tags. To publish a package\non pypi, the tag must match with the version maintained in `pyproject.toml`.\nThis is implemented as a mandatory check in the workflow. Poetry provides support\nfor both querying and bumping version via cli. Please refer to\n[version](https://python-poetry.org/docs/cli/#version) for more details.\n\nThus to publish tinker on pypi use the following commands\n\n1. Bump the version in pyproject.toml using `poetry version <version_rule>`.\n2. Use `poetry version --short` to determine the version that would be used in the tag.\n3. Generate and push the tag using\n   ```\n    git tag <package-version>\n    git push origin --tags\n   ```\n\n\n# Acknowledgments\n\nThis material is based upon work supported by the Defense Advanced Research\nProjects Agency (DARPA) under Contract No. HR001120C0055 and research sponsored\nby DARPA under agreement number FA8750-19-1-0504. Any opinions, findings and\nconclusions or recommendations expressed in this material are those of the\nauthor(s) and do not necessarily reflect the views of the DARPA. The U.S.\nGovernment is authorized to reproduce and distribute reprints for Governmental\npurposes notwithstanding any copyright notation thereon.\n\n# IGNORE EVERYTHING BELOW\n\n## Getting started\n\nThis repository contains a development version of the `tinker-engine` package.\nTo install it, make sure you are in your desired Python environment (e.g., by\ncreating a virtual environment), enter the top level directory of this\nrepository, and use `pip`:\n\n```bash\npip install -e .\n```\n\nOnce this is complete, you can execute protocols using Tinker Engine using the following command\n```bash\ntinker protocol_file\n```\nprotocol\\_file is the location and name of a python protocol file. The project administrator should provide the protocol script to the researchers for their local development. The protocol\\_file can be either an absolute file path, or a path from the current working directory to the protocol file. Tinker Engine can be executed from any location, but it is recomended that it be run from the root of the algorithms directory.\n\nIf Tinker Engine needs to be run from somewhere other than the algorithms directory root, the path to the algorithms direcotry root should be provided using the -a argument\n\n```bash\ntinker protocol_file -a alogorithms_path\n```\n \nTinker Engine can also be run with different harness interfaces. Use the -l flag to list the available interfaces. By default Tinker Engine uses the LocalInterface provided by Tinker Engine. An alternate can be selected using the -i \\<interface name\\> argument. User defined interfaces can also be used, but must derive from the Harness base class, and should be placed in the same folder with the protocol file. If everything is setup correctly, the -l flag will also print out the name of any user defined interfaces that are available.\n\n## Running Learn\n\nFirst, install Tinker Engine (instructions above). Next, check out the Learn\nrepository. Use the `pip` command to install the\nLearn package: if the `tinker-engine` and `learn` repositories are in side-by-side\ndirectories, and you are in the top-level directory of `tinker-engine`, then the\nappropriate command would be `pip install -e ../learn`.\n\nThen you will need to download all of the datasets and follow\ninstructions from: https://gitlab.lollllz.com/lwll/dataset_prep. Make sure the\n`lwll_datasets` directory is in your current directory.\n\nTo run the learn protocol, invoke the `tinker` command as follows:\n```bash\ntinker ../learn/learn/protocol/learn_protocol.py -a ../learn/learn/algorithms\n```\n\n## System design\nTinker Engine has three parts. Tinker Engine itself is installed such that it can be executed from any desired location\non the system. The second part is the protocol and optional interfaces. The protocol is written by the project team to meet the requirements of\nthe entire project. This is a python script that exercises all parts of the system in the desired fashion. The project team may wish to also include simpler protocols that excercise just one algorithm at a time. This is useful for researchers when developing algorithms. Additionally, if the standard local interface test harness is not sufficient for the project needs, a substitute interface can be defined by the project team, as long as it inherits from the Harness class. The third part are the algorithms. The three parts of the system do not need to be in the same location. The only requirement for the algorithms is that they all reside under the same root folder, and any user defined interfaces must be in the same folder with the protocol file.\n\nThe basic design of the system is in support of a two tier system of users. The first tier are the project administrators. At this level, the experimental protocol is established and codified. To make this job easier, the final protocol code is written in python, and has very little restrictions to how it works. Tinker Engine itself mostly provides a support structure for the user written protocol file. The system diagram for this is:\n\n![Tinker Engine System Diagram](images/tinker_engine.png)\n\nUnder this framework, the start of execution begins in the main.py, which locates, prepares and loads the protocol from the given protocol python file. It also loads the requested interface and supplies that to the protocol. The name of the file is provided by the end-user thorugh a command line argument, and the name of the class within the protocol file is unimportant (it will be loaded regardless of its name). Execution is then passed to the protocols run\\_protocol function. The user protocol should inherit from tinker.BaseProtocol. the BaseProtocol provides access to the get\\_algorithm function which will locate and dynamically load an algorithm on request. When the protocol needs to pass execution to a specific algorithm, it should call that algorithms "execute" function. One of the arguments to that function provides a step\\_description which indicates what mode of processing the algorrithm should perform. In order to facilitate this behavior, every algorithm class must derive from tinker.BaseAlgorithm directly, or from an adapter class that derives from BaseAlgorithm. Like the protocol files, the name of the class in an algorithm file is ignored, and the class is loaded regardless of its name.\n\nWhen implementing an algorithm, a "requirements.txt" file must be provided so that we can figure\nout the algorithm\'s dependencies. An example dependencies file looks something like:\n\n```\ntorch>=1.3.0\ntorchvision>=0.3.0\nnumpy>=1.16.4\nscikit-learn>=0.21.1\nscipy>=1.2.1\nubelt>=0.8.7\n```\n\n## Acknowledgement of Support and Disclaimer\n\nThis material is based upon work supported by the Defense Advanced Research\nProjects Agency (DARPA) under Contract No. HR001120C0055. Any opinions, findings\nand conclusions or recommendations expressed in this material are those of the\nauthor(s) and do not necessarily reflect the views of the DARPA.  \n\nThis material is based on research sponsored by DARPA under agreement number\nFA8750-19-1-0504. The U.S. Government is authorized to reproduce and distribute\nreprints for Governmental purposes notwithstanding any copyright notation\nthereon.  \n',
    'author': 'Roni Choudhury',
    'author_email': 'roni.choudhury@kitware.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
