"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerGroup = exports.ServerGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const nlb_generated_1 = require("./nlb.generated");
Object.defineProperty(exports, "ServerGroupProperty", { enumerable: true, get: function () { return nlb_generated_1.RosServerGroup; } });
/**
 * A ROS resource type:  `ALIYUN::NLB::ServerGroup`
 */
class ServerGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::NLB::ServerGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosServerGroup = new nlb_generated_1.RosServerGroup(this, id, {
            resourceGroupId: props.resourceGroupId,
            scheduler: props.scheduler,
            addressIpVersion: props.addressIpVersion,
            servers: props.servers,
            preserveClientIpEnabled: props.preserveClientIpEnabled,
            serverGroupType: props.serverGroupType,
            persistenceEnabled: props.persistenceEnabled,
            connectionDrainEnabled: props.connectionDrainEnabled,
            connectionDrainTimeout: props.connectionDrainTimeout,
            persistenceTimeout: props.persistenceTimeout,
            vpcId: props.vpcId,
            healthCheckConfig: props.healthCheckConfig,
            protocol: props.protocol,
            serverGroupName: props.serverGroupName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosServerGroup;
        this.attrServerGroupId = rosServerGroup.attrServerGroupId;
    }
}
exports.ServerGroup = ServerGroup;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VydmVyZ3JvdXAuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzZXJ2ZXJncm91cC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQWlEO0FBRXRCLG9HQUZsQiw4QkFBYyxPQUV1QjtBQThFOUM7O0dBRUc7QUFDSCxNQUFhLFdBQVksU0FBUSxHQUFHLENBQUMsUUFBUTtJQVl6Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXVCLEVBQUUsbUNBQTJDLElBQUk7UUFDbEgsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLGNBQWMsR0FBRyxJQUFJLDhCQUFjLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNqRCxlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDdEMsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLHVCQUF1QixFQUFFLEtBQUssQ0FBQyx1QkFBdUI7WUFDdEQsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDNUMsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLHNCQUFzQjtZQUNwRCxzQkFBc0IsRUFBRSxLQUFLLENBQUMsc0JBQXNCO1lBQ3BELGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDNUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO1lBQ2xCLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7WUFDMUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtTQUN6QyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLGNBQWMsQ0FBQztRQUMvQixJQUFJLENBQUMsaUJBQWlCLEdBQUcsY0FBYyxDQUFDLGlCQUFpQixDQUFDO0lBQzlELENBQUM7Q0FDSjtBQXpDRCxrQ0F5Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XG5pbXBvcnQgeyBSb3NTZXJ2ZXJHcm91cCB9IGZyb20gJy4vbmxiLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc1NlcnZlckdyb3VwIGFzIFNlcnZlckdyb3VwUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46Ok5MQjo6U2VydmVyR3JvdXBgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU2VydmVyR3JvdXBQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBoZWFsdGhDaGVja0NvbmZpZzogSGVhbHRoIENoZWNrIENvbmZpZ1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGhlYWx0aENoZWNrQ29uZmlnOiBSb3NTZXJ2ZXJHcm91cC5IZWFsdGhDaGVja0NvbmZpZ1Byb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc2VydmVyR3JvdXBOYW1lOiBOYW1lIG9mIFNlcnZlckdyb3VwXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmVyR3JvdXBOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2cGNJZDogSUQgb2YgVlBDXG4gICAgICovXG4gICAgcmVhZG9ubHkgdnBjSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGFkZHJlc3NJcFZlcnNpb246IElQIHZlcnNpb24gb2YgYWRkcmVzc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGFkZHJlc3NJcFZlcnNpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjb25uZWN0aW9uRHJhaW5FbmFibGVkOiBXaGV0aGVyIHRvIGVuYWJsZSBncmFjZWZ1bCBjb25uZWN0aW9uIGludGVycnVwdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbm5lY3Rpb25EcmFpbkVuYWJsZWQ/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgY29ubmVjdGlvbkRyYWluVGltZW91dDogVGltZSBvZiBncmFjZWZ1bCBjb25uZWN0aW9uIGludGVycnVwdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbm5lY3Rpb25EcmFpblRpbWVvdXQ/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwZXJzaXN0ZW5jZUVuYWJsZWQ6IFdoZXRoZXIgdG8gZW5hYmxlIHNlc3Npb24gcGVyc2lzdGVuY2VcbiAgICAgKi9cbiAgICByZWFkb25seSBwZXJzaXN0ZW5jZUVuYWJsZWQ/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGVyc2lzdGVuY2VUaW1lb3V0OiBUaW1lIG9mIHNlc3Npb24gcGVyc2lzdGVuY2VcbiAgICAgKi9cbiAgICByZWFkb25seSBwZXJzaXN0ZW5jZVRpbWVvdXQ/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwcmVzZXJ2ZUNsaWVudElwRW5hYmxlZDogV2hldGhlciB0byBlbmFibGUgdGhlIGNsaWVudCBhZGRyZXNzIHJldGVudGlvbiBmdW5jdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByZXNlcnZlQ2xpZW50SXBFbmFibGVkPzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHByb3RvY29sOiBQcm90b2NvbCBvZiBTZXJ2ZXJHcm91cFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByb3RvY29sPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcmVzb3VyY2VHcm91cElkOiB1bmRlZmluZWRcbiAgICAgKi9cbiAgICByZWFkb25seSByZXNvdXJjZUdyb3VwSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzY2hlZHVsZXI6IHVuZGVmaW5lZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNjaGVkdWxlcj86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNlcnZlckdyb3VwVHlwZTogVHlwZSBvZiBTZXJ2ZXJHcm91cFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlcnZlckdyb3VwVHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNlcnZlcnM6IHVuZGVmaW5lZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlcnZlcnM/OiBBcnJheTxSb3NTZXJ2ZXJHcm91cC5TZXJ2ZXJzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIEEgUk9TIHJlc291cmNlIHR5cGU6ICBgQUxJWVVOOjpOTEI6OlNlcnZlckdyb3VwYFxuICovXG5leHBvcnQgY2xhc3MgU2VydmVyR3JvdXAgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFNlcnZlckdyb3VwSWQ6IElEIG9mIFNlcnZlckdyb3VwXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJTZXJ2ZXJHcm91cElkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6TkxCOjpTZXJ2ZXJHcm91cGAuXG4gICAgICpcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU2VydmVyR3JvdXBQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NTZXJ2ZXJHcm91cCA9IG5ldyBSb3NTZXJ2ZXJHcm91cCh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIHJlc291cmNlR3JvdXBJZDogcHJvcHMucmVzb3VyY2VHcm91cElkLFxuICAgICAgICAgICAgc2NoZWR1bGVyOiBwcm9wcy5zY2hlZHVsZXIsXG4gICAgICAgICAgICBhZGRyZXNzSXBWZXJzaW9uOiBwcm9wcy5hZGRyZXNzSXBWZXJzaW9uLFxuICAgICAgICAgICAgc2VydmVyczogcHJvcHMuc2VydmVycyxcbiAgICAgICAgICAgIHByZXNlcnZlQ2xpZW50SXBFbmFibGVkOiBwcm9wcy5wcmVzZXJ2ZUNsaWVudElwRW5hYmxlZCxcbiAgICAgICAgICAgIHNlcnZlckdyb3VwVHlwZTogcHJvcHMuc2VydmVyR3JvdXBUeXBlLFxuICAgICAgICAgICAgcGVyc2lzdGVuY2VFbmFibGVkOiBwcm9wcy5wZXJzaXN0ZW5jZUVuYWJsZWQsXG4gICAgICAgICAgICBjb25uZWN0aW9uRHJhaW5FbmFibGVkOiBwcm9wcy5jb25uZWN0aW9uRHJhaW5FbmFibGVkLFxuICAgICAgICAgICAgY29ubmVjdGlvbkRyYWluVGltZW91dDogcHJvcHMuY29ubmVjdGlvbkRyYWluVGltZW91dCxcbiAgICAgICAgICAgIHBlcnNpc3RlbmNlVGltZW91dDogcHJvcHMucGVyc2lzdGVuY2VUaW1lb3V0LFxuICAgICAgICAgICAgdnBjSWQ6IHByb3BzLnZwY0lkLFxuICAgICAgICAgICAgaGVhbHRoQ2hlY2tDb25maWc6IHByb3BzLmhlYWx0aENoZWNrQ29uZmlnLFxuICAgICAgICAgICAgcHJvdG9jb2w6IHByb3BzLnByb3RvY29sLFxuICAgICAgICAgICAgc2VydmVyR3JvdXBOYW1lOiBwcm9wcy5zZXJ2ZXJHcm91cE5hbWUsXG4gICAgICAgIH0sIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ICYmIHRoaXMuc3RhY2suZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgICAgICB0aGlzLnJlc291cmNlID0gcm9zU2VydmVyR3JvdXA7XG4gICAgICAgIHRoaXMuYXR0clNlcnZlckdyb3VwSWQgPSByb3NTZXJ2ZXJHcm91cC5hdHRyU2VydmVyR3JvdXBJZDtcbiAgICB9XG59XG4iXX0=