"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = exports.LoadBalancerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const nlb_generated_1 = require("./nlb.generated");
Object.defineProperty(exports, "LoadBalancerProperty", { enumerable: true, get: function () { return nlb_generated_1.RosLoadBalancer; } });
/**
 * A ROS resource type:  `ALIYUN::NLB::LoadBalancer`
 */
class LoadBalancer extends ros.Resource {
    /**
     * Create a new `ALIYUN::NLB::LoadBalancer`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosLoadBalancer = new nlb_generated_1.RosLoadBalancer(this, id, {
            loadBalancerName: props.loadBalancerName,
            addressIpVersion: props.addressIpVersion,
            resourceGroupId: props.resourceGroupId,
            vpcId: props.vpcId,
            loadBalancerBillingConfig: props.loadBalancerBillingConfig,
            trafficAffinityEnabled: props.trafficAffinityEnabled,
            bandwidthPackageId: props.bandwidthPackageId,
            addressType: props.addressType,
            zoneMappings: props.zoneMappings,
            crossZoneEnabled: props.crossZoneEnabled,
            loadBalancerType: props.loadBalancerType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosLoadBalancer;
        this.attrAddressIpVersion = rosLoadBalancer.attrAddressIpVersion;
        this.attrAddressType = rosLoadBalancer.attrAddressType;
        this.attrDnsName = rosLoadBalancer.attrDnsName;
        this.attrLoadBalancerId = rosLoadBalancer.attrLoadBalancerId;
        this.attrLoadBalancerType = rosLoadBalancer.attrLoadBalancerType;
        this.attrVpcId = rosLoadBalancer.attrVpcId;
        this.attrZoneMappings = rosLoadBalancer.attrZoneMappings;
    }
}
exports.LoadBalancer = LoadBalancer;
//# sourceMappingURL=data:application/json;base64,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