"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ListenerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const nlb_generated_1 = require("./nlb.generated");
Object.defineProperty(exports, "ListenerProperty", { enumerable: true, get: function () { return nlb_generated_1.RosListener; } });
/**
 * A ROS resource type:  `ALIYUN::NLB::Listener`
 */
class Listener extends ros.Resource {
    /**
     * Create a new `ALIYUN::NLB::Listener`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosListener = new nlb_generated_1.RosListener(this, id, {
            caEnabled: props.caEnabled,
            listenerPort: props.listenerPort,
            startPort: props.startPort,
            cps: props.cps,
            serverGroupId: props.serverGroupId,
            idleTimeout: props.idleTimeout,
            loadBalancerId: props.loadBalancerId,
            mss: props.mss,
            listenerProtocol: props.listenerProtocol,
            securityPolicyId: props.securityPolicyId,
            listenerDescription: props.listenerDescription,
            alpnPolicy: props.alpnPolicy,
            caCertificateIds: props.caCertificateIds,
            endPort: props.endPort,
            proxyProtocolEnabled: props.proxyProtocolEnabled,
            certificateIds: props.certificateIds,
            secSensorEnabled: props.secSensorEnabled,
            enable: props.enable,
            alpnEnabled: props.alpnEnabled,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosListener;
        this.attrListenerId = rosListener.attrListenerId;
        this.attrListenerPort = rosListener.attrListenerPort;
    }
}
exports.Listener = Listener;
//# sourceMappingURL=data:application/json;base64,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