"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EqualsAssertion = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const providers_1 = require("./providers");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Construct that creates a CustomResource to assert that two
 * values are equal
 */
class EqualsAssertion extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_EqualsAssertionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EqualsAssertion);
            }
            throw error;
        }
        const assertionProvider = new providers_1.AssertionsProvider(this, 'AssertionProvider');
        const properties = {
            actual: props.actual.result,
            expected: props.expected.result,
            failDeployment: props.failDeployment,
        };
        const resource = new core_1.CustomResource(this, 'Default', {
            serviceToken: assertionProvider.serviceToken,
            properties: {
                ...properties,
                salt: Date.now().toString(),
            },
            resourceType: providers_1.ASSERT_RESOURCE_TYPE,
        });
        this.result = resource.getAttString('data');
        new core_1.CfnOutput(this, 'AssertionResults', {
            value: this.result,
        }).overrideLogicalId(`AssertionResults${id}`);
    }
}
exports.EqualsAssertion = EqualsAssertion;
_a = JSII_RTTI_SYMBOL_1;
EqualsAssertion[_a] = { fqn: "@aws-cdk/integ-tests.EqualsAssertion", version: "1.174.0" };
//# sourceMappingURL=data:application/json;base64,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