# Spelling - spell checker for CI

[![Azure Status](https://dev.azure.com/timgates/timgates/_apis/build/status/resplendent-dev.spelling?branchName=master)](https://dev.azure.com/timgates/timgates/_build/latest?definitionId=17&branchName=master)
[![Travis Status](https://travis-ci.org/resplendent-dev/spelling.svg?branch=master)](https://travis-ci.org/resplendent-dev/spelling)
[![Appveyor Status](https://ci.appveyor.com/api/projects/status/f7vb9mbohfolu0n2/branch/master?svg=true)](https://ci.appveyor.com/project/timgates42/spelling)
[![PyPI version](https://img.shields.io/pypi/v/spelling.svg)](https://pypi.org/project/spelling)
[![Python Versions](https://img.shields.io/pypi/pyversions/spelling.svg)](https://pypi.org/project/spelling)
[![PyPI downloads per month](https://img.shields.io/pypi/dm/spelling.svg)](https://pypi.org/project/spelling)
[![Documentation Status](https://readthedocs.org/projects/spelling-dev/badge/?version=latest)](https://spelling-dev.readthedocs.io/en/latest/?badge=latest)
[![Coverage Status](https://coveralls.io/repos/github/resplendent-dev/spelling/badge.svg)](https://coveralls.io/github/resplendent-dev/spelling/)
[![Black](https://camo.githubusercontent.com/28a51fe3a2c05048d8ca8ecd039d6b1619037326/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f636f64652532307374796c652d626c61636b2d3030303030302e737667)](https://github.com/psf/black)

CI configuration engine for pyspelling using plugins like resplendent and unanimous to make CI integration easier.

More details can be found in the
[Online Documentation.](https://spelling-dev.readthedocs.io/en/latest/)

# Exemptions

If the spelling checker reports a spelling mistake which is actually a
deliberate choice an exemption can be made in a few ways:

* Words containing uppercase characters are assumed to be proper nouns and ignored.
* Escaping can be achieved through the use of back ticks \` around the word.
* Adding to a custom wordlist wordlist.txt or spelling\_wordlist.txt found in any sub-directory.
* Adding to the global wordlist https://github.com/resplendent-dev/unanimous

# Installation

You can install spelling for
[Python](https://www.python.org/) via
[pip](https://pypi.org/project/pip/)
from [PyPI](https://pypi.org/).

```
$ pip install spelling
```

Note: if using Python 3.4 the latest version of lxml only supports python 3.5 and above so install lxml 4.3.4


## Prerequisites:
- dataset<1.2.0
- pyspelling
- wcmatch<5.0
- resplendent
- unanimous>=0.6.4
- PyYAML


## Download from PyPI.org

https://pypi.org/project/spelling/



# Contributing

Contributions are very welcome, consider using the
[file an issue](https://github.com/resplendent-dev/spelling/issues)
to discuss the work before beginning, but if you already have a Pull Request
ready then this is no problem, please submit it and it will be very gratefully
considered. The [Contribution Guidelines](CONTRIBUTING.md)
outlines the spelling commitment to ensuring all
contributions receive appropriate recognition.

# License


Distributed under the terms of the [GPLv3](https://opensource.org/licenses/GPL-3.0)
license, "spelling" is free and open source software


# Issues

If you encounter any problems, please
[file an issue](https://github.com/resplendent-dev/spelling/issues)
along with a detailed description.

# Additional Documentation:

* [Online Documentation](https://spelling-dev.readthedocs.io/en/latest/)
* [News](NEWS.rst).
* [Template Updates](COOKIECUTTER_UPDATES.md).
* [Code of Conduct](CODE_OF_CONDUCT.md).
* [Contribution Guidelines](CONTRIBUTING.md).
