/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends PlainDiagram {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6wOD0AmFjCllA6nYeh4EstErPvQF9MScYM1vdb2SMCJfBY3-0FTEZ_kDz1VHbTtxfXbHwxL9EOEeFWXwmBlRGljG-byVX3bBNWHtfWGNa0AYEBf4VgGRsKwVL1bIWcUfwEzlcRYztJekL2Q9lX7AWU9-EMJWRVfidft6eD4BL1_-zf1sN_s_gRDrUIY4MRfRWH4O5OrmN5ycSw__erfKE0KxXnfs-Z6Tkg0w7AfLYSssDqMqakQEMQ6-dOzQJIwAaLAa-6iZ3RyOJ6ZCoUoJv9T-qVYbRiA7rkeQOjm1n3bJEhfkw-ryF8Zb5qby2F84Nr2im1n8ET8lejcvwK73mu6XVXVLsDB2FKzI894DBUJDFugaq7k8iylWfk5L0GA_Tr21P0ngr8Ip0tS3Akd15fqQkEfYVs5fMOVbAJsJXgSH2oyBQW4r14aCUa5dz9LRfkvvA1m9UKhYEMqLwi-2Tz0s5_IDBIK1wslxgLcIF-AKhOSq7RdF-LTd1xnhoChLRyOSaPoWAIzpGPblBL0_0Zqq9so9xrNkBCGXr4VgfW-TQmwrYd12BYaLw-Hbjhsc_w4hPx914PuE5laz-UjYKnnieQibDS0RMYKqwtm2IGtrzvSyNZhV1TUKIDmR4Mr4TWtHVp-tD3CK1-ZWDBEXcoPO1gkqwYYs888zGiS7t2Ga1-5ycbpsf-MNw2q_0V1c4a5ts0WqWT-_k3Bao8KqaAbhqrm0R3sjr8k6poCCAdG8kXLLmkbjxleP9erjoyQMPT8kdhSRZ94Vqt75XUKobyW8mnArQDOVrWxHBi5LFaxoglTCSXNWKk4zQkFUlsJ0pZ1d859ikkFnIDjY6UgmcCMUwwKkkgVRoS53jnoucqLpc54c3va6WoE9gActYFhGOFYRG5Qprnfqds1hkCuC7cQamUkfoGqrEQRXiPtbEDaYH8QvUCKf8bnGi9Tb9pcwbf1onEfnICZlH9z4f4fVA8tOkTnLU4RsACZ3UO-iUjIFAPXSG9KnJH2M5gmvGz0UjXR8m5f5psmRnEwNTYoOs_pan8f3yHKJRJTkK305PeOmRXX4eZBGAAKNdoGYyDqVTwidrpgiuxjxMZ4EaXQI2AX2cSxyGJLJJpr2qrYlyVzjhRqiEt_-jKSsEJNPQ-yXYDP1J00Yl42NSdyGmLFWwys6cO1Jh62Y9mbNhbbw6aXOi8K-k8awsMOqRxnORbmkMdj-g9AVvdQuc0s-8ST5E6YVVOaghRtKWuhOlkLTXviS1lukgWoBvB9NpsGaT1AgEBV7RZCLpLXbW1NCWTe4zkx-h4pZAMFkLo1LXYj0ljkG8QdHGmjhQbeH5m9hf7DxRsuRuep-BnZeHxJMpxrwQ3p9rVKN4uLlHmZZd4ZYSf5u8CAufUP4Wnw-2I8VL0jbO6d733jti49-Wp_66mb7xE03JZtceZpjXHnZ2zaxPu4_8NWFeO4iB5RgLSH2ASS3APA2EQjbB4FQILjmLcy0dQ9W_F_UXd1wela5cLtcrHl9N8wvbrGGwN1_5ebDIxO6vC2-bBbiwuhSphb8Xvtu7_YEyvsFg5iN4IY1A2N1QpCXtztOfzh4flHShy5nNER5mUGNiYlQ-PA1hR7OWYndCr3m902rWqA5oglmg_qJrvmpvDzxzr8OQCBpr6rquxaNJ8iLI_2KDA3c9alWslTxRh8uK3ZHsE32KdEZXqazMkPJxRXfivuCAf6xL4pq2BERbgZo4rrFgiiXKxTUKBCajAux4tJosnRaqhLppmip9EnB2W00";

    public PSystemDonors(UmlSource source) {
        super(source);
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(UTranslate.dy(header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(UTranslate.dx(x)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(new PixelImage(PSystemVersion.getPlantumlImage(), AffineTransformType.TYPE_BILINEAR));
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Transcoder t = TranscoderImpl.utf8(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        try {
            String s = t.decode(DONORS).replace('*', '.');
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
        }
        catch (NoPlantumlCompressionException e) {
            e.printStackTrace();
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create(UmlSource source) {
        return new PSystemDonors(source);
    }
}

