/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.heimdall.client.models;

import io.dataos.commons.exceptions.DataOSException;
import io.dataos.commons.mapper.ObjectMapperUtil;
import io.dataos.commons.utils.CommonUtils;
import io.dataos.heimdall.client.models.HeimdallSecretData;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J#\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u0010\u001a\u00020\u0003J\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u0010\u001a\u00020\u0003J\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u0010\u001a\u00020\u0003J\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u0010\u001a\u00020\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lio/dataos/heimdall/client/models/HeimdallSecret;", "", "id", "", "data", "", "Lio/dataos/heimdall/client/models/HeimdallSecretData;", "(Ljava/lang/String;Ljava/util/List;)V", "getData", "()Ljava/util/List;", "getId", "()Ljava/lang/String;", "component1", "component2", "convertJsonToProperties", "Ljava/util/Properties;", "key", "copy", "decodeBase64", "encoded", "equals", "", "other", "getBase64ValueForKey", "hashCode", "", "toABFSSSecrets", "Ljava/util/HashMap;", "toGCSSecrets", "toS3Secrets", "toSecretMap", "", "toSecretProperties", "toString", "toWASBSSecrets", "Companion", "heimdall"})
@SourceDebugExtension(value={"SMAP\nHeimdallSecret.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeimdallSecret.kt\nio/dataos/heimdall/client/models/HeimdallSecret\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n*L\n1#1,215:1\n1179#2,2:216\n1253#2,4:218\n30#3:222\n*S KotlinDebug\n*F\n+ 1 HeimdallSecret.kt\nio/dataos/heimdall/client/models/HeimdallSecret\n*L\n157#1:216,2\n157#1:218,4\n199#1:222\n*E\n"})
public final class HeimdallSecret {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final List<HeimdallSecretData> data;
    @NotNull
    private static final String ACCESS_KEY_ID = "awsaccesskeyid";
    @NotNull
    private static final String SECRET_KEY = "awssecretaccesskey";
    @NotNull
    private static final String AZURE_STORAGE_ACCOUNT_NAME = "azurestorageaccountname";
    @NotNull
    private static final String AZURE_STORAGE_ACCOUNT_KEY = "azurestorageaccountkey";
    @NotNull
    private static final String GCS_KEY_JSON = "gcskey_json";
    @NotNull
    private static final String JSON_KEY_FILE = "json_keyfile";
    @NotNull
    private static final String PRIVATE_KEY = "privatekey";
    @NotNull
    private static final String PRIVATE_KEY_ID = "privatekeyid";
    @NotNull
    private static final String EMAIL = "email";
    @NotNull
    private static final String GCS_CLIENT_EMAIL = "client_email";
    @NotNull
    private static final String GCS_PRIVATE_KEY_ID = "private_key_id";
    @NotNull
    private static final String GCS_PRIVATE_KEY = "private_key";
    @NotNull
    private static final String GCS_SERVICE_ACCOUNT_EMAIL = "fs.gs.auth.service.account.email";
    @NotNull
    private static final String GCS_SERVICE_PRIVATE_KEY_ID = "fs.gs.auth.service.account.private.key.id";
    @NotNull
    private static final String GCS_SERVICE_PRIVATE_KEY = "fs.gs.auth.service.account.private.key";
    @NotNull
    private static final String ABFSS_STORAGE_ACCOUNT_KEY_TEMPLATE = "fs.azure.account.key.%s.dfs.core.windows.net";
    @NotNull
    private static final String WASBS_STORAGE_ACCOUNT_KEY_TEMPLATE = "fs.azure.account.key.%s.blob.core.windows.net";
    @NotNull
    private static final String S3_ACCESS_KEY = "fs.s3a.access.key";
    @NotNull
    private static final String S3_SECRET_KEY = "fs.s3a.secret.key";

    public HeimdallSecret(@NotNull String id, @NotNull List<HeimdallSecretData> data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.id = id;
        this.data = data;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final List<HeimdallSecretData> getData() {
        return this.data;
    }

    @NotNull
    public final HashMap<String, String> toS3Secrets(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Properties props = this.toSecretProperties(key);
        String accessKey = props.getProperty(ACCESS_KEY_ID);
        String secretKey = props.getProperty(SECRET_KEY);
        HashMap<String, String> secrets = new HashMap<String, String>();
        ((Map)secrets).put(S3_ACCESS_KEY, accessKey.toString());
        ((Map)secrets).put(S3_SECRET_KEY, secretKey.toString());
        return secrets;
    }

    @NotNull
    public final HashMap<String, String> toABFSSSecrets(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Properties props = this.toSecretProperties(key);
        String storageAccountName = props.getProperty(AZURE_STORAGE_ACCOUNT_NAME);
        String storageAccountKey = props.getProperty(AZURE_STORAGE_ACCOUNT_KEY);
        String string = ABFSS_STORAGE_ACCOUNT_KEY_TEMPLATE;
        Object[] objectArray = new Object[]{storageAccountName};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String storageSparkConfKey = string2;
        HashMap<String, String> secrets = new HashMap<String, String>();
        Map map = secrets;
        Intrinsics.checkNotNullExpressionValue((Object)storageAccountKey, (String)"storageAccountKey");
        map.put(storageSparkConfKey, storageAccountKey);
        return secrets;
    }

    @NotNull
    public final HashMap<String, String> toWASBSSecrets(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Properties props = this.toSecretProperties(key);
        String storageAccountName = props.getProperty(AZURE_STORAGE_ACCOUNT_NAME);
        String storageAccountKey = props.getProperty(AZURE_STORAGE_ACCOUNT_KEY);
        String string = WASBS_STORAGE_ACCOUNT_KEY_TEMPLATE;
        Object[] objectArray = new Object[]{storageAccountName};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String storageSparkConfKey = string2;
        HashMap<String, String> secrets = new HashMap<String, String>();
        Map map = secrets;
        Intrinsics.checkNotNullExpressionValue((Object)storageAccountKey, (String)"storageAccountKey");
        map.put(storageSparkConfKey, storageAccountKey);
        return secrets;
    }

    @NotNull
    public final HashMap<String, String> toGCSSecrets(@NotNull String key) {
        String privateKeyId;
        String privateKey;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Properties props = this.toSecretProperties(key);
        String gcsKeyJson = CommonUtils.Companion.getValueOrNull(props, JSON_KEY_FILE);
        if (gcsKeyJson == null) {
            gcsKeyJson = CommonUtils.Companion.getValueOrThrow(props, GCS_KEY_JSON);
        }
        Properties jsonProperties = this.convertJsonToProperties(gcsKeyJson);
        String email = CommonUtils.Companion.getValueOrNull(props, EMAIL);
        if (email == null) {
            email = CommonUtils.Companion.getValueOrThrow(jsonProperties, GCS_CLIENT_EMAIL);
        }
        if ((privateKey = CommonUtils.Companion.getValueOrNull(props, PRIVATE_KEY)) == null) {
            privateKey = CommonUtils.Companion.getValueOrThrow(jsonProperties, GCS_PRIVATE_KEY);
        }
        if ((privateKeyId = CommonUtils.Companion.getValueOrNull(props, PRIVATE_KEY_ID)) == null) {
            privateKeyId = CommonUtils.Companion.getValueOrThrow(jsonProperties, GCS_PRIVATE_KEY_ID);
        }
        HashMap<String, String> secrets = new HashMap<String, String>();
        ((Map)secrets).put(GCS_SERVICE_ACCOUNT_EMAIL, email);
        ((Map)secrets).put(GCS_SERVICE_PRIVATE_KEY_ID, privateKeyId);
        ((Map)secrets).put(GCS_SERVICE_PRIVATE_KEY, privateKey);
        return secrets;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> toSecretMap(@NotNull String key) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Properties props = this.toSecretProperties(key);
        Set<Map.Entry<Object, Object>> set = props.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"props.entries");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, value)");
            Object key2 = entry.getKey();
            Object value = entry.getValue();
            entry = TuplesKt.to((Object)key2.toString(), (Object)value.toString());
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    private final Properties toSecretProperties(String key) {
        String props = this.decodeBase64(this.getBase64ValueForKey(key));
        Properties properties = new Properties();
        String string = props;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    private final Properties convertJsonToProperties(String key) {
        String jsonString = this.decodeBase64(this.getBase64ValueForKey(key));
        return (Properties)ObjectMapperUtil.Companion.fromJson(jsonString, Properties.class);
    }

    private final String decodeBase64(String encoded) {
        byte[] byArray = Base64.getDecoder().decode(encoded);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder().decode(encoded)");
        byte[] byArray2 = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray2, charset2);
    }

    private final String getBase64ValueForKey(String key) {
        Optional<Object> optional = this.data.stream().filter(arg_0 -> HeimdallSecret.getBase64ValueForKey$lambda$1((Function1)new Function1<HeimdallSecretData, Boolean>(key){
            final /* synthetic */ String $key;
            {
                this.$key = $key;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull HeimdallSecretData d) {
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return d.getKey().contentEquals(this.$key);
            }
        }, arg_0)).findAny();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"key: String): String {\n \u2026 }\n            .findAny()");
        Optional<Object> $this$getOrElse$iv = optional;
        boolean $i$f$getOrElse = false;
        if (!$this$getOrElse$iv.isPresent()) {
            boolean bl = false;
            throw new DataOSException("Key not found in heimdall secret response, key: " + key);
        }
        return ((HeimdallSecretData)$this$getOrElse$iv.get()).getBase64Value();
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final List<HeimdallSecretData> component2() {
        return this.data;
    }

    @NotNull
    public final HeimdallSecret copy(@NotNull String id, @NotNull List<HeimdallSecretData> data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return new HeimdallSecret(id, data);
    }

    public static /* synthetic */ HeimdallSecret copy$default(HeimdallSecret heimdallSecret, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = heimdallSecret.id;
        }
        if ((n & 2) != 0) {
            list = heimdallSecret.data;
        }
        return heimdallSecret.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "HeimdallSecret(id=" + this.id + ", data=" + this.data + ')';
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + ((Object)this.data).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HeimdallSecret)) {
            return false;
        }
        HeimdallSecret heimdallSecret = (HeimdallSecret)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)heimdallSecret.id)) {
            return false;
        }
        return Intrinsics.areEqual(this.data, heimdallSecret.data);
    }

    private static final boolean getBase64ValueForKey$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/dataos/heimdall/client/models/HeimdallSecret$Companion;", "", "()V", "ABFSS_STORAGE_ACCOUNT_KEY_TEMPLATE", "", "ACCESS_KEY_ID", "AZURE_STORAGE_ACCOUNT_KEY", "AZURE_STORAGE_ACCOUNT_NAME", "EMAIL", "GCS_CLIENT_EMAIL", "GCS_KEY_JSON", "GCS_PRIVATE_KEY", "GCS_PRIVATE_KEY_ID", "GCS_SERVICE_ACCOUNT_EMAIL", "GCS_SERVICE_PRIVATE_KEY", "GCS_SERVICE_PRIVATE_KEY_ID", "JSON_KEY_FILE", "PRIVATE_KEY", "PRIVATE_KEY_ID", "S3_ACCESS_KEY", "S3_SECRET_KEY", "SECRET_KEY", "WASBS_STORAGE_ACCOUNT_KEY_TEMPLATE", "heimdall"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

