/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.heimdall.client.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.dataos.heimdall.client.models.AuthContext;
import io.dataos.heimdall.client.models.AuthObject;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003JL\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00152\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0005J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lio/dataos/heimdall/client/models/AuthorizationRequestBatch;", "", "token", "", "contexts", "", "Lio/dataos/heimdall/client/models/AuthContext;", "(Ljava/lang/String;Ljava/util/Map;)V", "getContexts", "()Ljava/util/Map;", "getToken", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "from", "predicate", "tags", "", "paths", "metadata", "hashCode", "", "toString", "heimdall"})
public final class AuthorizationRequestBatch {
    @NotNull
    private final String token;
    @NotNull
    private final Map<String, AuthContext> contexts;

    public AuthorizationRequestBatch(@NotNull String token, @NotNull Map<String, AuthContext> contexts) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        this.token = token;
        this.contexts = contexts;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final Map<String, AuthContext> getContexts() {
        return this.contexts;
    }

    @NotNull
    public final AuthorizationRequestBatch from(@NotNull String token, @NotNull String predicate, @Nullable List<String> tags, @Nullable List<String> paths, @Nullable Map<String, ? extends Object> metadata) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return new AuthorizationRequestBatch(token, MapsKt.mapOf((Pair)TuplesKt.to((Object)predicate, (Object)new AuthContext(predicate, new AuthObject(tags, paths), metadata))));
    }

    @NotNull
    public final String component1() {
        return this.token;
    }

    @NotNull
    public final Map<String, AuthContext> component2() {
        return this.contexts;
    }

    @NotNull
    public final AuthorizationRequestBatch copy(@NotNull String token, @NotNull Map<String, AuthContext> contexts) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        return new AuthorizationRequestBatch(token, contexts);
    }

    public static /* synthetic */ AuthorizationRequestBatch copy$default(AuthorizationRequestBatch authorizationRequestBatch, String string, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = authorizationRequestBatch.token;
        }
        if ((n & 2) != 0) {
            map = authorizationRequestBatch.contexts;
        }
        return authorizationRequestBatch.copy(string, map);
    }

    @NotNull
    public String toString() {
        return "AuthorizationRequestBatch(token=" + this.token + ", contexts=" + this.contexts + ')';
    }

    public int hashCode() {
        int result = this.token.hashCode();
        result = result * 31 + ((Object)this.contexts).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthorizationRequestBatch)) {
            return false;
        }
        AuthorizationRequestBatch authorizationRequestBatch = (AuthorizationRequestBatch)other;
        if (!Intrinsics.areEqual((Object)this.token, (Object)authorizationRequestBatch.token)) {
            return false;
        }
        return Intrinsics.areEqual(this.contexts, authorizationRequestBatch.contexts);
    }
}

