/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.heimdall.client.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.dataos.heimdall.client.auth.PolicyEnforcementProviderKt;
import io.dataos.heimdall.client.models.AuthorizationAtom;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0003J(\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00030\tj\b\u0012\u0004\u0012\u00020\u0003`\u000b2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010$H\u0002J&\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010&\u001a\u00020\u00032\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010(J\t\u0010)\u001a\u00020*H\u00d6\u0001J4\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010$2\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010(2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010$J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R&\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006-"}, d2={"Lio/dataos/heimdall/client/auth/PolicyEnforcementProvider;", "", "version", "", "id", "name", "description", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "atoms", "Ljava/util/ArrayList;", "Lio/dataos/heimdall/client/models/AuthorizationAtom;", "Lkotlin/collections/ArrayList;", "getAtoms", "()Ljava/util/ArrayList;", "getDescription", "()Ljava/lang/String;", "getId", "getName", "variablePattern", "Ljava/util/regex/Pattern;", "getVersion", "addAtom", "", "atom", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "export", "file", "findVariables", "strings", "", "getAtom", "atomId", "variables", "", "hashCode", "", "replaceVariables", "toString", "heimdall"})
@SourceDebugExtension(value={"SMAP\nPolicyEnforcementProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolicyEnforcementProvider.kt\nio/dataos/heimdall/client/auth/PolicyEnforcementProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n350#2,7:173\n288#2,2:180\n*S KotlinDebug\n*F\n+ 1 PolicyEnforcementProvider.kt\nio/dataos/heimdall/client/auth/PolicyEnforcementProvider\n*L\n61#1:173,7\n83#1:180,2\n*E\n"})
public final class PolicyEnforcementProvider {
    @NotNull
    private final String version;
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @JsonProperty(value="authorization_atoms")
    @NotNull
    private final ArrayList<AuthorizationAtom> atoms;
    @NotNull
    private final Pattern variablePattern;

    public PolicyEnforcementProvider(@NotNull String version, @NotNull String id, @NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.version = version;
        this.id = id;
        this.name = name;
        this.description = description;
        this.atoms = new ArrayList();
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"\\\\$\\\\{(.+?)\\\\}\")");
        this.variablePattern = pattern;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final ArrayList<AuthorizationAtom> getAtoms() {
        return this.atoms;
    }

    public final void addAtom(@NotNull AuthorizationAtom atom) {
        int i;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            ArrayList<String> variables = this.findVariables(atom.getTags());
            variables.addAll((Collection<String>)this.findVariables(atom.getPaths()));
            atom.setVariables(CollectionsKt.distinct((Iterable)variables));
            List $this$indexOfFirst$iv = this.atoms;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                AuthorizationAtom it = (AuthorizationAtom)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)this.id, (Object)atom.getId())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = i = -1;
        }
        if (i == -1) {
            this.atoms.add(atom);
        } else {
            this.atoms.add(i, atom);
        }
    }

    public final void export(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ObjectMapper om = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper((JsonFactory)new YAMLFactory()));
        om.writeValue(new File(file), (Object)this);
    }

    @Nullable
    public final AuthorizationAtom getAtom(@NotNull String atomId, @Nullable Map<String, String> variables) {
        Object v0;
        block8: {
            Intrinsics.checkNotNullParameter((Object)atomId, (String)"atomId");
            Iterable $this$firstOrNull$iv = this.atoms;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AuthorizationAtom it = (AuthorizationAtom)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)atomId)) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        AuthorizationAtom orig = v0;
        AuthorizationAtom aa = null;
        if (orig != null) {
            aa = orig.clone();
            if (aa.hasVariables()) {
                Map<String, String> $i$f$firstOrNull = variables;
                if ($i$f$firstOrNull == null || $i$f$firstOrNull.isEmpty()) {
                    PolicyEnforcementProviderKt.access$getLog$p().warn("authorization atom {} has variables and no values were provided", (Object)atomId);
                    return null;
                }
                List<String> list = aa.getVariables();
                Intrinsics.checkNotNull(list);
                for (String v : list) {
                    String value = variables.get(v);
                    if (value == null) {
                        PolicyEnforcementProviderKt.access$getLog$p().warn("authorization atom {} has variable {} and no value was provided", (Object)atomId, (Object)v);
                        return null;
                    }
                    if (!Intrinsics.areEqual((Object)value, (Object)"")) continue;
                    PolicyEnforcementProviderKt.access$getLog$p().warn("authorization atom {} has variable {} and no value was provided", (Object)atomId, (Object)v);
                    return null;
                }
                List<String> paths = aa.getPaths();
                if ((paths = this.replaceVariables(variables, paths)) != null) {
                    aa.setPaths(paths);
                }
                List<String> tags = aa.getTags();
                if ((tags = this.replaceVariables(variables, tags)) != null) {
                    aa.setTags(tags);
                }
            }
            return aa;
        }
        return null;
    }

    @Nullable
    public final List<String> replaceVariables(@Nullable Map<String, String> variables, @Nullable List<String> strings) {
        if (strings == null) {
            return null;
        }
        ArrayList<String> nStrings = new ArrayList<String>();
        Map<String, String> map = variables;
        if (map == null || map.isEmpty()) {
            nStrings.addAll((Collection)strings);
        } else {
            for (String variable : strings) {
                Matcher matcher;
                Intrinsics.checkNotNullExpressionValue((Object)this.variablePattern.matcher(variable), (String)"variablePattern.matcher(variable)");
                int i = 0;
                StringBuilder builder = new StringBuilder();
                while (matcher.find()) {
                    String replacement = variables.get(matcher.group(1));
                    builder.append(variable, i, matcher.start());
                    CharSequence charSequence = replacement;
                    if (charSequence == null || charSequence.length() == 0) continue;
                    builder.append(replacement);
                    i = matcher.end();
                }
                builder.append(variable, i, variable.length());
                nStrings.add(builder.toString());
            }
        }
        return nStrings;
    }

    private final ArrayList<String> findVariables(List<String> strings) {
        ArrayList<String> variables = new ArrayList<String>();
        if (strings != null) {
            for (String str : strings) {
                Matcher matcher;
                Intrinsics.checkNotNullExpressionValue((Object)this.variablePattern.matcher(str), (String)"variablePattern.matcher(str)");
                while (matcher.find()) {
                    variables.add(matcher.group(1));
                }
            }
        }
        return variables;
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    @NotNull
    public final String component2() {
        return this.id;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final String component4() {
        return this.description;
    }

    @NotNull
    public final PolicyEnforcementProvider copy(@NotNull String version, @NotNull String id, @NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new PolicyEnforcementProvider(version, id, name, description);
    }

    public static /* synthetic */ PolicyEnforcementProvider copy$default(PolicyEnforcementProvider policyEnforcementProvider, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = policyEnforcementProvider.version;
        }
        if ((n & 2) != 0) {
            string2 = policyEnforcementProvider.id;
        }
        if ((n & 4) != 0) {
            string3 = policyEnforcementProvider.name;
        }
        if ((n & 8) != 0) {
            string4 = policyEnforcementProvider.description;
        }
        return policyEnforcementProvider.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "PolicyEnforcementProvider(version=" + this.version + ", id=" + this.id + ", name=" + this.name + ", description=" + this.description + ')';
    }

    public int hashCode() {
        int result = this.version.hashCode();
        result = result * 31 + this.id.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.description.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PolicyEnforcementProvider)) {
            return false;
        }
        PolicyEnforcementProvider policyEnforcementProvider = (PolicyEnforcementProvider)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)policyEnforcementProvider.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)policyEnforcementProvider.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)policyEnforcementProvider.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.description, (Object)policyEnforcementProvider.description);
    }
}

