/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.heimdall.client.auth;

import io.dataos.heimdall.client.HeimdallClient;
import io.dataos.heimdall.client.auth.AuthorizerKt;
import io.dataos.heimdall.client.auth.PolicyEnforcementProvider;
import io.dataos.heimdall.client.models.AuthResponseSingle;
import io.dataos.heimdall.client.models.AuthorizationAtom;
import io.dataos.heimdall.client.models.AuthorizationRequest;
import io.dataos.heimdall.client.models.AuthorizationRequestBatch;
import io.dataos.heimdall.client.models.AuthorizationResponse;
import io.dataos.heimdall.client.models.AuthorizationResponseBatch;
import io.dataos.heimdall.client.models.Error;
import io.dataos.heimdall.client.models.PepContext;
import io.dataos.heimdall.client.models.Tuple;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\u0007JD\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00072,\u0010\u0011\u001a(\u0012\u0004\u0012\u00020\u0007\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0007\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000f0\u00120\u000f2\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/dataos/heimdall/client/auth/Authorizer;", "", "pep", "Lio/dataos/heimdall/client/auth/PolicyEnforcementProvider;", "client", "Lio/dataos/heimdall/client/HeimdallClient;", "userAgent", "", "(Lio/dataos/heimdall/client/auth/PolicyEnforcementProvider;Lio/dataos/heimdall/client/HeimdallClient;Ljava/lang/String;)V", "authorize", "Lio/dataos/heimdall/client/models/AuthorizationResponse;", "token", "correlationId", "atomId", "variableValues", "", "Lio/dataos/heimdall/client/models/AuthorizationResponseBatch;", "batch", "Lio/dataos/heimdall/client/models/Tuple;", "heimdall"})
public final class Authorizer {
    @NotNull
    private final PolicyEnforcementProvider pep;
    @NotNull
    private final HeimdallClient client;
    @NotNull
    private final String userAgent;

    public Authorizer(@NotNull PolicyEnforcementProvider pep, @NotNull HeimdallClient client, @NotNull String userAgent) {
        Intrinsics.checkNotNullParameter((Object)pep, (String)"pep");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        this.pep = pep;
        this.client = client;
        this.userAgent = userAgent;
    }

    @NotNull
    public final AuthorizationResponse authorize(@NotNull String token, @NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        AuthorizationRequest authRequest = new AuthorizationRequest(token, null, null, 6, null);
        Response authResponse = this.client.getAuthorizeApi().authorize(authRequest, correlationId).execute();
        if (authResponse.isSuccessful()) {
            Object object = authResponse.body();
            Intrinsics.checkNotNull((Object)object);
            return (AuthorizationResponse)object;
        }
        AuthorizerKt.access$getLog$p().error((Function0)new Function0<Object>((Response<AuthorizationResponse>)authResponse){
            final /* synthetic */ Response<AuthorizationResponse> $authResponse;
            {
                this.$authResponse = $authResponse;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                AuthorizerKt.access$getLog$p().debug("authorize request successful, body={}", this.$authResponse.body());
                return this.$authResponse.errorBody();
            }
        });
        Object object = authResponse.errorBody();
        if (object == null || (object = object.string()) == null) {
            object = authResponse.message();
        }
        Object errMsg = object;
        AuthorizerKt.access$getLog$p().error((Function0)new Function0<Object>((String)errMsg){
            final /* synthetic */ String $errMsg;
            {
                this.$errMsg = $errMsg;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string = "batch authorization failed, error=%s";
                Object[] objectArray = new Object[]{this.$errMsg};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                return string2;
            }
        });
        int n = authResponse.code();
        String string = "authorization failed error=%s";
        Object[] objectArray = new Object[]{errMsg};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return new AuthorizationResponse(false, false, null, new Error(n, string2), 4, null);
    }

    @NotNull
    public final AuthorizationResponse authorize(@NotNull String token, @NotNull String atomId, @Nullable Map<String, String> variableValues, @NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)atomId, (String)"atomId");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        if (Intrinsics.areEqual((Object)token, (Object)"")) {
            return new AuthorizationResponse(false, false, null, new Error(400, "token is empty"), 4, null);
        }
        AuthorizationAtom authorizationAtom = this.pep.getAtom(atomId, variableValues);
        if (authorizationAtom == null) {
            String string = "atom not found with id %s";
            Object[] objectArray = new Object[]{atomId};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return new AuthorizationResponse(false, false, null, new Error(400, string2), 4, null);
        }
        AuthorizationAtom atom = authorizationAtom;
        AuthorizationRequest authRequest = new AuthorizationRequest(token, atom.to(), new PepContext(this.userAgent, atomId));
        Response authResponse = this.client.getAuthorizeApi().authorize(authRequest, correlationId).execute();
        if (authResponse.isSuccessful()) {
            AuthorizerKt.access$getLog$p().debug("authorize request successful, body={}", authResponse.body());
            Object object = authResponse.body();
            Intrinsics.checkNotNull((Object)object);
            return (AuthorizationResponse)object;
        }
        Object object = authResponse.errorBody();
        if (object == null || (object = object.string()) == null) {
            object = authResponse.message();
        }
        Object errMsg = object;
        AuthorizerKt.access$getLog$p().error((Function0)new Function0<Object>((String)errMsg){
            final /* synthetic */ String $errMsg;
            {
                this.$errMsg = $errMsg;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string = "authorization failed, error=%s";
                Object[] objectArray = new Object[]{this.$errMsg};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                return string2;
            }
        });
        int n = authResponse.code();
        String string = "authorization failed, error=%s";
        Object[] objectArray = new Object[]{errMsg};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return new AuthorizationResponse(false, false, null, new Error(n, string3), 4, null);
    }

    @NotNull
    public final AuthorizationResponseBatch authorize(@NotNull String token, @NotNull Map<String, Tuple<String, Map<String, String>>> batch, @NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter(batch, (String)"batch");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        if (Intrinsics.areEqual((Object)token, (Object)"")) {
            return new AuthorizationResponseBatch(null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"request", (Object)new AuthResponseSingle(false, false, new Error(400, "token is empty")))), 3, null);
        }
        HashMap contexts = new HashMap();
        for (Map.Entry<String, Tuple<String, Map<String, String>>> req : batch.entrySet()) {
            AuthorizationAtom atom;
            if (this.pep.getAtom(req.getValue().getKey(), req.getValue().getValue()) == null) {
                String string = req.getKey();
                String string2 = "atom not found with id %s";
                Object[] objectArray = new Object[]{req.getValue().getKey()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                return new AuthorizationResponseBatch(null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)new AuthResponseSingle(false, false, new Error(400, string3)))), 3, null);
            }
            ((Map)contexts).put(req.getKey(), atom.to());
        }
        AuthorizationRequestBatch authRequest = new AuthorizationRequestBatch(token, contexts);
        Response authResponse = this.client.getAuthorizeApi().authorizeBatch(authRequest, correlationId).execute();
        if (authResponse.isSuccessful()) {
            AuthorizerKt.access$getLog$p().debug("authorize request successful, body={}", authResponse.body());
            Object object = authResponse.body();
            Intrinsics.checkNotNull((Object)object);
            return (AuthorizationResponseBatch)object;
        }
        AuthorizerKt.access$getLog$p().error((Function0)new Function0<Object>((Response<AuthorizationResponseBatch>)authResponse){
            final /* synthetic */ Response<AuthorizationResponseBatch> $authResponse;
            {
                this.$authResponse = $authResponse;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string = "batch authorization failed, error=%s";
                Object[] objectArray = new Object[]{this.$authResponse.message()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                return string2;
            }
        });
        String string = "batch authorization failed, error=%s";
        Object[] objectArray = new Object[]{authResponse.message()};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        throw new Exception(string4);
    }
}

