/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.heimdall.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dataos.commons.http.client.BaseOkHttpClientBuilder;
import io.dataos.commons.mapper.ObjectMapperUtil;
import io.dataos.heimdall.client.apis.AuthorizeApi;
import io.dataos.heimdall.client.apis.DataPolicyApi;
import io.dataos.heimdall.client.apis.SecretApi;
import io.dataos.heimdall.client.apis.UsersApi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\u000eJ\u0006\u0010\u0014\u001a\u00020\u0010J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/dataos/heimdall/client/HeimdallClient;", "", "heimdallUrl", "", "httpClient", "Lokhttp3/OkHttpClient;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "authorizeApi", "Lio/dataos/heimdall/client/apis/AuthorizeApi;", "dataPolicyApi", "Lio/dataos/heimdall/client/apis/DataPolicyApi;", "secretApi", "Lio/dataos/heimdall/client/apis/SecretApi;", "userApi", "Lio/dataos/heimdall/client/apis/UsersApi;", "getAuthorizeApi", "getDataPolicyApi", "getSecretApi", "getUserApi", "prepareApis", "", "Builder", "heimdall"})
public final class HeimdallClient {
    @NotNull
    private String heimdallUrl;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final ObjectMapper mapper;
    private UsersApi userApi;
    private AuthorizeApi authorizeApi;
    private SecretApi secretApi;
    private DataPolicyApi dataPolicyApi;

    private HeimdallClient(String heimdallUrl, OkHttpClient httpClient, ObjectMapper mapper) {
        this.heimdallUrl = heimdallUrl;
        this.httpClient = httpClient;
        this.mapper = mapper;
        this.prepareApis();
    }

    private final void prepareApis() {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.heimdallUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.mapper)).client(this.httpClient).build();
        Object object = retrofit.create(UsersApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"retrofit.create(UsersApi::class.java)");
        this.userApi = (UsersApi)object;
        Object object2 = retrofit.create(SecretApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"retrofit.create(SecretApi::class.java)");
        this.secretApi = (SecretApi)object2;
        Object object3 = retrofit.create(AuthorizeApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"retrofit.create(AuthorizeApi::class.java)");
        this.authorizeApi = (AuthorizeApi)object3;
        Object object4 = retrofit.create(DataPolicyApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"retrofit.create(DataPolicyApi::class.java)");
        this.dataPolicyApi = (DataPolicyApi)object4;
    }

    @NotNull
    public final UsersApi getUserApi() {
        UsersApi usersApi = this.userApi;
        if (usersApi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userApi");
            usersApi = null;
        }
        return usersApi;
    }

    @NotNull
    public final AuthorizeApi getAuthorizeApi() {
        AuthorizeApi authorizeApi = this.authorizeApi;
        if (authorizeApi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"authorizeApi");
            authorizeApi = null;
        }
        return authorizeApi;
    }

    @NotNull
    public final SecretApi getSecretApi() {
        SecretApi secretApi = this.secretApi;
        if (secretApi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secretApi");
            secretApi = null;
        }
        return secretApi;
    }

    @NotNull
    public final DataPolicyApi getDataPolicyApi() {
        DataPolicyApi dataPolicyApi = this.dataPolicyApi;
        if (dataPolicyApi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataPolicyApi");
            dataPolicyApi = null;
        }
        return dataPolicyApi;
    }

    public /* synthetic */ HeimdallClient(String heimdallUrl, OkHttpClient httpClient, ObjectMapper mapper, DefaultConstructorMarker $constructor_marker) {
        this(heimdallUrl, httpClient, mapper);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lio/dataos/heimdall/client/HeimdallClient$Builder;", "Lio/dataos/commons/http/client/BaseOkHttpClientBuilder;", "Lio/dataos/heimdall/client/HeimdallClient;", "()V", "build", "getDefaultEnvPrefix", "", "getDefaultUserAgentSuffix", "heimdall"})
    public static final class Builder
    extends BaseOkHttpClientBuilder<HeimdallClient> {
        @NotNull
        public String getDefaultUserAgentSuffix() {
            return "heimdall";
        }

        @NotNull
        public String getDefaultEnvPrefix() {
            return "HEIMDALL";
        }

        @NotNull
        public HeimdallClient build() {
            String string = this.getUrl();
            OkHttpClient okHttpClient = this.getHttpClient();
            ObjectMapper objectMapper = this.getMapper();
            if (objectMapper == null) {
                objectMapper = ObjectMapperUtil.Companion.getMapperInstance();
            }
            return new HeimdallClient(string, okHttpClient, objectMapper, null);
        }
    }
}

