/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.spark.authz.util.functions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import io.dataos.spark.authz.exceptions.InvalidFunctionConfigException;
import io.dataos.spark.authz.exceptions.InvalidFunctionConfigException$;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Utils$ {
    public static Utils$ MODULE$;
    private final ObjectMapper MAPPER;

    static {
        new Utils$();
    }

    public ObjectMapper MAPPER() {
        return this.MAPPER;
    }

    private ObjectMapper newObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new DefaultScalaModule());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public String toJson(Object obj) {
        return this.MAPPER().writeValueAsString(obj);
    }

    public String stringOrThrow(Map<String, Object> props, String key, String functionName) {
        return this.stringOrThrowWithoutTrim(props, key, functionName).trim();
    }

    public String stringOrThrowWithoutTrim(Map<String, Object> props, String key, String funcName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            String string;
            Some some = (Some)option;
            Object value = some.value();
            try {
                string = (String)value;
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(41).append("function").append(" ").append(funcName).append(": `").append(key).append("` must be a String, message: ").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function").append(" ").append(funcName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return string;
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidFunctionConfigException(new java.lang.StringBuilder(29).append("function").append(" ").append(funcName).append(": `").append(key).append("` must be defined").toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)option);
    }

    public Option<Object> booleanOrNone(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            Object value = some2.value();
            try {
                some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value)));
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(42).append("function ").append(functionName).append(": `").append(key).append("` must be a Boolean, message: ").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return some;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public Option<String> stringOrNone(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            Object value = some2.value();
            try {
                some = new Some((Object)((String)value).trim());
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(41).append("function ").append(functionName).append(": `").append(key).append("` must be a String, message: ").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return some;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public Option<Column> columnOrNone(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            Object value = some2.value();
            try {
                some = new Some((Object)((Column)value));
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(41).append("function ").append(functionName).append(": `").append(key).append("` must be a Column, message: ").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return some;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public Object anyOrThrow(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object value = some.value();
            return value;
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidFunctionConfigException(new java.lang.StringBuilder(29).append("function ").append(functionName).append(": `").append(key).append("` must be defined").toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)option);
    }

    public Integer integerOrThrow(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Integer n;
            Some some = (Some)option;
            Object value = some.value();
            try {
                n = Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(value.toString().trim())).toInt());
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(42).append("function ").append(functionName).append(": `").append(key).append("` must be an integer, message:").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return n;
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidFunctionConfigException(new java.lang.StringBuilder(29).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be defined").toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)option);
    }

    public double doubleOrThrow(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            double d;
            Some some = (Some)option;
            Object value = some.value();
            try {
                d = new StringOps(Predef$.MODULE$.augmentString(value.toString())).toDouble();
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(38).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be double, message:").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function").append(" ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return d;
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidFunctionConfigException(new java.lang.StringBuilder(29).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be defined").toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)option);
    }

    public Seq<String> arrayOrThrow(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Seq seq;
            Some some = (Some)option;
            Object value = some.value();
            try {
                seq = (Seq)((Seq)value).toStream().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$arrayOrThrow$1(x$1)));
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(50).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be an array of string, message:").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(26).append("function").append(" ").append(functionName).append(": error message: ").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return seq;
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidFunctionConfigException(new java.lang.StringBuilder(29).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be defined").toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)option);
    }

    public List<Object> listOrThrow(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            List list;
            Some some = (Some)option;
            Object value = some.value();
            try {
                list = (List)value;
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(46).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be an list of int, message:").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(26).append("function").append(" ").append(functionName).append(": error message: ").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return list;
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidFunctionConfigException(new java.lang.StringBuilder(29).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be defined").toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)option);
    }

    public Seq<String> trimAndDiscardEmpty(Seq<String> list) {
        return (Seq)((TraversableLike)list.toStream().map((Function1 & Serializable & scala.Serializable)elem -> elem.trim(), Stream$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$trimAndDiscardEmpty$2(x$2)));
    }

    public List<String> stringArrayOrThrow(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            List list;
            Some some = (Some)option;
            Object value = some.value();
            try {
                list = (List)value;
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(49).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be an list of string, message:").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(26).append("function").append(" ").append(functionName).append(": error message: ").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return list;
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidFunctionConfigException(new java.lang.StringBuilder(29).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be defined").toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)option);
    }

    public Option<List<String>> stringArrayOrNone(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            Object value = some2.value();
            try {
                some = new Some((Object)((List)value));
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(49).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be an list of string, message:").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(26).append("function").append(" ").append(functionName).append(": error message: ").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return some;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public Map<String, String> stringMapOrThrow(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Map map;
            Some some = (Some)option;
            Object value = some.value();
            try {
                map = (Map)value;
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(53).append("function ").append(functionName).append(": `").append(key).append("` must be a Map[String,String], message: ").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return map;
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidFunctionConfigException(new java.lang.StringBuilder(29).append("function ").append(functionName).append(": `").append(key).append("` must be defined").toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)option);
    }

    public Option<Map<String, String>> stringMapOrNone(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            Object value = some2.value();
            try {
                some = new Some((Object)((Map)value));
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(53).append("function ").append(functionName).append(": `").append(key).append("` must be a Map[String,String], message: ").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return some;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public Map<String, Object> mapOrThrow(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Map map;
            Some some = (Some)option;
            Object value = some.value();
            try {
                map = (Map)value;
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(53).append("function ").append(functionName).append(": `").append(key).append("` must be a Map[String,String], message: ").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return map;
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidFunctionConfigException(new java.lang.StringBuilder(29).append("function ").append(functionName).append(": `").append(key).append("` must be defined").toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
        }
        throw new MatchError((Object)option);
    }

    public Option<Map<String, String>> mapOrNone(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            Object value = some2.value();
            try {
                some = new Some((Object)((Map)value));
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(53).append("function ").append(functionName).append(": `").append(key).append("` must be a Map[String,String], message: ").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return some;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public StructType renameAllCols(StructType schema, Function1<String, String> rename) {
        return StructType$.MODULE$.apply(Utils$.recurRename$1(schema, rename));
    }

    public Seq<String> arrayOrNone(Map<String, Object> props, String key, String functionName) {
        Option option = props.get((Object)key);
        if (option instanceof Some) {
            Seq seq;
            Some some = (Some)option;
            Object value = some.value();
            try {
                seq = (Seq)value;
            }
            catch (ClassCastException cc) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(47).append("function").append(" ").append(functionName).append(": `").append(key).append("` must be a List[String], message: ").append(cc.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            catch (Throwable ex) {
                throw new InvalidFunctionConfigException(new java.lang.StringBuilder(25).append("function").append(" ").append(functionName).append(": error message:").append(ex.getMessage()).toString(), InvalidFunctionConfigException$.MODULE$.apply$default$2());
            }
            return seq;
        }
        if (None$.MODULE$.equals(option)) {
            return (Seq)Nil$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public String mapToString(Option<Map<String, String>> map) {
        ObjectRef list = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
        Option<Map<String, String>> option = map;
        if (option instanceof Some) {
            Some some = (Some)option;
            Map map2 = (Map)some.value();
            map2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Utils$.$anonfun$mapToString$1(list, x0$1);
                return BoxedUnit.UNIT;
            });
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        return ((Seq)list.elem).mkString(",");
    }

    public ArrayList<Integer> findCharIndex(String pattern, String mask) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        String lowerCasePattern = pattern.toLowerCase();
        String lowerCaseMask = mask.toLowerCase();
        int index = 0;
        while (index != -1) {
            if ((index = lowerCasePattern.indexOf(lowerCaseMask, index)) == -1) continue;
            indexes.add(Predef$.MODULE$.int2Integer(index));
            ++index;
        }
        return indexes;
    }

    public String bucketNumber(List<Object> buckets, String columnName, String type) {
        StringBuilder sb = new StringBuilder();
        sb.append("CASE \n");
        int first = BoxesRunTime.unboxToInt((Object)buckets.head());
        sb.append(new java.lang.StringBuilder(27).append("WHEN ").append(columnName).append(" <= ").append(first).append(" THEN CAST(").append(first).append(" AS ").append(type).append(") \n").toString());
        IntRef prev = IntRef.create((int)first);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), buckets.size() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int current = BoxesRunTime.unboxToInt((Object)buckets.apply(i));
            sb.append(new java.lang.StringBuilder(35).append("WHEN ").append(columnName).append(" > ").append(prev$1.elem).append(" AND ").append(columnName).append(" <=").append(" ").append(current).append(" THEN CAST(").append(current).append(" AS ").append(type).append(") \n").toString());
            prev$1.elem = current;
        });
        long last = BoxesRunTime.unboxToInt((Object)buckets.last());
        sb.append(new java.lang.StringBuilder(17).append("ELSE CAST(").append(last).append(" AS ").append(type).append(") \n").toString());
        sb.append("END ");
        return sb.toString();
    }

    public String redact(DataType v) {
        DataType dataType = v;
        if (StringType$.MODULE$.equals(dataType)) {
            return "CAST('*** REDACTED ***' AS string)";
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return "CAST( -1 AS int)";
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return "CAST( -1 AS short)";
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return "CAST( -1 AS byte)";
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return "CAST( -1 AS long)";
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return "CAST( -1 AS float)";
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return "CAST( -1 AS double)";
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return "CAST( to_date ('0000-01-01') AS Date)";
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return "CAST(to_timestamp('0000-01-01 00:00:00.000') AS Timestamp)";
        }
        throw new Exception("Data type not supported!!");
    }

    public static final /* synthetic */ boolean $anonfun$arrayOrThrow$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$trimAndDiscardEmpty$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    private static final Seq recurRename$1(StructType schema, Function1 rename$1) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                DataType dtype = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                if (dtype instanceof StructType) {
                    StructType structType = (StructType)dtype;
                    return new StructField((String)rename$1.apply((Object)name), (DataType)StructType$.MODULE$.apply(Utils$.recurRename$1(structType, rename$1)), nullable, meta);
                }
            }
            if (structField != null) {
                ArrayType arrayType;
                String name = structField.name();
                DataType dtype = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                if (dtype instanceof ArrayType && (arrayType = (ArrayType)dtype).elementType() instanceof StructType) {
                    return new StructField((String)rename$1.apply((Object)name), (DataType)new ArrayType((DataType)StructType$.MODULE$.apply(Utils$.recurRename$1((StructType)arrayType.elementType(), rename$1)), true), nullable, meta);
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType dtype = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                return new StructField((String)rename$1.apply((Object)name), dtype, nullable, meta);
            }
            throw new MatchError((Object)structField);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public static final /* synthetic */ void $anonfun$mapToString$1(ObjectRef list$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            list$1.elem = (Seq)((Seq)list$1.elem).$colon$plus((Object)String.format("%s:%s", key, value), Seq$.MODULE$.canBuildFrom());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private Utils$() {
        MODULE$ = this;
        this.MAPPER = this.newObjectMapper();
    }
}

