/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.spark.authz.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.google.common.base.Joiner;
import io.dataos.heimdall.client.HeimdallClient;
import io.dataos.heimdall.client.apis.DataPolicyApi;
import io.dataos.heimdall.client.models.Decision;
import io.dataos.heimdall.client.models.ExternalSourceRequest;
import io.dataos.heimdall.client.models.Filter;
import io.dataos.heimdall.client.models.Mask;
import io.dataos.heimdall.client.models.MaskWrapper;
import io.dataos.spark.authz.exceptions.AccessControlException;
import io.dataos.spark.authz.exceptions.AccessControlException$;
import io.dataos.spark.authz.util.DataGovernor$;
import io.dataos.spark.authz.util.Logging;
import io.dataos.spark.authz.util.functions.Function;
import io.dataos.spark.authz.util.functions.package$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u000f\u001e\u0001!B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005k!)a\b\u0001C\u0005\u007f!9!\t\u0001b\u0001\n\u0013\u0019\u0005B\u0002'\u0001A\u0003%A\tC\u0003N\u0001\u0011\u0005a\nC\u0004f\u0001E\u0005I\u0011\u00014\t\u000bE\u0004A\u0011\u0001:\t\u0011\u0005=\u0002!%A\u0005\u0002\u0019Da!\u001d\u0001\u0005\u0002\u0005E\u0002bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!a+\u0001\t\u0013\ti\u000bC\u0005\u0002@\u0002\u0011\r\u0011\"\u0003\u0002B\"A\u00111\u001c\u0001!\u0002\u0013\t\u0019\rC\u0004\u0002^\u0002!I!!1\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\bb\u0002B\u0001\u0001\u0011%!1A\u0004\b\u0005/i\u0002\u0012\u0001B\r\r\u0019aR\u0004#\u0001\u0003\u001c!1aH\u0006C\u0001\u0005;A1Ba\b\u0017\u0001\u0004\u0005\r\u0011\"\u0003\u0003\"!Y!1\u0005\fA\u0002\u0003\u0007I\u0011\u0002B\u0013\u0011)\u0011\tD\u0006a\u0001\u0002\u0003\u0006K\u0001\u0011\u0005\b\u0005g1B\u0011\u0001B\u001b\u00051!\u0015\r^1H_Z,'O\\8s\u0015\tqr$\u0001\u0003vi&d'B\u0001\u0011\"\u0003\u0015\tW\u000f\u001e5{\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051A-\u0019;b_NT\u0011AJ\u0001\u0003S>\u001c\u0001aE\u0002\u0001S=\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0007C\u0001\u00192\u001b\u0005i\u0012B\u0001\u001a\u001e\u0005\u001daunZ4j]\u001e\fa\u0002[3j[\u0012\fG\u000e\\\"mS\u0016tG/F\u00016!\t14(D\u00018\u0015\tA\u0014(\u0001\u0004dY&,g\u000e\u001e\u0006\u0003u\r\n\u0001\u0002[3j[\u0012\fG\u000e\\\u0005\u0003y]\u0012a\u0002S3j[\u0012\fG\u000e\\\"mS\u0016tG/A\biK&lG-\u00197m\u00072LWM\u001c;!\u0003\u0019a\u0014N\\5u}Q\u0011\u0001)\u0011\t\u0003a\u0001AQaM\u0002A\u0002U\n1\u0001\\8h+\u0005!\u0005CA#K\u001b\u00051%BA$I\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0015aA8sO&\u00111J\u0012\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\fO\u0016$H)Z2jg&|g\u000e\u0006\u0003P+\n\u001c\u0007C\u0001)T\u001b\u0005\t&B\u0001*8\u0003\u0019iw\u000eZ3mg&\u0011A+\u0015\u0002\t\t\u0016\u001c\u0017n]5p]\")aK\u0002a\u0001/\u0006YA-\u0019;bg\u0016$h*Y7f!\tAvL\u0004\u0002Z;B\u0011!lK\u0007\u00027*\u0011AlJ\u0001\u0007yI|w\u000e\u001e \n\u0005y[\u0013A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!AX\u0016\t\u000bM2\u0001\u0019A\u001b\t\u000f\u00114\u0001\u0013!a\u0001/\u00061Qo]3s\u0013\u0012\fQcZ3u\t\u0016\u001c\u0017n]5p]\u0012\"WMZ1vYR$3'F\u0001hU\t9\u0006nK\u0001j!\tQw.D\u0001l\u0015\taW.A\u0005v]\u000eDWmY6fI*\u0011anK\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00019l\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0007O>4XM\u001d8\u0015\u000fM\f\t\"a\u000b\u0002.A)!\u0006\u001e<\u0002\u0010%\u0011Qo\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007):\u00180\u0003\u0002yW\t1q\n\u001d;j_:\u0004RA_@X\u0003\u0007i\u0011a\u001f\u0006\u0003yv\fq!\\;uC\ndWM\u0003\u0002\u007fW\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u0005\u00051PA\u0004ICNDW*\u00199\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003\u001e\u0003%1WO\\2uS>t7/\u0003\u0003\u0002\u000e\u0005\u001d!\u0001\u0003$v]\u000e$\u0018n\u001c8\u0011\u0007):x\u000bC\u0004\u0002\u0014!\u0001\r!!\u0006\u0002\rM\u001c\u0007.Z7b!\u0011\t9\"a\n\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tQ\u0001^=qKNTA!a\b\u0002\"\u0005\u00191/\u001d7\u000b\u0007\t\n\u0019CC\u0002\u0002&!\u000ba!\u00199bG\",\u0017\u0002BA\u0015\u00033\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011\u00151\u0006\u00021\u0001X\u0011\u001d!\u0007\u0002%AA\u0002]\u000b\u0001cZ8wKJtG\u0005Z3gCVdG\u000fJ\u001a\u0015\u0011\u0005M\u00121NA8\u0003c\u0002\u0012BKA\u001b\u0003s\tI&a\u0004\n\u0007\u0005]2F\u0001\u0004UkBdWm\r\t\u0005U]\fY\u0004\u0005\u0003\u0002>\u0005Mc\u0002BA \u0003\u001frA!!\u0011\u0002N9!\u00111IA&\u001d\u0011\t)%!\u0013\u000f\u0007i\u000b9%C\u0001J\u0013\r\t)\u0003S\u0005\u0004E\u0005\r\u0012\u0002BA\u0010\u0003CIA!!\u0015\u0002\u001e\u00059\u0001/Y2lC\u001e,\u0017\u0002BA+\u0003/\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005E\u0013Q\u0004\t\u0005U]\fY\u0006\u0005\u0004\u0002^\u0005\u0015\u00141\u0001\b\u0005\u0003?\n\u0019GD\u0002[\u0003CJ\u0011\u0001L\u0005\u0004\u0003#Z\u0013\u0002BA4\u0003S\u0012A\u0001T5ti*\u0019\u0011\u0011K\u0016\t\u000f\u00055$\u00021\u0001\u0002<\u00059\u0011N\u001c9vi\u00123\u0007\"\u0002,\u000b\u0001\u00049\u0006\"\u00023\u000b\u0001\u00049\u0016A\u0005;p\r&dG/\u001a:FqB\u0014Xm]:j_:$RaVA<\u0003sBq!a\u0005\f\u0001\u0004\t)\u0002C\u0004\u0002|-\u0001\r!! \u0002\u0015\u0019LG\u000e^3s\u0019&\u001cH\u000f\u0005\u0004\u0002^\u0005\u0015\u0014q\u0010\t\u0004!\u0006\u0005\u0015bAAB#\n1a)\u001b7uKJ\fQbZ3u\u001b\u0006\u001c8NR5mi\u0016\u0014H#B=\u0002\n\u0006-\u0005bBA\n\u0019\u0001\u0007\u0011Q\u0003\u0005\b\u0003\u001bc\u0001\u0019AAH\u00039i\u0017m]6Xe\u0006\u0004\b/\u001a:NCB\u0004r!!%\u0002\u001a^\u000bi*\u0004\u0002\u0002\u0014*\u0019a$!&\u000b\u0005\u0005]\u0015\u0001\u00026bm\u0006LA!a'\u0002\u0014\n\u0019Q*\u00199\u0011\u0007A\u000by*C\u0002\u0002\"F\u00131\"T1tW^\u0013\u0018\r\u001d9fe\u0006yAo\\*qCJ\\w\n]3sCR|'\u000fF\u0002X\u0003OCa!!+\u000e\u0001\u00049\u0016\u0001C8qKJ\fGo\u001c:\u0002\u0019%\u001c8i\\7qCRL'\r\\3\u0015\r\u0005=\u0016QWA]!\rQ\u0013\u0011W\u0005\u0004\u0003g[#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003os\u0001\u0019A,\u0002\u0015\r|G.^7o)f\u0004X\rC\u0004\u0002<:\u0001\r!!0\u0002%M,\b\u000f]8si\u0016$G)\u0019;b)f\u0004Xm\u001d\t\u0006\u0003;\n)gV\u0001\u0007\u001b\u0006\u0003\u0006+\u0012*\u0016\u0005\u0005\r\u0007\u0003BAc\u0003/l!!a2\u000b\t\u0005%\u00171Z\u0001\tI\u0006$\u0018MY5oI*!\u0011QZAh\u0003\u001dQ\u0017mY6t_:TA!!5\u0002T\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003+\f1aY8n\u0013\u0011\tI.a2\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u000f5\u000b\u0005\u000bU#SA\u0005ya.Z<PE*,7\r^'baB,'/A\u0007ue\u0006t7OZ8s[6\u000b7o\u001b\u000b\u0005\u0003G\fi\u000f\u0005\u0004Y\u0003K<\u0016q]\u0005\u0004\u00037\u000b\u0007c\u0001\u0016\u0002j&\u0019\u00111^\u0016\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002pJ\u0001\raV\u0001\u0006m\u0006dW/Z\u0001\u0012O\u0016$X*Y:l!J|\u0007/\u001a:uS\u0016\u001cHCBAr\u0003k\f9\u0010\u0003\u0004\u0002*N\u0001\ra\u0016\u0005\b\u0003s\u001c\u0002\u0019AA~\u0003\u0011i\u0017m]6\u0011\u0007A\u000bi0C\u0002\u0002\u0000F\u0013A!T1tW\u0006!\u0012\r\u001a3EK\u001a\fW\u000f\u001c;Qe>\u0004XM\u001d;jKN$\"\"a9\u0003\u0006\t%!1\u0002B\u0007\u0011\u0019\u00119\u0001\u0006a\u0001/\u000611m\u001c7v[:Da!!+\u0015\u0001\u00049\u0006bBA^)\u0001\u0007\u0011Q\u0018\u0005\b\u0005\u001f!\u0002\u0019\u0001B\t\u0003!!\u0017\r^1UsB,\u0007\u0003BA\f\u0005'IAA!\u0006\u0002\u001a\tAA)\u0019;b)f\u0004X-\u0001\u0007ECR\fwi\u001c<fe:|'\u000f\u0005\u00021-M\u0011a#\u000b\u000b\u0003\u00053\t\u0001\"\u001b8ti\u0006t7-Z\u000b\u0002\u0001\u0006a\u0011N\\:uC:\u001cWm\u0018\u0013fcR!!q\u0005B\u0017!\rQ#\u0011F\u0005\u0004\u0005WY#\u0001B+oSRD\u0001Ba\f\u001a\u0003\u0003\u0005\r\u0001Q\u0001\u0004q\u0012\n\u0014!C5ogR\fgnY3!\u0003-9W\r^%ogR\fgnY3\u0015\u0007\u0001\u00139\u0004C\u000347\u0001\u0007Q\u0007")
public class DataGovernor
implements Logging {
    private final HeimdallClient heimdallClient;
    private final Logger log;
    private final ObjectMapper MAPPER;
    private transient Logger io$dataos$spark$authz$util$Logging$$log_;

    public static DataGovernor getInstance(HeimdallClient heimdallClient) {
        return DataGovernor$.MODULE$.getInstance(heimdallClient);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger io$dataos$spark$authz$util$Logging$$log_() {
        return this.io$dataos$spark$authz$util$Logging$$log_;
    }

    @Override
    public void io$dataos$spark$authz$util$Logging$$log__$eq(Logger x$1) {
        this.io$dataos$spark$authz$util$Logging$$log_ = x$1;
    }

    public HeimdallClient heimdallClient() {
        return this.heimdallClient;
    }

    private Logger log() {
        return this.log;
    }

    public Decision getDecision(String datasetName, HeimdallClient heimdallClient, String userId) {
        Decision decision;
        DataPolicyApi dataPolicyClient = heimdallClient.getDataPolicyApi();
        Decision decision2 = null;
        try {
            Response getDecisionResponse = dataPolicyClient.getExternalTruthSourceDecision(UUID.randomUUID().toString(), new ExternalSourceRequest(datasetName, userId)).execute();
            decision = decision2 = (Decision)getDecisionResponse.body();
        }
        catch (Exception e) {
            throw new AccessControlException(new StringBuilder(31).append("Cannot receive PolicyDecision: ").append(e.getMessage()).toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
        }
        return decision;
    }

    public String getDecision$default$3() {
        return "";
    }

    public Tuple2<Option<HashMap<String, Function>>, Option<String>> govern(StructType schema, String datasetName, String userId) {
        Decision decisionClient = this.getDecision(datasetName, this.heimdallClient(), userId);
        if (decisionClient == null) {
            throw new AccessControlException("Cannot receive PolicyDecision: Verify if userId and token are valid. Also check if user has required access", AccessControlException$.MODULE$.$lessinit$greater$default$2());
        }
        Map maskWrapperMap = decisionClient.getMasks();
        Nil$ filters = decisionClient.getFilter() == null ? Nil$.MODULE$ : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(decisionClient.getFilter().getFilters()).asScala()).toList();
        String expression = this.toFilterExpression(schema, (List<Filter>)filters);
        HashMap<String, Function> maskFuncMap = this.getMaskFilter(schema, maskWrapperMap);
        return new Tuple2((Object)new Some(maskFuncMap), (Object)new Some((Object)expression));
    }

    public Tuple3<Option<Dataset<Row>>, Option<List<Function>>, Option<String>> govern(Dataset<Row> inputDf, String datasetName, String userId) {
        ObjectRef df = ObjectRef.create(inputDf);
        Decision decisionClient = this.getDecision(datasetName, this.heimdallClient(), userId);
        if (decisionClient == null) {
            throw new AccessControlException("Cannot receive PolicyDecision: Verify if user has required access", AccessControlException$.MODULE$.$lessinit$greater$default$2());
        }
        Map maskWrapperMap = decisionClient.getMasks();
        Nil$ filters = decisionClient.getFilter() == null ? Nil$.MODULE$ : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(decisionClient.getFilter().getFilters()).asScala()).toList();
        String expression = this.toFilterExpression(((Dataset)df.elem).schema(), (List<Filter>)filters);
        if (new StringOps(Predef$.MODULE$.augmentString(expression)).nonEmpty()) {
            df.elem = ((Dataset)df.elem).filter(functions$.MODULE$.expr(expression));
        }
        HashMap<String, Function> maskFuncMap = this.getMaskFilter(((Dataset)df.elem).schema(), maskWrapperMap);
        maskFuncMap.foreach((Function1 & Serializable & scala.Serializable)e -> {
            df.elem = ((Function)e._2()).execute((Dataset<Row>)((Dataset)df.elem));
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)new Some((Object)((Dataset)df.elem)), (Object)new Some((Object)maskFuncMap.values().toList()), (Object)new Some((Object)expression));
    }

    public String govern$default$3() {
        return "";
    }

    private String toFilterExpression(StructType schema, List<Filter> filterList) {
        ArrayList expressions = new ArrayList();
        java.util.List<Object> number = Arrays.asList((Object[])new String[]{"integer", "long", "float", "double", "byte", "short"});
        Some some = new Some(filterList);
        if (some != null) {
            List fList = (List)some.value();
            fList.foreach((Function1 & Serializable & scala.Serializable)filter -> {
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).contains((Object)filter.getColumn())) {
                    String columnDataType = schema.apply(filter.getColumn()).dataType().typeName();
                    if (!this.isCompatible(columnDataType, (List<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(filter.getSupportedDataTypes()).asScala()).toList())) {
                        this.logger().info(new StringBuilder(47).append("skipping filter: ").append(filter).append("; unsupported column data type").toString());
                        return BoxedUnit.UNIT;
                    }
                    Object object = columnDataType.equalsIgnoreCase("string") ? BoxesRunTime.boxToBoolean((boolean)expressions.add(new StringBuilder(4).append(filter.getColumn()).append(" ").append(this.toSparkOperator(filter.getOperator())).append(" '").append(filter.getValue()).append("'").toString())) : (number.contains(columnDataType) ? BoxesRunTime.boxToBoolean((boolean)expressions.add(new StringBuilder(2).append(filter.getColumn()).append(" ").append(this.toSparkOperator(filter.getOperator())).append(" ").append(filter.getValue()).toString())) : BoxedUnit.UNIT);
                    return expressions;
                }
                this.logger().info(new StringBuilder(48).append("skipped filter event ").append(filter).append(". due to column not exist!!").toString());
                return BoxedUnit.UNIT;
            });
            if (!expressions.isEmpty()) {
                return Joiner.on((String)" AND ").join(expressions);
            }
            return "";
        }
        return "";
    }

    private HashMap<String, Function> getMaskFilter(StructType schema, Map<String, MaskWrapper> maskWrapperMap) {
        HashMap funcList = new HashMap();
        if (maskWrapperMap == null || maskWrapperMap.isEmpty()) {
            return funcList;
        }
        maskWrapperMap.keySet().forEach(column -> {
            Mask mask = ((MaskWrapper)maskWrapperMap.get(column)).getMask();
            String operator = mask.getOperator();
            if (!operator.equalsIgnoreCase("pass_through")) {
                List supportedDataTypes = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(mask.getSupportedDataTypes()).asScala()).toList();
                scala.collection.immutable.Map properties = this.getMaskProperties(operator, mask);
                DataType dataType = schema.fields()[schema.fieldIndex(column)].dataType();
                properties = properties.$plus$plus(this.addDefaultProperties((String)column, operator, (List<String>)supportedDataTypes, dataType));
                funcList.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(column), (Object)package$.MODULE$.getGovernanceFunction((scala.collection.immutable.Map<String, Object>)properties)));
                return;
            }
        });
        return funcList;
    }

    private String toSparkOperator(String operator) {
        String string = operator;
        if ("like".equals(string)) {
            return "LIKE";
        }
        if ("not_like".equals(string)) {
            return "NOT LIKE";
        }
        if ("equals".equals(string)) {
            return "=";
        }
        if ("not_equals".equals(string)) {
            return "!=";
        }
        if ("less_than".equals(string)) {
            return "<";
        }
        if ("less_than_or_equals_to".equals(string)) {
            return "<=";
        }
        if ("greater_than".equals(string)) {
            return ">";
        }
        if ("greater_than_or_equals_to".equals(string)) {
            return ">=";
        }
        throw new IllegalStateException("Unknown operator");
    }

    private boolean isCompatible(String columnType, List<String> supportedDataTypes) {
        .colon.colon number = new .colon.colon((Object)"integer", (List)new .colon.colon((Object)"long", (List)new .colon.colon((Object)"float", (List)new .colon.colon((Object)"double", (List)new .colon.colon((Object)"byte", (List)new .colon.colon((Object)"short", (List)Nil$.MODULE$))))));
        List supDataTypes = supportedDataTypes;
        if (supportedDataTypes.contains((Object)"number")) {
            supDataTypes = (List)supDataTypes.$plus$plus((GenTraversableOnce)number, List$.MODULE$.canBuildFrom());
        }
        return supDataTypes.contains((Object)columnType);
    }

    private ObjectMapper MAPPER() {
        return this.MAPPER;
    }

    private ObjectMapper newObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        return mapper;
    }

    private scala.collection.immutable.Map<String, Object> transformMask(String value) {
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)this.MAPPER().readValue(value, scala.collection.immutable.Map.class);
        return map;
    }

    private scala.collection.immutable.Map<String, Object> getMaskProperties(String operator, Mask mask) {
        String string = operator;
        if ("hash".equals(string)) {
            return this.transformMask(this.MAPPER().writeValueAsString((Object)mask.getHash()));
        }
        if ("pass_through".equals(string)) {
            return this.transformMask(this.MAPPER().writeValueAsString((Object)mask.getPassThrough()));
        }
        if ("redact".equals(string)) {
            return this.transformMask(this.MAPPER().writeValueAsString((Object)mask.getRedact()));
        }
        if ("rand_pattern".equals(string)) {
            return this.transformMask(this.MAPPER().writeValueAsString((Object)mask.getRandPattern()));
        }
        if ("rand_regexify".equals(string)) {
            return this.transformMask(this.MAPPER().writeValueAsString((Object)mask.getRandRegexify()));
        }
        if ("bucket_date".equals(string)) {
            return this.transformMask(this.MAPPER().writeValueAsString((Object)mask.getBucketDate()));
        }
        if ("bucket_number".equals(string)) {
            return this.transformMask(this.MAPPER().writeValueAsString((Object)mask.getBucketNumber()));
        }
        if ("regex_replace".equals(string)) {
            return this.transformMask(this.MAPPER().writeValueAsString((Object)mask.getRegexReplace()));
        }
        throw new MatchError((Object)string);
    }

    private scala.collection.immutable.Map<String, Object> addDefaultProperties(String column, String operator, List<String> supportedDataTypes, DataType dataType) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"column"), (Object)column), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)operator), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"supportedDataTypes"), supportedDataTypes), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType)}));
    }

    public DataGovernor(HeimdallClient heimdallClient) {
        this.heimdallClient = heimdallClient;
        Logging.$init$(this);
        this.log = LoggerFactory.getLogger(this.getClass());
        this.MAPPER = this.newObjectMapper();
    }
}

