/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.spark.authz.util;

import io.dataos.audit.client.models.ThemisGovernAudit;
import io.dataos.heimdall.client.HeimdallClient;
import io.dataos.heimdall.client.auth.Authorizer;
import io.dataos.heimdall.client.models.AuthorizationResponse;
import io.dataos.spark.authz.exceptions.AccessControlException;
import io.dataos.spark.authz.exceptions.AccessControlException$;
import io.dataos.spark.authz.exceptions.ClientBuildException;
import io.dataos.spark.authz.exceptions.ClientBuildException$;
import io.dataos.spark.authz.exceptions.MissingConfException;
import io.dataos.spark.authz.exceptions.MissingConfException$;
import io.dataos.spark.authz.exceptions.MissingEnvVariableException;
import io.dataos.spark.authz.exceptions.MissingEnvVariableException$;
import io.dataos.spark.authz.pep.Atoms$;
import io.dataos.spark.authz.serde.CatalogDesc;
import io.dataos.spark.authz.util.EnvUtils$;
import io.dataos.spark.authz.util.Logging;
import io.dataos.spark.authz.util.SemanticVersion$;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.ResolvedTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class AuthZUtils$
implements Logging {
    public static AuthZUtils$ MODULE$;
    private transient Logger io$dataos$spark$authz$util$Logging$$log_;

    static {
        new AuthZUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger io$dataos$spark$authz$util$Logging$$log_() {
        return this.io$dataos$spark$authz$util$Logging$$log_;
    }

    @Override
    public void io$dataos$spark$authz$util$Logging$$log__$eq(Logger x$1) {
        this.io$dataos$spark$authz$util$Logging$$log_ = x$1;
    }

    public <T> T getFieldVal(Object o, String name) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Field field = o.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field.get(o);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object value = success.value();
            return (T)value;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            String candidates = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])o.getClass().getDeclaredFields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]");
            throw new RuntimeException(new StringBuilder(9).append(name).append(" not in ").append(o.getClass()).append(" ").append(candidates).toString(), e);
        }
        throw new MatchError((Object)try_);
    }

    public <T> Option<T> getFieldValOpt(Object o, String name) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.getFieldVal(o, name)).toOption();
    }

    public Object invoke(Object obj, String methodName, Seq<Tuple2<Class<?>, Object>> args) {
        Object object;
        try {
            Tuple2 tuple2 = args.unzip((Function1)Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq types = (Seq)tuple2._1();
            Seq values = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)types, (Object)values);
            Seq types2 = (Seq)tuple22._1();
            Seq values2 = (Seq)tuple22._2();
            Method method = obj.getClass().getMethod(methodName, (Class[])types2.toArray(ClassTag$.MODULE$.apply(Class.class)));
            method.setAccessible(true);
            object = method.invoke(obj, (Object[])values2.toArray(ClassTag$.MODULE$.AnyRef()));
        }
        catch (NoSuchMethodException e) {
            String candidates = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])obj.getClass().getMethods())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]");
            throw new RuntimeException(new StringBuilder(9).append(methodName).append(" not in ").append(obj.getClass()).append(" ").append(candidates).toString(), e);
        }
        return object;
    }

    public <T> T invokeAs(Object obj, String methodName, Seq<Tuple2<Class<?>, Object>> args) {
        return (T)this.invoke(obj, methodName, args);
    }

    public Object invokeStatic(Class<?> obj, String methodName, Seq<Tuple2<Class<?>, Object>> args) {
        Tuple2 tuple2 = args.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq types = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)types, (Object)values);
        Seq types2 = (Seq)tuple22._1();
        Seq values2 = (Seq)tuple22._2();
        Method method = obj.getMethod(methodName, (Class[])types2.toArray(ClassTag$.MODULE$.apply(Class.class)));
        method.setAccessible(true);
        return method.invoke(obj, (Object[])values2.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public UserGroupInformation getAuthzUgi(SparkContext spark) {
        boolean isSessionUserVerifyEnabled = spark.getConf().getBoolean(new StringBuilder(38).append("spark.").append("kyuubi.session.user.sign.enabled").toString(), false);
        String user = spark.getLocalProperty("kyuubi.session.user");
        if (isSessionUserVerifyEnabled) {
            this.verifyKyuubiSessionUser(spark, user);
        }
        if (user != null) {
            String string = user;
            String string2 = UserGroupInformation.getCurrentUser().getShortUserName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return UserGroupInformation.createRemoteUser((String)user);
            }
        }
        return UserGroupInformation.getCurrentUser();
    }

    public boolean hasResolvedHiveTable(LogicalPlan plan) {
        String string = plan.nodeName();
        String string2 = "HiveTableRelation";
        return !(string != null ? !string.equals(string2) : string2 != null) && plan.resolved();
    }

    public CatalogTable getHiveTable(LogicalPlan plan) {
        return (CatalogTable)this.getFieldVal(plan, "tableMeta");
    }

    public Option<String> extractTableOwner(CatalogTable table) {
        return Option$.MODULE$.apply((Object)table.owner()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AuthZUtils$.$anonfun$extractTableOwner$1(x$5)));
    }

    public boolean hasResolvedDatasourceTable(LogicalPlan plan) {
        String string = plan.nodeName();
        String string2 = "LogicalRelation";
        return !(string != null ? !string.equals(string2) : string2 != null) && plan.resolved();
    }

    public Option<CatalogTable> getDatasourceTable(LogicalPlan plan) {
        return (Option)this.getFieldVal(plan, "catalogTable");
    }

    public boolean hasResolvedDatasourceV2Table(LogicalPlan plan) {
        String string = plan.nodeName();
        String string2 = "DataSourceV2Relation";
        return !(string != null ? !string.equals(string2) : string2 != null) && plan.resolved();
    }

    public Option<Identifier> getDatasourceV2Identifier(LogicalPlan plan) {
        return (Option)this.getFieldVal(plan, "identifier");
    }

    public Option<String> getDatasourceV2Catalog(LogicalPlan plan) {
        return new CatalogDesc("catalog", "CatalogPluginOptionCatalogExtractor").extract(plan);
    }

    public Option<String> getDatasourceV2TableOwner(LogicalPlan plan) {
        Table table = (Table)this.getFieldVal(plan, "table");
        return Option$.MODULE$.apply(table.properties().get("owner"));
    }

    public TableIdentifier getTableIdentifierFromV2Identifier(Identifier id) {
        return new TableIdentifier(id.name(), (Option)new Some((Object)this.quote((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])id.namespace()))));
    }

    public Option<String> getTableOwnerFromV2Plan(Object child, Identifier identifier, String catalogField) {
        CatalogPlugin catalogPlugin = (CatalogPlugin)this.getFieldVal(child, catalogField);
        if (catalogPlugin instanceof TableCatalog) {
            TableCatalog tableCatalog = (TableCatalog)catalogPlugin;
            Table table = tableCatalog.loadTable(identifier);
            return Option$.MODULE$.apply(table.properties().get("owner"));
        }
        return None$.MODULE$;
    }

    public String getTableOwnerFromV2Plan$default$3() {
        return "catalog";
    }

    public boolean hasResolvedPermanentView(LogicalPlan plan) {
        View view;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof View && (view = (View)logicalPlan).resolved() && this.isSparkVersionAtLeast("3.1.0")) {
            return !BoxesRunTime.unboxToBoolean(this.getFieldVal(view, "isTempView"));
        }
        return false;
    }

    public boolean isSparkVersionAtMost(String targetVersionString) {
        return SemanticVersion$.MODULE$.apply(org.apache.spark.package$.MODULE$.SPARK_VERSION()).isVersionAtMost(targetVersionString);
    }

    public boolean isSparkVersionAtLeast(String targetVersionString) {
        return SemanticVersion$.MODULE$.apply(org.apache.spark.package$.MODULE$.SPARK_VERSION()).isVersionAtLeast(targetVersionString);
    }

    public boolean isSparkVersionEqualTo(String targetVersionString) {
        return SemanticVersion$.MODULE$.apply(org.apache.spark.package$.MODULE$.SPARK_VERSION()).isVersionEqualTo(targetVersionString);
    }

    public Function2<Option<String>, Option<String>, Object> passSparkVersionCheck() {
        return (Function2 & Serializable & scala.Serializable)(mostSparkVersion, leastSparkVersion) -> BoxesRunTime.boxToBoolean((boolean)AuthZUtils$.$anonfun$passSparkVersionCheck$1(mostSparkVersion, leastSparkVersion));
    }

    public String quoteIfNeeded(String part) {
        if (part.matches("[a-zA-Z0-9_]+") && !part.matches("\\d+")) {
            return part;
        }
        return new StringBuilder(2).append("`").append(part.replace("`", "``")).append("`").toString();
    }

    public String quote(Seq<String> parts) {
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)part -> MODULE$.quoteIfNeeded((String)part), Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    private void verifyKyuubiSessionUser(SparkContext spark, String user) {
        try {
            String userPubKeyBase64 = spark.getLocalProperty("kyuubi.session.sign.publickey");
            String userSignBase64 = spark.getLocalProperty("kyuubi.session.user.sign");
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{user, userPubKeyBase64, userSignBase64})) {
                throw AuthZUtils$.illegalAccessWithUnverifiedUser$1(user);
            }
            if (!this.verifySignWithECDSA(user, userSignBase64, userPubKeyBase64)) {
                throw AuthZUtils$.illegalAccessWithUnverifiedUser$1(user);
            }
        }
        catch (Exception exception) {
            throw AuthZUtils$.illegalAccessWithUnverifiedUser$1(user);
        }
    }

    private boolean verifySignWithECDSA(String plainText, String signatureBase64, String publicKeyBase64) {
        byte[] pubKeyBytes = Base64.getDecoder().decode(publicKeyBase64);
        ECPublicKey publicKey = (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(pubKeyBytes));
        Signature publicSignature = Signature.getInstance("SHA256withECDSA");
        publicSignature.initVerify(publicKey);
        publicSignature.update(plainText.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = Base64.getDecoder().decode(signatureBase64);
        return publicSignature.verify(signatureBytes);
    }

    /*
     * WARNING - void declaration
     */
    public HeimdallClient getHeimdallClient(String apikey, String heimdallURL) {
        void v0;
        try {
            void var3_3;
            HeimdallClient heimdallClient = (HeimdallClient)new HeimdallClient.Builder().url(heimdallURL).apikey(apikey).build();
            v0 = var3_3;
        }
        catch (Exception e) {
            throw new ClientBuildException(new StringBuilder(33).append("Failed to build Heimdall Client: ").append(e.getMessage()).toString(), ClientBuildException$.MODULE$.$lessinit$greater$default$2());
        }
        return v0;
    }

    public String getHeimdallClient$default$2() {
        return (String)package$.MODULE$.env().getOrElse((Object)"HEIMDALL_URL", (Function0 & Serializable & scala.Serializable)() -> {
            throw new MissingEnvVariableException("Missing HEIMDALL_URL env!", MissingEnvVariableException$.MODULE$.$lessinit$greater$default$2());
        });
    }

    private boolean hasValidValues(String depot, String collection, String dataset) {
        if (depot.isEmpty()) {
            throw new IllegalArgumentException("Depot cannot be empty");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("collection cannot be empty");
        }
        if (dataset.isEmpty()) {
            throw new IllegalArgumentException("dataset cannot be empty");
        }
        return true;
    }

    private String hasValidValues$default$2() {
        return "**";
    }

    private String hasValidValues$default$3() {
        return "**";
    }

    public void authorizePEPWithPlan(Authorizer authorizer, LogicalPlan plan, String apikey, String appliedOperation, String atomName) {
        this.logger().debug(new StringBuilder(30).append("<<debug>> x.getClass.getName=>").append(appliedOperation).toString());
        Seq attributesSeq = plan.allAttributes().attrs();
        if (attributesSeq != null && attributesSeq.nonEmpty()) {
            Seq qualifiedNameSeq = ((NamedExpression)attributesSeq.head()).qualifier();
            if (qualifiedNameSeq.length() != 3) {
                this.logger().error(new StringBuilder(201).append("You are not allowed to perform operations into datasource with ").append("inconsistent naming convention. Qualified name must be in three parts e.g.").append("1. depot.collection.dataset or 2. catalog.schema.table. Found - ").append(qualifiedNameSeq.toString()).toString());
                throw new AccessControlException(new StringBuilder(201).append("You are not allowed to perform operations into datasource with ").append("inconsistent naming convention. Qualified name must be in three parts e.g.").append("1. depot.collection.dataset or 2. catalog.schema.table. Found - ").append(qualifiedNameSeq.toString()).toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
            }
            String depot = (String)qualifiedNameSeq.head();
            String collection = (String)qualifiedNameSeq.apply(1);
            String dataset = (String)qualifiedNameSeq.apply(2);
            this.authorizePEP(authorizer, depot, collection, dataset, apikey, appliedOperation, atomName);
            return;
        }
    }

    public Tuple3<String, String, String> parseTableName(String tableName, String appliedOperation) {
        String[] tableParts;
        this.logger().debug(new StringBuilder(30).append("<<debug>> x.getClass.getName=>").append(appliedOperation).toString());
        if (tableName.isEmpty()) {
            this.logAndThrowError(appliedOperation, tableName);
        }
        if ((tableParts = tableName.split("\\.")).length != 3) {
            this.logAndThrowError(appliedOperation, tableParts.toString());
        }
        String depot = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableParts)).head();
        String collection = tableParts[1];
        String dataset = tableParts[2];
        return new Tuple3((Object)depot, (Object)collection, (Object)dataset);
    }

    public void authorizePEPWithResolvedTable(Authorizer authorizer, ResolvedTable table, String apikey, String appliedOperation, String atomName) {
        this.logger().debug(new StringBuilder(30).append("<<debug>> x.getClass.getName=>").append(appliedOperation).toString());
        if (table == null) {
            this.logAndThrowError(appliedOperation, table.toString());
        }
        if (table.identifier() == null) {
            this.logAndThrowError(appliedOperation, table.identifier().toString());
        }
        String depot = table.catalog().name();
        String collection = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.identifier().namespace())).head();
        String dataset = table.identifier().name();
        this.authorizePEP(authorizer, depot, collection, dataset, apikey, appliedOperation, atomName);
    }

    public void authorizePEP(Authorizer authorizer, String depot, String collection, String dataset, String apikey, String appliedOperation, String atomName) {
        if (this.hasValidValues(depot, collection, dataset)) {
            AuthorizationResponse authResponse = authorizer.authorize(apikey, atomName, (Map)new HashMap<String, String>(depot, collection, dataset){
                {
                    this.put("depot", depot$1);
                    this.put("collection", collection$1);
                    this.put("dataset", dataset$1);
                    this.put("resourceId", Atoms$.MODULE$.getDataOsResourceId());
                }
            }, UUID.randomUUID().toString());
            if (authResponse.getAllow()) {
                return;
            }
            this.logger().error(new StringBuilder(71).append("You are not allowed to perform: ").append(appliedOperation).append("; ").append("depot=").append(depot).append("; collection=").append(collection).append("; dataset=").append(dataset).append("; error=").append(authResponse.getError().getMessage()).toString());
            throw new AccessControlException(new StringBuilder(71).append("You are not allowed to perform: ").append(appliedOperation).append("; ").append("depot=").append(depot).append("; collection=").append(collection).append("; dataset=").append(dataset).append("; error=").append(authResponse.getError().getMessage()).toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private void logAndThrowError(String appliedOperation, String msg) {
        this.logger().error(new StringBuilder(184).append("You are not allowed perform ").append(appliedOperation).append(" into datasource with ").append("inconsistent naming convention. Table name must be in three parts e.g.").append("1. depot.collection.dataset or 2. catalog.schema.table. Found - ").append(msg).toString());
        throw new AccessControlException(new StringBuilder(184).append("You are not allowed perform ").append(appliedOperation).append(" into datasource with ").append("inconsistent naming convention. Table name must be in three parts e.g.").append("1. depot.collection.dataset or 2. catalog.schema.table. Found - ").append(msg).toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
    }

    public String getUserTokenFromSparkConf(SparkSession spark) {
        String userApikey = null;
        try {
            userApikey = spark.conf().get(new StringBuilder(16).append("spark.driverEnv.").append(EnvUtils$.MODULE$.DEFAULT_DATAOS_RUN_AS_APIKEY_IDENTIFIER()).toString(), "");
            if (userApikey == null || userApikey.isEmpty()) {
                throw new MissingConfException(new StringBuilder(38).append("spark.driverEnv.").append(EnvUtils$.MODULE$.DEFAULT_DATAOS_RUN_AS_APIKEY_IDENTIFIER()).append(" missing in spark conf").toString(), MissingConfException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        catch (MissingConfException e) {
            this.logger().error(e.getMessage());
            throw e;
        }
        return userApikey;
    }

    public ThemisGovernAudit asyncAuditCall(String queryString, long startTime, long endTime, long queryExecutionTime, SparkSession spark, String userName, List<String> tableName, String masks, String filters) {
        return new ThemisGovernAudit("", queryString, "", "", "", "Themis-7.1.9-21", "spark-sql", Predef$.MODULE$.long2Long(startTime), Predef$.MODULE$.long2Long(startTime), Predef$.MODULE$.long2Long(endTime), null, tableName, userName, "", "", "", "en-US", "", Predef$.MODULE$.long2Long(queryExecutionTime), masks, filters);
    }

    public static final /* synthetic */ boolean $anonfun$extractTableOwner$1(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$passSparkVersionCheck$1(Option mostSparkVersion, Option leastSparkVersion) {
        return mostSparkVersion.forall((Function1 & Serializable & scala.Serializable)targetVersionString -> BoxesRunTime.boxToBoolean((boolean)AuthZUtils$.MODULE$.isSparkVersionAtMost(targetVersionString))) && leastSparkVersion.forall((Function1 & Serializable & scala.Serializable)targetVersionString -> BoxesRunTime.boxToBoolean((boolean)AuthZUtils$.MODULE$.isSparkVersionAtLeast(targetVersionString)));
    }

    private static final Nothing$ illegalAccessWithUnverifiedUser$1(String user$1) {
        throw new AccessControlException(new StringBuilder(26).append("Invalid user identifier [").append(user$1).append("]").toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
    }

    private AuthZUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

