/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.spark.authz.extension.privileges;

import io.dataos.spark.authz.extension.privileges.OperationType$;
import io.dataos.spark.authz.extension.privileges.PrivilegeObject;
import io.dataos.spark.authz.extension.privileges.PrivilegeObject$;
import io.dataos.spark.authz.extension.privileges.PrivilegeObjectActionType$;
import io.dataos.spark.authz.extension.privileges.PrivilegeObjectType$;
import io.dataos.spark.authz.serde.Database;
import io.dataos.spark.authz.serde.DatabaseCommandSpec;
import io.dataos.spark.authz.serde.Function;
import io.dataos.spark.authz.serde.FunctionCommandSpec;
import io.dataos.spark.authz.serde.QueryDesc;
import io.dataos.spark.authz.serde.Table;
import io.dataos.spark.authz.serde.TableCommandSpec;
import io.dataos.spark.authz.serde.TableDesc;
import io.dataos.spark.authz.serde.package$;
import io.dataos.spark.authz.util.AuthZUtils$;
import io.dataos.spark.authz.util.PermanentViewMarker;
import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PrivilegesBuilder$ {
    public static PrivilegesBuilder$ MODULE$;
    private final Logger LOG;

    static {
        new PrivilegesBuilder$();
    }

    private final Logger LOG() {
        return this.LOG;
    }

    public PrivilegeObject databasePrivileges(Database db) {
        Enumeration.Value x$1 = PrivilegeObjectType$.MODULE$.DATABASE();
        Enumeration.Value x$2 = PrivilegeObjectActionType$.MODULE$.OTHER();
        String x$3 = db.database();
        String x$4 = db.database();
        Option<String> x$5 = db.catalog();
        Seq<String> x$6 = PrivilegeObject$.MODULE$.apply$default$5();
        Option<String> x$7 = PrivilegeObject$.MODULE$.apply$default$6();
        return new PrivilegeObject(x$1, x$2, x$3, x$4, x$6, x$7, x$5);
    }

    private PrivilegeObject tablePrivileges(Option<String> catalog, TableIdentifier table, Seq<String> columns, Option<String> owner, Enumeration.Value actionType) {
        return new PrivilegeObject(PrivilegeObjectType$.MODULE$.TABLE_OR_VIEW(), actionType, (String)table.database().orNull(Predef$.MODULE$.$conforms()), table.table(), columns, owner, catalog);
    }

    private Seq<String> tablePrivileges$default$3() {
        return Nil$.MODULE$;
    }

    private Option<String> tablePrivileges$default$4() {
        return None$.MODULE$;
    }

    private Enumeration.Value tablePrivileges$default$5() {
        return PrivilegeObjectActionType$.MODULE$.OTHER();
    }

    private PrivilegeObject v2TablePrivileges(Option<String> catalog, Identifier table, Seq<String> columns, Option<String> owner, Enumeration.Value actionType) {
        return new PrivilegeObject(PrivilegeObjectType$.MODULE$.TABLE_OR_VIEW(), actionType, AuthZUtils$.MODULE$.quote((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])table.namespace())), table.name(), columns, owner, catalog);
    }

    private Seq<String> v2TablePrivileges$default$3() {
        return Nil$.MODULE$;
    }

    private Option<String> v2TablePrivileges$default$4() {
        return None$.MODULE$;
    }

    private Enumeration.Value v2TablePrivileges$default$5() {
        return PrivilegeObjectActionType$.MODULE$.OTHER();
    }

    private PrivilegeObject functionPrivileges(Function function) {
        return new PrivilegeObject(PrivilegeObjectType$.MODULE$.FUNCTION(), PrivilegeObjectActionType$.MODULE$.OTHER(), (String)function.database().orNull(Predef$.MODULE$.$conforms()), function.functionName(), PrivilegeObject$.MODULE$.apply$default$5(), PrivilegeObject$.MODULE$.apply$default$6(), PrivilegeObject$.MODULE$.apply$default$7());
    }

    private Seq<NamedExpression> collectLeaves(Expression expr) {
        return expr.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                NamedExpression namedExpression;
                A1 A1 = x1;
                if (A1 instanceof NamedExpression && ((TreeNode)(namedExpression = (NamedExpression)A1)).children().isEmpty()) {
                    return (B1)namedExpression;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                NamedExpression namedExpression;
                Expression expression = x1;
                return expression instanceof NamedExpression && ((TreeNode)(namedExpression = (NamedExpression)expression)).children().isEmpty();
            }
        });
    }

    private TableIdentifier setCurrentDBIfNecessary(TableIdentifier tableIdent, SparkSession spark) {
        if (tableIdent.database().isEmpty()) {
            Some x$1 = new Some((Object)spark.catalog().currentDatabase());
            String x$2 = tableIdent.copy$default$1();
            return tableIdent.copy(x$2, (Option)x$1);
        }
        return tableIdent;
    }

    public void buildQuery(LogicalPlan plan, ArrayBuffer<PrivilegeObject> privilegeObjects, Seq<NamedExpression> projectionList, Seq<NamedExpression> conditionList) {
        LogicalPlan logicalPlan;
        while (true) {
            Seq cols;
            if ((logicalPlan = plan) instanceof Project) {
                Project project = (Project)logicalPlan;
                projectionList = project.projectList();
                plan = project.child();
                continue;
            }
            if (logicalPlan instanceof Join) {
                Join join = (Join)logicalPlan;
                Seq cols2 = (Seq)conditionList.$plus$plus((GenTraversableOnce)join.condition().map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.collectLeaves((Expression)expr)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
                this.buildQuery(join.left(), privilegeObjects, (Seq<NamedExpression>)projectionList, (Seq<NamedExpression>)cols2);
                conditionList = cols2;
                plan = join.right();
                continue;
            }
            if (logicalPlan instanceof Filter) {
                Seq cols3;
                Filter filter = (Filter)logicalPlan;
                conditionList = cols3 = (Seq)conditionList.$plus$plus(this.collectLeaves(filter.condition()), Seq$.MODULE$.canBuildFrom());
                plan = filter.child();
                continue;
            }
            if (logicalPlan instanceof Window) {
                Seq cols4;
                Window window = (Window)logicalPlan;
                Seq orderCols = (Seq)window.orderSpec().flatMap((Function1 & Serializable & scala.Serializable)orderSpec -> MODULE$.collectLeaves((Expression)orderSpec), Seq$.MODULE$.canBuildFrom());
                Seq partitionCols = (Seq)window.partitionSpec().flatMap((Function1 & Serializable & scala.Serializable)partitionSpec -> MODULE$.collectLeaves((Expression)partitionSpec), Seq$.MODULE$.canBuildFrom());
                conditionList = cols4 = (Seq)((TraversableLike)conditionList.$plus$plus((GenTraversableOnce)orderCols, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionCols, Seq$.MODULE$.canBuildFrom());
                plan = window.child();
                continue;
            }
            if (!(logicalPlan instanceof Sort)) break;
            Sort sort = (Sort)logicalPlan;
            Seq sortCols = (Seq)sort.order().flatMap((Function1 & Serializable & scala.Serializable)sortOrder -> MODULE$.collectLeaves((Expression)sortOrder), Seq$.MODULE$.canBuildFrom());
            conditionList = cols = (Seq)conditionList.$plus$plus((GenTraversableOnce)sortCols, Seq$.MODULE$.canBuildFrom());
            plan = sort.child();
        }
        if (AuthZUtils$.MODULE$.hasResolvedHiveTable(logicalPlan)) {
            this.mergeProjection$1(AuthZUtils$.MODULE$.getHiveTable(logicalPlan), logicalPlan, projectionList, privilegeObjects, conditionList);
        } else if (AuthZUtils$.MODULE$.hasResolvedDatasourceTable(logicalPlan)) {
            AuthZUtils$.MODULE$.getDatasourceTable(logicalPlan).foreach((Function1 & Serializable & scala.Serializable)t -> {
                this.mergeProjection$1(t, plan, projectionList, privilegeObjects, conditionList);
                return BoxedUnit.UNIT;
            });
        } else if (AuthZUtils$.MODULE$.hasResolvedDatasourceV2Table(logicalPlan)) {
            Option<Identifier> tableIdent = AuthZUtils$.MODULE$.getDatasourceV2Identifier(logicalPlan);
            if (tableIdent.isDefined()) {
                Option<String> catalog = AuthZUtils$.MODULE$.getDatasourceV2Catalog(logicalPlan);
                this.mergeProjectionV2Table$1(catalog, (Identifier)tableIdent.get(), plan, AuthZUtils$.MODULE$.getDatasourceV2TableOwner(logicalPlan), projectionList, privilegeObjects, conditionList);
            }
        } else {
            String string = logicalPlan.nodeName();
            String string2 = "UnresolvedRelation";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String[] parts = ((String)AuthZUtils$.MODULE$.invokeAs(logicalPlan, "tableName", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))).split("\\.");
                String db = AuthZUtils$.MODULE$.quote((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).init()));
                privilegeObjects.$plus$eq((Object)this.tablePrivileges((Option<String>)None$.MODULE$, new TableIdentifier((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last(), (Option)new Some((Object)db)), this.tablePrivileges$default$3(), this.tablePrivileges$default$4(), this.tablePrivileges$default$5()));
            } else if (logicalPlan instanceof PermanentViewMarker) {
                PermanentViewMarker permanentViewMarker = (PermanentViewMarker)logicalPlan;
                this.mergeProjection$1(permanentViewMarker.catalogTable(), plan, projectionList, privilegeObjects, conditionList);
            } else {
                logicalPlan.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                    PrivilegesBuilder$.MODULE$.buildQuery(child, (ArrayBuffer<PrivilegeObject>)privilegeObjects, (Seq<NamedExpression>)projectionList, (Seq<NamedExpression>)conditionList);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private Enumeration.Value buildCommand(LogicalPlan plan, ArrayBuffer<PrivilegeObject> inputObjs, ArrayBuffer<PrivilegeObject> outputObjs, SparkSession spark) {
        String string = plan.getClass().getName();
        if (package$.MODULE$.DB_COMMAND_SPECS().contains((Object)string)) {
            DatabaseCommandSpec desc = (DatabaseCommandSpec)package$.MODULE$.DB_COMMAND_SPECS().apply((Object)string);
            desc.databaseDescs().foreach((Function1 & Serializable & scala.Serializable)databaseDesc -> {
                BoxedUnit boxedUnit;
                block3: {
                    try {
                        Database database = databaseDesc.extract(plan);
                        if (databaseDesc.isInput()) {
                            boxedUnit = inputObjs.$plus$eq((Object)MODULE$.databasePrivileges(database));
                            break block3;
                        }
                        boxedUnit = outputObjs.$plus$eq((Object)MODULE$.databasePrivileges(database));
                    }
                    catch (Exception e) {
                        MODULE$.LOG().warn(databaseDesc.error(plan, e));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                return boxedUnit;
            });
            return desc.operationType();
        }
        if (package$.MODULE$.TABLE_COMMAND_SPECS().contains((Object)string)) {
            TableCommandSpec spec = (TableCommandSpec)package$.MODULE$.TABLE_COMMAND_SPECS().apply((Object)string);
            spec.tableDescs().foreach((Function1 & Serializable & scala.Serializable)td -> {
                if (td.isInput()) {
                    return inputObjs.$plus$plus$eq((TraversableOnce)this.getTablePriv$1((TableDesc)td, plan, spark));
                }
                return outputObjs.$plus$plus$eq((TraversableOnce)this.getTablePriv$1((TableDesc)td, plan, spark));
            });
            spec.queryDescs().foreach((Function1 & Serializable & scala.Serializable)qd -> {
                PrivilegesBuilder$.$anonfun$buildCommand$8(plan, inputObjs, qd);
                return BoxedUnit.UNIT;
            });
            return spec.operationType();
        }
        if (package$.MODULE$.FUNCTION_COMMAND_SPECS().contains((Object)string)) {
            FunctionCommandSpec spec = (FunctionCommandSpec)package$.MODULE$.FUNCTION_COMMAND_SPECS().apply((Object)string);
            spec.functionDescs().foreach((Function1 & Serializable & scala.Serializable)fd -> {
                BoxedUnit boxedUnit;
                block3: {
                    try {
                        Function function = fd.extract(plan);
                        if (!fd.functionTypeDesc().exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.skip(plan, spark)))) {
                            boxedUnit = fd.isInput() ? inputObjs.$plus$eq((Object)MODULE$.functionPrivileges(function)) : outputObjs.$plus$eq((Object)MODULE$.functionPrivileges(function));
                            break block3;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Exception e) {
                        MODULE$.LOG().warn(fd.error(plan, e));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                return boxedUnit;
            });
            return spec.operationType();
        }
        return OperationType$.MODULE$.QUERY();
    }

    public Tuple3<Seq<PrivilegeObject>, Seq<PrivilegeObject>, Enumeration.Value> build(LogicalPlan plan, SparkSession spark) {
        Enumeration.Value value;
        ArrayBuffer inputObjs = new ArrayBuffer();
        ArrayBuffer outputObjs = new ArrayBuffer();
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof Command) {
            Command command = (Command)logicalPlan;
            value = this.buildCommand((LogicalPlan)command, (ArrayBuffer<PrivilegeObject>)inputObjs, (ArrayBuffer<PrivilegeObject>)outputObjs, spark);
        } else {
            this.buildQuery(plan, (ArrayBuffer<PrivilegeObject>)inputObjs, this.buildQuery$default$3(), this.buildQuery$default$4());
            value = OperationType$.MODULE$.QUERY();
        }
        Enumeration.Value opType = value;
        return new Tuple3((Object)inputObjs, (Object)outputObjs, (Object)opType);
    }

    public Seq<NamedExpression> buildQuery$default$3() {
        return Nil$.MODULE$;
    }

    public Seq<NamedExpression> buildQuery$default$4() {
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$buildQuery$2(LogicalPlan plan$1, NamedExpression elem) {
        return plan$1.outputSet().contains(elem);
    }

    private final void mergeProjection$1(CatalogTable table, LogicalPlan plan, Seq projectionList$1, ArrayBuffer privilegeObjects$1, Seq conditionList$1) {
        Option<String> tableOwner = AuthZUtils$.MODULE$.extractTableOwner(table);
        if (projectionList$1.isEmpty()) {
            privilegeObjects$1.$plus$eq((Object)this.tablePrivileges((Option<String>)None$.MODULE$, table.identifier(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])table.schema().fieldNames()), tableOwner, this.tablePrivileges$default$5()));
            return;
        }
        Seq cols = (Seq)((SeqLike)((TraversableLike)((TraversableLike)((TraversableLike)projectionList$1.$plus$plus((GenTraversableOnce)conditionList$1, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)expr -> MODULE$.collectLeaves((Expression)expr), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)PrivilegesBuilder$.$anonfun$buildQuery$2(plan, elem)))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).distinct();
        privilegeObjects$1.$plus$eq((Object)this.tablePrivileges((Option<String>)None$.MODULE$, table.identifier(), (Seq<String>)cols, tableOwner, this.tablePrivileges$default$5()));
    }

    public static final /* synthetic */ boolean $anonfun$buildQuery$6(LogicalPlan plan$2, NamedExpression elem) {
        return plan$2.outputSet().contains(elem);
    }

    private final void mergeProjectionV2Table$1(Option catalog, Identifier table, LogicalPlan plan, Option owner, Seq projectionList$1, ArrayBuffer privilegeObjects$1, Seq conditionList$1) {
        if (projectionList$1.isEmpty()) {
            privilegeObjects$1.$plus$eq((Object)this.v2TablePrivileges((Option<String>)catalog, table, (Seq<String>)((Seq)plan.output().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())), (Option<String>)owner, this.v2TablePrivileges$default$5()));
            return;
        }
        Seq cols = (Seq)((SeqLike)((TraversableLike)((TraversableLike)((TraversableLike)projectionList$1.$plus$plus((GenTraversableOnce)conditionList$1, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)expr -> MODULE$.collectLeaves((Expression)expr), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)PrivilegesBuilder$.$anonfun$buildQuery$6(plan, elem)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).distinct();
        privilegeObjects$1.$plus$eq((Object)this.v2TablePrivileges((Option<String>)catalog, table, (Seq<String>)cols, (Option<String>)owner, this.v2TablePrivileges$default$5()));
    }

    private static final Option mergeProjectionV2Table$default$4$1() {
        return None$.MODULE$;
    }

    private final Seq getTablePriv$1(TableDesc tableDesc, LogicalPlan plan$4, SparkSession spark$1) {
        Nil$ nil$;
        block7: {
            try {
                Option<Table> maybeTable;
                Option<Table> option = maybeTable = tableDesc.extract(plan$4, spark$1);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Table table = (Table)some.value();
                    TableIdentifier identifier = new TableIdentifier(table.table(), table.database());
                    if (tableDesc.setCurrentDatabaseIfMissing()) {
                        identifier = this.setCurrentDBIfNecessary(identifier, spark$1);
                    }
                    if (tableDesc.tableTypeDesc().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.skip(plan$4)))) {
                        nil$ = Nil$.MODULE$;
                    } else {
                        Enumeration.Value actionType = (Enumeration.Value)tableDesc.actionTypeDesc().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.extract(plan$4)).getOrElse((Function0 & Serializable & scala.Serializable)() -> PrivilegeObjectActionType$.MODULE$.OTHER());
                        Seq columnNames = (Seq)tableDesc.columnDesc().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.extract(plan$4)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                        nil$ = (Seq)new .colon.colon((Object)this.tablePrivileges(table.catalog(), identifier, (Seq<String>)columnNames, table.owner(), actionType), (List)Nil$.MODULE$);
                    }
                    break block7;
                }
                if (None$.MODULE$.equals(option)) {
                    nil$ = Nil$.MODULE$;
                    break block7;
                }
                throw new MatchError(option);
            }
            catch (Exception e) {
                this.LOG().warn(tableDesc.error(plan$4, e));
                nil$ = Nil$.MODULE$;
            }
        }
        return nil$;
    }

    public static final /* synthetic */ void $anonfun$buildCommand$8(LogicalPlan plan$4, ArrayBuffer inputObjs$1, QueryDesc qd) {
        try {
            MODULE$.buildQuery(qd.extract(plan$4), (ArrayBuffer<PrivilegeObject>)inputObjs$1, MODULE$.buildQuery$default$3(), MODULE$.buildQuery$default$4());
        }
        catch (Exception e) {
            MODULE$.LOG().warn(qd.error(plan$4, e));
        }
    }

    private PrivilegesBuilder$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

