/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.spark.authz.extension;

import io.dataos.heimdall.client.HeimdallClient;
import io.dataos.spark.authz.exceptions.AccessControlException;
import io.dataos.spark.authz.exceptions.AccessControlException$;
import io.dataos.spark.authz.extension.privileges.IcebergCommands$;
import io.dataos.spark.authz.util.AuthZUtils$;
import io.dataos.spark.authz.util.DataGovernor$;
import io.dataos.spark.authz.util.EnvUtils$;
import io.dataos.spark.authz.util.PermanentViewMarker;
import io.dataos.spark.authz.util.RowFilterAndDataMaskingMarker;
import io.dataos.spark.authz.util.functions.Function;
import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d4A\u0001C\u0005\u0001)!Aa\u0002\u0001B\u0001B\u0003%A\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u00036\u0001\u0011%a\u0007C\u0003C\u0001\u0011\u00053\tC\u0003F\u0001\u0011\u0005a\tC\u0003I\u0001\u0011%\u0011\nC\u0003I\u0001\u0011%aL\u0001\u0011Sk2,\u0017\t\u001d9msJ{wOR5mi\u0016\u0014\u0018I\u001c3ECR\fW*Y:lS:<'B\u0001\u0006\f\u0003%)\u0007\u0010^3og&|gN\u0003\u0002\r\u001b\u0005)\u0011-\u001e;iu*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta\u0001Z1uC>\u001c(\"\u0001\n\u0002\u0005%|7\u0001A\n\u0003\u0001U\u00012A\u0006\u0012%\u001b\u00059\"B\u0001\r\u001a\u0003\u0015\u0011X\u000f\\3t\u0015\tQ2$\u0001\u0005dCR\fG._:u\u0015\taR$A\u0002tc2T!A\u0004\u0010\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\u0005\u0003G]\u0011AAU;mKB\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\bY><\u0017nY1m\u0015\tI\u0013$A\u0003qY\u0006t7/\u0003\u0002,M\tYAj\\4jG\u0006d\u0007\u000b\\1o!\tic&D\u0001\u001c\u0013\ty3D\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003eQ\u0002\"a\r\u0001\u000e\u0003%AQA\u0004\u0002A\u00021\nq\"\\1q!2\fgn\u00115jY\u0012\u0014XM\u001c\u000b\u0003o\u0001#\"\u0001\n\u001d\t\u000be\u001a\u0001\u0019\u0001\u001e\u0002\u0003\u0019\u0004Ba\u000f %I5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDHA\u0005Gk:\u001cG/[8oc!)\u0011i\u0001a\u0001I\u0005!\u0001\u000f\\1o\u0003\u0015\t\u0007\u000f\u001d7z)\t!C\tC\u0003B\t\u0001\u0007A%\u0001\tbaBd\u0017PU3dkJ\u001c\u0018N^3msR\u0011Ae\u0012\u0005\u0006\u0003\u0016\u0001\r\u0001J\u0001\u0016CB\u0004H.\u001f$jYR,'/\u00118e\u001b\u0006\u001c8.\u001b8h)\u0015!#jS+W\u0011\u0015\te\u00011\u0001%\u0011\u0015ae\u00011\u0001N\u0003)IG-\u001a8uS\u001aLWM\u001d\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bqaY1uC2|wM\u0003\u0002S7\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003)>\u0013!\"\u00133f]RLg-[3s\u0011\u0015qa\u00011\u0001-\u0011\u00159f\u00011\u0001Y\u0003\u0019\u00198\r[3nCB\u0011\u0011\fX\u0007\u00025*\u00111lG\u0001\u0006if\u0004Xm]\u0005\u0003;j\u0013!b\u0015;sk\u000e$H+\u001f9f)\u0015!s\fY3g\u0011\u0015\tu\u00011\u0001%\u0011\u0015au\u00011\u0001b!\t\u00117-D\u0001\u001a\u0013\t!\u0017DA\bUC\ndW-\u00133f]RLg-[3s\u0011\u0015qq\u00011\u0001-\u0011\u00159v\u00011\u0001Y\u0001")
public class RuleApplyRowFilterAndDataMasking
extends Rule<LogicalPlan> {
    private final SparkSession spark;

    private LogicalPlan mapPlanChildren(LogicalPlan plan, Function1<LogicalPlan, LogicalPlan> f) {
        Seq seq;
        LogicalPlan logicalPlan = plan;
        if (IcebergCommands$.MODULE$.accept(plan.nodeName())) {
            Seq<LogicalPlan> skipped = IcebergCommands$.MODULE$.skipMappedChildren(plan);
            seq = (Seq)skipped.$plus$plus((GenTraversableOnce)((TraversableLike)plan.children().diff(skipped)).map(f, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)plan.children().map(f, Seq$.MODULE$.canBuildFrom());
        }
        Seq newChildren = seq;
        return (LogicalPlan)plan.withNewChildren(newChildren);
    }

    public LogicalPlan apply(LogicalPlan plan) {
        LogicalPlan finalPlan = this.applyRecursively(plan);
        return finalPlan;
    }

    public LogicalPlan applyRecursively(LogicalPlan plan) {
        return this.mapPlanChildren(plan, (Function1<LogicalPlan, LogicalPlan>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogicalPlan logicalPlan = x0$1;
            if (logicalPlan instanceof RowFilterAndDataMaskingMarker) {
                RowFilterAndDataMaskingMarker rowFilterAndDataMaskingMarker = (RowFilterAndDataMaskingMarker)logicalPlan;
                return rowFilterAndDataMaskingMarker;
            }
            if (AuthZUtils$.MODULE$.hasResolvedHiveTable(logicalPlan)) {
                CatalogTable table = AuthZUtils$.MODULE$.getHiveTable(logicalPlan);
                return this.applyFilterAndMasking(logicalPlan, table.identifier(), $this.spark, new StructType());
            }
            if (AuthZUtils$.MODULE$.hasResolvedDatasourceTable(logicalPlan)) {
                Option<CatalogTable> table = AuthZUtils$.MODULE$.getDatasourceTable(logicalPlan);
                if (table.isEmpty()) {
                    return logicalPlan;
                }
                return this.applyFilterAndMasking(logicalPlan, ((CatalogTable)table.get()).identifier(), $this.spark, new StructType());
            }
            if (AuthZUtils$.MODULE$.hasResolvedDatasourceV2Table(logicalPlan)) {
                Option<Identifier> tableIdentifier = AuthZUtils$.MODULE$.getDatasourceV2Identifier(logicalPlan);
                if (tableIdentifier.isEmpty()) {
                    return logicalPlan;
                }
                return this.applyFilterAndMasking(logicalPlan, (Identifier)tableIdentifier.get(), $this.spark, logicalPlan.schema());
            }
            if (logicalPlan instanceof PermanentViewMarker) {
                PermanentViewMarker permanentViewMarker = (PermanentViewMarker)logicalPlan;
                TableIdentifier viewIdent = permanentViewMarker.catalogTable().identifier();
                return this.applyFilterAndMasking((LogicalPlan)permanentViewMarker, viewIdent, $this.spark, new StructType());
            }
            return this.applyRecursively(logicalPlan);
        });
    }

    private LogicalPlan applyFilterAndMasking(LogicalPlan plan, Identifier identifier, SparkSession spark, StructType schema) {
        return this.applyFilterAndMasking(plan, AuthZUtils$.MODULE$.getTableIdentifierFromV2Identifier(identifier), spark, schema);
    }

    private LogicalPlan applyFilterAndMasking(LogicalPlan plan, TableIdentifier identifier, SparkSession spark, StructType schema) {
        Project project;
        if (!(plan instanceof DataSourceV2Relation)) {
            return plan;
        }
        LogicalPlan logicalPlan = plan;
        if (!(logicalPlan instanceof DataSourceV2Relation)) {
            if (logicalPlan != null) {
                LogicalPlan logicalPlan2 = logicalPlan;
                throw new AccessControlException(new StringBuilder(23).append("Unknown relation type: ").append(logicalPlan2).toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError((Object)logicalPlan);
        }
        DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)logicalPlan;
        String catalogName = ((CatalogPlugin)dataSourceV2Relation.catalog().get()).name();
        String datasetName = new StringBuilder(2).append(catalogName).append(".").append(identifier.database().get()).append(".").append(identifier.table()).toString();
        String userApikey = null;
        try {
            userApikey = spark.conf().get(new StringBuilder(16).append("spark.driverEnv.").append(EnvUtils$.MODULE$.DEFAULT_DATAOS_RUN_AS_APIKEY_IDENTIFIER()).toString());
        }
        catch (Exception exception) {
            throw new AccessControlException(new StringBuilder(24).append("Missing spark.driverEnv.").append(EnvUtils$.MODULE$.DEFAULT_DATAOS_RUN_AS_APIKEY_IDENTIFIER()).toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
        }
        String userName = null;
        try {
            userName = spark.conf().get(new StringBuilder(16).append("spark.driverEnv.").append(EnvUtils$.MODULE$.DEFAULT_DATAOS_RUN_AS_USER_IDENTIFIER()).toString());
        }
        catch (Exception exception) {
            throw new AccessControlException(new StringBuilder(24).append("Missing spark.driverEnv.").append(EnvUtils$.MODULE$.DEFAULT_DATAOS_RUN_AS_USER_IDENTIFIER()).toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
        }
        HeimdallClient heimdallClient = AuthZUtils$.MODULE$.getHeimdallClient(userApikey, AuthZUtils$.MODULE$.getHeimdallClient$default$2());
        Tuple2<Option<HashMap<String, Function>>, Option<String>> filtersAndMasks = DataGovernor$.MODULE$.getInstance(heimdallClient).govern(schema, datasetName, userName);
        HashMap masks = (HashMap)((Option)filtersAndMasks._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> HashMap$.MODULE$.empty());
        String filters = (String)((Option)filtersAndMasks._2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Function1 & Serializable & scala.Serializable parse = (Function1 & Serializable & scala.Serializable)sqlText -> spark.sessionState().sqlParser().parseExpression(sqlText);
        Seq newOutput = (Seq)plan.output().map((Function1 & Serializable & scala.Serializable)attr -> {
            Option maskExprStr;
            Option option;
            Option option2 = masks.get((Object)attr.name());
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Function fn = (Function)some.value();
                Option<String> option3 = fn.expression(attr.dataType().typeName());
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    String exprStr = (String)some2.value();
                    option = new Some((Object)exprStr);
                } else {
                    option = Option$.MODULE$.empty();
                }
            } else {
                option = Option$.MODULE$.empty();
            }
            Option option4 = maskExprStr = option;
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                String expr = (String)some.value();
                Expression maskExpr = (Expression)parse.apply((Object)expr);
                LogicalPlan logicalPlan = plan;
                if (logicalPlan instanceof PermanentViewMarker) {
                    Expression x$1 = maskExpr;
                    String x$2 = attr.name();
                    ExprId x$3 = attr.exprId();
                    Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                    Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                    Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                    return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
                }
                if (logicalPlan instanceof DataSourceV2Relation) {
                    Expression x$7 = maskExpr;
                    String x$8 = attr.name();
                    ExprId x$9 = attr.exprId();
                    Seq x$10 = Alias$.MODULE$.apply$default$4(x$7, x$8);
                    Option x$11 = Alias$.MODULE$.apply$default$5(x$7, x$8);
                    Seq x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
                    return new Alias(x$7, x$8, x$9, x$10, x$11, x$12);
                }
                Expression x$13 = maskExpr;
                String x$14 = attr.name();
                ExprId x$15 = Alias$.MODULE$.apply$default$3(x$13, x$14);
                Seq x$16 = Alias$.MODULE$.apply$default$4(x$13, x$14);
                Option x$17 = Alias$.MODULE$.apply$default$5(x$13, x$14);
                Seq x$18 = Alias$.MODULE$.apply$default$6(x$13, x$14);
                return new Alias(x$13, x$14, x$15, x$16, x$17, x$18);
            }
            return attr;
        }, Seq$.MODULE$.canBuildFrom());
        Seq seqAttributeReference = (Seq)plan.output().map((Function1 & Serializable & scala.Serializable)a -> {
            if (masks.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RuleApplyRowFilterAndDataMasking.$anonfun$applyFilterAndMasking$6(a, x0$1)))) {
                String x$19 = a.name();
                DataType x$20 = a.dataType();
                boolean x$21 = a.nullable();
                Metadata x$22 = a.metadata();
                ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, x$20, x$21, x$22);
                Seq x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, x$20, x$21, x$22);
                return new AttributeReference(x$19, x$20, x$21, x$22, x$23, x$24);
            }
            return new AttributeReference(a.name(), a.dataType(), a.nullable(), a.metadata(), a.exprId(), a.qualifier());
        }, Seq$.MODULE$.canBuildFrom());
        DataSourceV2Relation v2Relation = new DataSourceV2Relation(((DataSourceV2Relation)plan).table(), seqAttributeReference, ((DataSourceV2Relation)plan).catalog(), ((DataSourceV2Relation)plan).identifier(), ((DataSourceV2Relation)plan).options());
        if (filters.isEmpty()) {
            project = new Project(newOutput, (LogicalPlan)new RowFilterAndDataMaskingMarker((LogicalPlan)v2Relation));
        } else {
            Expression filterExpr = (Expression)parse.apply((Object)filters);
            project = new Project(newOutput, (LogicalPlan)new Filter(filterExpr, (LogicalPlan)new RowFilterAndDataMaskingMarker((LogicalPlan)v2Relation)));
        }
        Project afterFilter = project;
        return afterFilter;
    }

    public static final /* synthetic */ boolean $anonfun$applyFilterAndMasking$6(Attribute a$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.toLowerCase().equalsIgnoreCase(a$1.name());
        }
        throw new MatchError((Object)tuple2);
    }

    public RuleApplyRowFilterAndDataMasking(SparkSession spark) {
        this.spark = spark;
    }
}

