/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.spark.authz.extension;

import io.dataos.commons.exceptions.InvalidArgumentException;
import io.dataos.heimdall.client.HeimdallClient;
import io.dataos.heimdall.client.auth.Authorizer;
import io.dataos.spark.authz.exceptions.MissingEnvVariableException;
import io.dataos.spark.authz.pep.Atoms;
import io.dataos.spark.authz.pep.PolicyEnforcementSpecProvider;
import io.dataos.spark.authz.util.AuthZUtils;
import java.util.Map;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataosSparkCatalog
extends SparkCatalog {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private final Authorizer authorizer;
    private SparkSession spark = (SparkSession)SparkSession.getActiveSession().get();

    public DataosSparkCatalog() {
        String heimdallUrl = System.getenv().getOrDefault("HEIMDALL_URL", null);
        if (heimdallUrl == null) {
            throw new MissingEnvVariableException("Missing HEIMDALL_URL env!", null);
        }
        HeimdallClient heimdallClient = (HeimdallClient)new HeimdallClient.Builder().url(heimdallUrl).build();
        String version = System.getenv().getOrDefault("BUILD_VERSION", "unknown");
        String userAgent = Atoms.getAtomNamePrefix() + "/" + version;
        this.authorizer = new Authorizer(new PolicyEnforcementSpecProvider().getPep(), heimdallClient, userAgent);
    }

    protected Catalog buildIcebergCatalog(String name, CaseInsensitiveStringMap options) {
        this.logger.info("buildIcebergCatalog(String name, CaseInsensitiveStringMap options) custom spark catalog");
        return super.buildIcebergCatalog(name, options);
    }

    protected TableIdentifier buildIdentifier(Identifier identifier) {
        this.logger.info("buildIdentifier(Identifier identifier) custom spark catalog");
        return super.buildIdentifier(identifier);
    }

    public Table loadTable(Identifier ident) throws NoSuchTableException {
        this.logger.info("loadTable(Identifier ident) custom spark catalog");
        this.processTableOperation("read", ident, Atoms.AtomRead());
        return super.loadTable(ident);
    }

    public Table loadTable(Identifier ident, String version) throws NoSuchTableException {
        this.logger.info("loadTable(Identifier ident, String version) custom spark catalog");
        return super.loadTable(ident, version);
    }

    public Table loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        this.logger.info("loadTable(Identifier ident, long timestamp) custom spark catalog");
        return super.loadTable(ident, timestamp);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws TableAlreadyExistsException {
        this.logger.info("createTable(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) custom spark catalog");
        this.processTableOperation("create", ident, Atoms.AtomCreateDataset());
        return super.createTable(ident, schema, transforms, properties);
    }

    public StagedTable stageCreate(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws TableAlreadyExistsException {
        this.logger.info("stageCreate(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) custom spark catalog");
        this.processTableOperation("create", ident, Atoms.AtomCreateDataset());
        return super.stageCreate(ident, schema, transforms, properties);
    }

    public StagedTable stageReplace(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws NoSuchTableException {
        this.logger.info("stageReplace(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) custom spark catalog");
        return super.stageReplace(ident, schema, transforms, properties);
    }

    public StagedTable stageCreateOrReplace(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) {
        this.logger.info("stageCreateOrReplace(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) custom spark catalog");
        this.processTableOperation("create", ident, Atoms.AtomCreateDataset());
        return super.stageCreateOrReplace(ident, schema, transforms, properties);
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        this.logger.info("alterTable(TableIdentifier ident, TableChanges changes) custom spark catalog");
        this.processTableOperation("alter", ident, Atoms.AtomCreateDataset());
        return super.alterTable(ident, changes);
    }

    public boolean dropTable(Identifier ident) {
        this.logger.info("dropTable(Identifier ident) custom spark catalog");
        this.processTableOperation("drop", ident, Atoms.AtomCreateDataset());
        return super.dropTable(ident);
    }

    public boolean purgeTable(Identifier ident) {
        this.logger.info("purgeTable(Identifier ident) custom spark catalog");
        this.processTableOperation("purge", ident, Atoms.AtomCreateDataset());
        return super.purgeTable(ident);
    }

    public void renameTable(Identifier from, Identifier to) throws NoSuchTableException, TableAlreadyExistsException {
        this.logger.info("renameTable(Identifier from, Identifier to) custom spark catalog");
        this.processTableOperation("rename", from, Atoms.AtomCreateDataset());
        super.renameTable(from, to);
    }

    public void invalidateTable(Identifier ident) {
        this.logger.info("invalidateTable(Identifier ident) custom spark catalog");
        super.invalidateTable(ident);
    }

    public Identifier[] listTables(String[] namespace) {
        this.logger.info("listTables(String[] namespace) custom spark catalog");
        return super.listTables(namespace);
    }

    public String[] defaultNamespace() {
        this.logger.info("defaultNamespace() custom spark catalog");
        return super.defaultNamespace();
    }

    public String[][] listNamespaces() {
        this.logger.info("listNamespaces() custom spark catalog");
        return super.listNamespaces();
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        this.logger.info("listNamespaces(String[] namespace) custom spark catalog");
        return super.listNamespaces(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        this.logger.info("loadNamespaceMetadata(String[] namespace) custom spark catalog");
        this.processNamespaceOperation("read", namespace, Atoms.AtomRead());
        return super.loadNamespaceMetadata(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        this.logger.info("createNamespace(String[] namespace, Map<String, String> metadata) custom spark catalog");
        this.processNamespaceOperation("create", namespace, Atoms.AtomCreateDataset());
        super.createNamespace(namespace, metadata);
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        this.logger.info("alterNamespace(String[] namespace, NamespaceChange... changes) custom spark catalog");
        this.processNamespaceOperation("alter", namespace, Atoms.AtomCreateDataset());
        super.alterNamespace(namespace, changes);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException {
        this.logger.info("dropNamespace(String[] namespace, boolean cascade) custom spark catalog");
        this.processNamespaceOperation("drop", namespace, Atoms.AtomCreateDataset());
        return super.dropNamespace(namespace, cascade);
    }

    public Catalog icebergCatalog() {
        this.logger.info("icebergCatalog() custom spark catalog");
        return super.icebergCatalog();
    }

    private void processTableOperation(String operation, Identifier ident, String atom) {
        try {
            String depot = this.name();
            String collection = ident.namespace().length == 1 ? ident.namespace()[0] : "";
            String dataset = ident.name();
            AuthZUtils.authorizePEP(this.authorizer, depot, collection, dataset, AuthZUtils.getUserTokenFromSparkConf(this.spark), operation, Atoms.getAtomName(atom));
        }
        catch (Exception e) {
            String msg = String.format("Failed to process table operation: %s, error: %s", operation, e.getMessage());
            this.logger.error(msg, (Throwable)e);
            throw new InvalidArgumentException(msg, (Throwable)e);
        }
    }

    private void processNamespaceOperation(String operation, String[] namespace, String atom) {
        try {
            String depot = this.name();
            String collection = namespace.length == 1 ? namespace[0] : "";
            String dataset = "**";
            AuthZUtils.authorizePEP(this.authorizer, depot, collection, dataset, AuthZUtils.getUserTokenFromSparkConf(this.spark), operation, Atoms.getAtomName(atom));
        }
        catch (Exception e) {
            String msg = String.format("Failed to process namespace operation: %s, error: %s", operation, e.getMessage());
            this.logger.error(msg, (Throwable)e);
            throw new InvalidArgumentException(msg, (Throwable)e);
        }
    }
}

