/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.spark.authz.extension;

import io.dataos.commons.exceptions.InvalidArgumentException;
import io.dataos.heimdall.client.HeimdallClient;
import io.dataos.heimdall.client.auth.Authorizer;
import io.dataos.spark.authz.exceptions.MissingEnvVariableException;
import io.dataos.spark.authz.pep.Atoms$;
import io.dataos.spark.authz.pep.PolicyEnforcementSpecProvider;
import io.dataos.spark.authz.util.AuthZUtils$;
import io.dataos.spark.authz.util.Logging;
import java.util.Map;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.jdbc.JDBCTableCatalog;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\n\u0015\u0001}AQ!\u000f\u0001\u0005\u0002iB\u0011\"\u0010\u0001A\u0002\u0003\u0007I\u0011\u0002 \t\u0013%\u0003\u0001\u0019!a\u0001\n\u0013Q\u0005\"C*\u0001\u0001\u0004\u0005\t\u0015)\u0003@\u0011%I\u0002\u00011AA\u0002\u0013%A\u000bC\u0005Z\u0001\u0001\u0007\t\u0019!C\u00055\"IA\f\u0001a\u0001\u0002\u0003\u0006K!\u0016\u0005\u0006;\u0002!IA\u0018\u0005\u0006?\u0002!\t\u0005\u0019\u0005\u0006]\u0002!\te\u001c\u0005\u0006i\u0002!\t%\u001e\u0005\u0006u\u0002!\te\u001f\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u001d\ty\u0006\u0001C!\u0003CBq!!\u001c\u0001\t\u0003\ny\u0007C\u0004\u0002~\u0001!\t%a \t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u0011Q\u0013\u0001\u0005\n\u0005]%A\u0006#bi\u0006|7O\u0013#C\u0007R\u000b'\r\\3DCR\fGn\\4\u000b\u0005U1\u0012!C3yi\u0016t7/[8o\u0015\t9\u0002$A\u0003bkRD'P\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007I\u0006$\u0018m\\:\u000b\u0003u\t!![8\u0004\u0001M\u0019\u0001\u0001I\u001a\u0011\u0005\u0005\nT\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00026eE\u000eT!!\n\u0014\u0002\u0005Y\u0014$BA\u0014)\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005%R\u0013!C3yK\u000e,H/[8o\u0015\tYC&A\u0002tc2T!!G\u0017\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0005\u0003e\t\u0012\u0001C\u0013#C\u0007R\u000b'\r\\3DCR\fGn\\4\u0011\u0005Q:T\"A\u001b\u000b\u0005Y2\u0012\u0001B;uS2L!\u0001O\u001b\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003y\u0001i\u0011\u0001F\u0001\u000bCV$\bn\u001c:ju\u0016\u0014X#A \u0011\u0005\u0001;U\"A!\u000b\u0005\t\u001b\u0015\u0001B1vi\"T!\u0001R#\u0002\r\rd\u0017.\u001a8u\u0015\t1%$\u0001\u0005iK&lG-\u00197m\u0013\tA\u0015I\u0001\u0006BkRDwN]5{KJ\fa\"Y;uQ>\u0014\u0018N_3s?\u0012*\u0017\u000f\u0006\u0002L#B\u0011AjT\u0007\u0002\u001b*\ta*A\u0003tG\u0006d\u0017-\u0003\u0002Q\u001b\n!QK\\5u\u0011\u001d\u00116!!AA\u0002}\n1\u0001\u001f\u00132\u0003-\tW\u000f\u001e5pe&TXM\u001d\u0011\u0016\u0003U\u0003\"AV,\u000e\u0003)J!\u0001\u0017\u0016\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0013M\u0004\u0018M]6`I\u0015\fHCA&\\\u0011\u001d\u0011f!!AA\u0002U\u000baa\u001d9be.\u0004\u0013\u0001B5oSR$\u0012aS\u0001\nY>\fG\rV1cY\u0016$\"!Y5\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017aB2bi\u0006dwn\u001a\u0006\u0003M*\n\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005!\u001c'!\u0002+bE2,\u0007\"\u00026\n\u0001\u0004Y\u0017!B5eK:$\bC\u00012m\u0013\ti7M\u0001\u0006JI\u0016tG/\u001b4jKJ\f\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\u0005A\u001c\bC\u0001'r\u0013\t\u0011XJA\u0004C_>dW-\u00198\t\u000b)T\u0001\u0019A6\u0002\u0017I,g.Y7f)\u0006\u0014G.\u001a\u000b\u0004\u0017ZD\b\"B<\f\u0001\u0004Y\u0017\u0001C8mI&#WM\u001c;\t\u000be\\\u0001\u0019A6\u0002\u00119,w/\u00133f]R\f1b\u0019:fCR,G+\u00192mKR9\u0011\r`?\u0002\f\u0005\u0005\u0002\"\u00026\r\u0001\u0004Y\u0007\"\u0002@\r\u0001\u0004y\u0018AB:dQ\u0016l\u0017\r\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)AK\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!!\u0004\r\u0001\u0004\ty!\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R\u0001TA\t\u0003+I1!a\u0005N\u0005\u0015\t%O]1z!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eK\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\ty\"!\u0007\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0007bBA\u0012\u0019\u0001\u0007\u0011QE\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\u0003CA\u0014\u0003_\t\u0019$a\r\u000e\u0005\u0005%\"b\u0001\u001c\u0002,)\u0011\u0011QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00022\u0005%\"aA'baB!\u0011QGA\"\u001d\u0011\t9$a\u0010\u0011\u0007\u0005eR*\u0004\u0002\u0002<)\u0019\u0011Q\b\u0010\u0002\rq\u0012xn\u001c;?\u0013\r\t\t%T\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0013q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005S*\u0001\u0006bYR,'\u000fV1cY\u0016$R!YA'\u0003\u001fBQA[\u0007A\u0002-Dq!!\u0015\u000e\u0001\u0004\t\u0019&A\u0004dQ\u0006tw-Z:\u0011\u000b1\u000b)&!\u0017\n\u0007\u0005]SJ\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u00022AYA.\u0013\r\tif\u0019\u0002\f)\u0006\u0014G.Z\"iC:<W-A\bde\u0016\fG/\u001a(b[\u0016\u001c\b/Y2f)\u0015Y\u00151MA5\u0011\u001d\t)G\u0004a\u0001\u0003O\n\u0011B\\1nKN\u0004\u0018mY3\u0011\u000b1\u000b\t\"a\r\t\u000f\u0005-d\u00021\u0001\u0002&\u0005AQ.\u001a;bI\u0006$\u0018-\u0001\bbYR,'OT1nKN\u0004\u0018mY3\u0015\u000b-\u000b\t(a\u001d\t\u000f\u0005\u0015t\u00021\u0001\u0002h!9\u0011\u0011K\bA\u0002\u0005U\u0004#\u0002'\u0002V\u0005]\u0004c\u00012\u0002z%\u0019\u00111P2\u0003\u001f9\u000bW.Z:qC\u000e,7\t[1oO\u0016\fQ\u0002\u001a:pa:\u000bW.Z:qC\u000e,G#\u00029\u0002\u0002\u0006\r\u0005bBA3!\u0001\u0007\u0011q\r\u0005\u0007\u0003\u000b\u0003\u0002\u0019\u00019\u0002\u000f\r\f7oY1eK\u0006)\u0002O]8dKN\u001cH+\u00192mK>\u0003XM]1uS>tGcB&\u0002\f\u0006=\u0015\u0011\u0013\u0005\b\u0003\u001b\u000b\u0002\u0019AA\u001a\u0003%y\u0007/\u001a:bi&|g\u000eC\u0003k#\u0001\u00071\u000eC\u0004\u0002\u0014F\u0001\r!a\r\u0002\t\u0005$x.\\\u0001\u001aaJ|7-Z:t\u001d\u0006lWm\u001d9bG\u0016|\u0005/\u001a:bi&|g\u000eF\u0004L\u00033\u000bY*!(\t\u000f\u00055%\u00031\u0001\u00024!9\u0011Q\r\nA\u0002\u0005\u001d\u0004bBAJ%\u0001\u0007\u00111\u0007")
public class DataosJDBCTableCatalog
extends JDBCTableCatalog
implements Logging {
    private Authorizer authorizer;
    private SparkSession spark;
    private transient Logger io$dataos$spark$authz$util$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger io$dataos$spark$authz$util$Logging$$log_() {
        return this.io$dataos$spark$authz$util$Logging$$log_;
    }

    @Override
    public void io$dataos$spark$authz$util$Logging$$log__$eq(Logger x$1) {
        this.io$dataos$spark$authz$util$Logging$$log_ = x$1;
    }

    private Authorizer authorizer() {
        return this.authorizer;
    }

    private void authorizer_$eq(Authorizer x$1) {
        this.authorizer = x$1;
    }

    private SparkSession spark() {
        return this.spark;
    }

    private void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private void init() {
        this.spark_$eq(SparkSession$.MODULE$.builder().getOrCreate());
        String heimdallUrl = System.getenv().getOrDefault("HEIMDALL_URL", null);
        if (heimdallUrl == null) {
            throw new MissingEnvVariableException("Missing HEIMDALL_URL env!", null);
        }
        HeimdallClient heimdallClient = (HeimdallClient)new HeimdallClient.Builder().url(heimdallUrl).build();
        String version = System.getenv().getOrDefault("BUILD_VERSION", "unknown");
        String userAgent = new StringBuilder(1).append(Atoms$.MODULE$.getAtomNamePrefix()).append("/").append(version).toString();
        this.authorizer_$eq(new Authorizer(new PolicyEnforcementSpecProvider().getPep(), heimdallClient, userAgent));
    }

    public Table loadTable(Identifier ident) {
        this.logger().info("loadTable(ident: Identifier)");
        this.processTableOperation("read", ident, Atoms$.MODULE$.AtomRead());
        return super.loadTable(ident);
    }

    public boolean dropTable(Identifier ident) {
        this.logger().info("dropTable(ident: Identifier)");
        this.processTableOperation("drop", ident, Atoms$.MODULE$.AtomCreateDataset());
        return super.dropTable(ident);
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        this.logger().info("renameTable(oldIdent: Identifier, newIdent: Identifier)");
        this.processTableOperation("rename", oldIdent, Atoms$.MODULE$.AtomCreateDataset());
        super.renameTable(oldIdent, newIdent);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        this.logger().info("createTable(ident: Identifier, schema: StructType, partitions: Array[Transform], properties: java.util.Map[String, String])");
        this.processTableOperation("create", ident, Atoms$.MODULE$.AtomCreateDataset());
        return super.createTable(ident, schema, partitions, properties);
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        this.logger().info("alterTable(ident: Identifier, changes: TableChange*)");
        this.processTableOperation("alter", ident, Atoms$.MODULE$.AtomCreateDataset());
        return super.alterTable(ident, changes);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        this.logger().info("createNamespace(namespace: Array[String], metadata: util.Map[String, String])");
        this.processNamespaceOperation("create", namespace, Atoms$.MODULE$.AtomCreateDataset());
        super.createNamespace(namespace, metadata);
    }

    public void alterNamespace(String[] namespace, Seq<NamespaceChange> changes) {
        this.logger().info("alterNamespace(namespace: Array[String], changes: NamespaceChange*)");
        this.processNamespaceOperation("alter", namespace, Atoms$.MODULE$.AtomCreateDataset());
        super.alterNamespace(namespace, changes);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) {
        this.logger().info("dropNamespace(namespace: Array[String], cascade: Boolean)");
        this.processNamespaceOperation("drop", namespace, Atoms$.MODULE$.AtomCreateDataset());
        return super.dropNamespace(namespace, cascade);
    }

    private void processTableOperation(String operation, Identifier ident, String atom) {
        try {
            String depot = this.name();
            String collection = ident.namespace().length == 1 ? (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).head() : "";
            String dataset = ident.name();
            AuthZUtils$.MODULE$.authorizePEP(this.authorizer(), depot, collection, dataset, AuthZUtils$.MODULE$.getUserTokenFromSparkConf(this.spark()), operation, Atoms$.MODULE$.getAtomName(atom));
        }
        catch (Exception e) {
            String msg = String.format("Failed to process table operation: %s, error: %s", operation, e.getMessage());
            this.logger().error(msg, (Throwable)e);
            throw new InvalidArgumentException(msg, (Throwable)e);
        }
    }

    private void processNamespaceOperation(String operation, String[] namespace, String atom) {
        try {
            String depot = this.name();
            String collection = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head();
            String dataset = "**";
            AuthZUtils$.MODULE$.authorizePEP(this.authorizer(), depot, collection, dataset, AuthZUtils$.MODULE$.getUserTokenFromSparkConf(this.spark()), operation, Atoms$.MODULE$.getAtomName(atom));
        }
        catch (Exception e) {
            String msg = String.format("Failed to process namespace operation: %s, error: %s", operation, e.getMessage());
            this.logger().error(msg, (Throwable)e);
            throw new InvalidArgumentException(msg, (Throwable)e);
        }
    }

    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public DataosJDBCTableCatalog() {
        Logging.$init$(this);
        this.init();
    }
}

