/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.commons.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/dataos/commons/utils/EnvUtils;", "", "()V", "Companion", "commons"})
public final class EnvUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CONNECT_TIMEOUT = "%s_CONNECT_TIMEOUT_MS";
    @NotNull
    private static final String READ_TIMEOUT = "%s_READ_TIMEOUT_MS";
    @NotNull
    private static final String USER_AGENT = "%s_USER_AGENT";
    @NotNull
    private static final String ENABLE_SSL = "%s_ENABLE_SSL";
    @NotNull
    private static final String SSL_HOSTNAME_VERIFICATION = "%s_SSL_HOSTNAME_VERIFICATION";
    @NotNull
    private static final String KEYSTORE_PATH = "%s_KEYSTORE_PATH";
    @NotNull
    private static final String KEYSTORE_PASS = "%s_KEYSTORE_PASS";
    @NotNull
    private static final String TRUSTSTORE_PATH = "%s_TRUSTSTORE_PATH";
    @NotNull
    private static final String TRUSTSTORE_PASS = "%s_TRUSTSTORE_PASS";

    @JvmStatic
    @Nullable
    public static final Long getConnectTimeout(@NotNull String prefix) {
        return Companion.getConnectTimeout(prefix);
    }

    @JvmStatic
    @Nullable
    public static final Long getReadTimeout(@NotNull String prefix) {
        return Companion.getReadTimeout(prefix);
    }

    @JvmStatic
    @Nullable
    public static final String getUserAgent(@NotNull String prefix) {
        return Companion.getUserAgent(prefix);
    }

    @JvmStatic
    @Nullable
    public static final Boolean getEnableSSL(@NotNull String prefix) {
        return Companion.getEnableSSL(prefix);
    }

    @JvmStatic
    @Nullable
    public static final Boolean getSSLHostnameVerification(@NotNull String prefix) {
        return Companion.getSSLHostnameVerification(prefix);
    }

    @JvmStatic
    @Nullable
    public static final String getKeystorePath(@NotNull String prefix) {
        return Companion.getKeystorePath(prefix);
    }

    @JvmStatic
    @Nullable
    public static final String getKeystorePass(@NotNull String prefix) {
        return Companion.getKeystorePass(prefix);
    }

    @JvmStatic
    @Nullable
    public static final String getTruststorePath(@NotNull String prefix) {
        return Companion.getTruststorePath(prefix);
    }

    @JvmStatic
    @Nullable
    public static final String getTruststorePass(@NotNull String prefix) {
        return Companion.getTruststorePass(prefix);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/dataos/commons/utils/EnvUtils$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "ENABLE_SSL", "KEYSTORE_PASS", "KEYSTORE_PATH", "READ_TIMEOUT", "SSL_HOSTNAME_VERIFICATION", "TRUSTSTORE_PASS", "TRUSTSTORE_PATH", "USER_AGENT", "getConnectTimeout", "", "prefix", "(Ljava/lang/String;)Ljava/lang/Long;", "getEnableSSL", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getKeystorePass", "getKeystorePath", "getReadTimeout", "getSSLHostnameVerification", "getTruststorePass", "getTruststorePath", "getUserAgent", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Long getConnectTimeout(@NotNull String prefix) {
            Long l;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = EnvUtils.CONNECT_TIMEOUT;
            Object[] objectArray = new Object[]{prefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String envKey = string2;
            try {
                String connectTimeout;
                String string3 = connectTimeout = System.getenv(envKey);
                l = string3 != null ? Long.valueOf(Long.parseLong(string3)) : null;
            }
            catch (NumberFormatException e) {
                AssertionError error = new AssertionError((Object)("Invalid or missing value for environment variable: " + envKey + ". Please ensure it is a valid long."));
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
            return l;
        }

        @JvmStatic
        @Nullable
        public final Long getReadTimeout(@NotNull String prefix) {
            Long l;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = EnvUtils.READ_TIMEOUT;
            Object[] objectArray = new Object[]{prefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String envKey = string2;
            try {
                String readTimeout;
                String string3 = readTimeout = System.getenv(envKey);
                l = string3 != null ? Long.valueOf(Long.parseLong(string3)) : null;
            }
            catch (NumberFormatException e) {
                AssertionError error = new AssertionError((Object)("Invalid or missing value for environment variable: " + envKey + ". Please ensure it is a valid long."));
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
            return l;
        }

        @JvmStatic
        @Nullable
        public final String getUserAgent(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = EnvUtils.USER_AGENT;
            Object[] objectArray = new Object[]{prefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return System.getenv(string2);
        }

        @JvmStatic
        @Nullable
        public final Boolean getEnableSSL(@NotNull String prefix) {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = EnvUtils.ENABLE_SSL;
            Object[] objectArray = new Object[]{prefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String envKey = string2;
            try {
                String enableSSL;
                String string3 = enableSSL = System.getenv(envKey);
                bl = string3 != null ? Boolean.valueOf(StringsKt.toBooleanStrict((String)string3)) : null;
            }
            catch (IllegalArgumentException e) {
                AssertionError error = new AssertionError((Object)("Invalid or missing value for environment variable: " + envKey + ". Please ensure it is a valid boolean."));
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
            return bl;
        }

        @JvmStatic
        @Nullable
        public final Boolean getSSLHostnameVerification(@NotNull String prefix) {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = EnvUtils.SSL_HOSTNAME_VERIFICATION;
            Object[] objectArray = new Object[]{prefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String envKey = string2;
            try {
                String hostnameVerification;
                String string3 = hostnameVerification = System.getenv(envKey);
                bl = string3 != null ? Boolean.valueOf(StringsKt.toBooleanStrict((String)string3)) : null;
            }
            catch (IllegalArgumentException e) {
                AssertionError error = new AssertionError((Object)("Invalid or missing value for environment variable: " + envKey + ". Please ensure it is a valid boolean."));
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
            return bl;
        }

        @JvmStatic
        @Nullable
        public final String getKeystorePath(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = EnvUtils.KEYSTORE_PATH;
            Object[] objectArray = new Object[]{prefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return System.getenv(string2);
        }

        @JvmStatic
        @Nullable
        public final String getKeystorePass(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = EnvUtils.KEYSTORE_PASS;
            Object[] objectArray = new Object[]{prefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return System.getenv(string2);
        }

        @JvmStatic
        @Nullable
        public final String getTruststorePath(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = EnvUtils.TRUSTSTORE_PATH;
            Object[] objectArray = new Object[]{prefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return System.getenv(string2);
        }

        @JvmStatic
        @Nullable
        public final String getTruststorePass(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = EnvUtils.TRUSTSTORE_PASS;
            Object[] objectArray = new Object[]{prefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return System.getenv(string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

