/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.commons.utils;

import io.dataos.commons.exceptions.InvalidArgumentException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0004H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/dataos/commons/utils/DataOsAddress;", "", "()V", "depot", "", "(Ljava/lang/String;)V", "collection", "(Ljava/lang/String;Ljava/lang/String;)V", "relativePath", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "param", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "dataset", "getCollection", "getDataset", "getDepot", "getParam", "getRelativePath", "setCollection", "", "setDataset", "setDepot", "setParam", "setRelativePath", "toString", "Companion", "commons"})
public final class DataOsAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String depot;
    @Nullable
    private String collection;
    @Nullable
    private String dataset;
    @Nullable
    private String relativePath;
    @Nullable
    private String param;
    private static final Logger log = LoggerFactory.getLogger(Companion.class);
    @NotNull
    private static final Pattern DATAOS_ADDRESS_WITH_COLLECTION_REGEX;
    @NotNull
    private static final Pattern DATAOS_ADDRESS_WITHOUT_COLLECTION_REGEX;
    private static final Pattern DATAOS_ADDRESS_WITH_VERSION_REGEX;

    private DataOsAddress() {
    }

    public DataOsAddress(@NotNull String depot) {
        Intrinsics.checkNotNullParameter((Object)depot, (String)"depot");
        this();
        this.depot = depot;
    }

    public DataOsAddress(@NotNull String depot, @NotNull String collection) {
        Intrinsics.checkNotNullParameter((Object)depot, (String)"depot");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        this(depot);
        this.collection = collection;
    }

    public DataOsAddress(@NotNull String depot, @NotNull String collection, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)depot, (String)"depot");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        this(depot, collection);
        Object[] objectArray = new char[]{'/'};
        String string = this.relativePath = StringsKt.trimStart((String)relativePath, (char[])objectArray);
        Intrinsics.checkNotNull((Object)string);
        objectArray = new String[1];
        objectArray[0] = (char)"/";
        this.dataset = (String)StringsKt.split$default((CharSequence)string, (String[])objectArray, (boolean)false, (int)0, (int)6, null).get(0);
    }

    public DataOsAddress(@NotNull String depot, @NotNull String collection, @NotNull String relativePath, @NotNull String param) {
        Intrinsics.checkNotNullParameter((Object)depot, (String)"depot");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        this(depot, collection, relativePath);
        this.param = param;
    }

    private final void setDepot(String depot) {
        this.depot = depot;
    }

    private final void setCollection(String collection) {
        this.collection = collection;
    }

    private final void setDataset(String dataset) {
        this.dataset = dataset;
    }

    private final void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    private final void setParam(String param) {
        this.param = param;
    }

    @Nullable
    public final String getRelativePath() {
        return this.relativePath;
    }

    @Nullable
    public final String getDepot() {
        return this.depot;
    }

    @Nullable
    public final String getCollection() {
        return this.collection;
    }

    @Nullable
    public final String getDataset() {
        return this.dataset;
    }

    @Nullable
    public final String getParam() {
        return this.param;
    }

    @NotNull
    public String toString() {
        String string;
        if (this.collection == null) {
            String string2 = "dataos://%s";
            Object[] objectArray = new Object[]{this.depot};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }
        if (this.dataset == null) {
            String string4 = "dataos://%s:%s";
            Object[] objectArray = new Object[]{this.depot, this.collection};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
            return string5;
        }
        if (this.param == null) {
            String string6 = "dataos://%s:%s/%s";
            Object[] objectArray = new Object[]{this.depot, this.collection, this.relativePath};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
        } else {
            String string8 = "dataos://%s:%s/%s?version=%s";
            Object[] objectArray = new Object[]{this.depot, this.collection, this.relativePath, this.param};
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(format, *args)");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final DataOsAddress of(@NotNull String address) {
        return Companion.of(address);
    }

    @JvmStatic
    private static final DataOsAddress getDataosAddress(Matcher matcher, String address) {
        return DataOsAddress.Companion.getDataosAddress(matcher, address);
    }

    public /* synthetic */ DataOsAddress(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Pattern pattern = Pattern.compile("dataos:\\/\\/([a-zA-Z0-9-]+)(:([a-zA-Z0-9_]+))(\\/(.*))*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"dataos:\\\\/\\\\/([\u2026-zA-Z0-9_]+))(\\\\/(.*))*\")");
        DATAOS_ADDRESS_WITH_COLLECTION_REGEX = pattern;
        Pattern pattern2 = Pattern.compile("dataos:\\/\\/([a-zA-Z0-9-]+)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(\"dataos:\\\\/\\\\/([a-zA-Z0-9-]+)\")");
        DATAOS_ADDRESS_WITHOUT_COLLECTION_REGEX = pattern2;
        DATAOS_ADDRESS_WITH_VERSION_REGEX = Pattern.compile("(dataos:\\/\\/[a-zA-Z0-9-]+\\:([a-zA-Z0-9_-]+)\\/*[a-zA-Z0-9%_]+)\\?version=([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})+", 8);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/dataos/commons/utils/DataOsAddress$Companion;", "", "()V", "DATAOS_ADDRESS_WITHOUT_COLLECTION_REGEX", "Ljava/util/regex/Pattern;", "DATAOS_ADDRESS_WITH_COLLECTION_REGEX", "DATAOS_ADDRESS_WITH_VERSION_REGEX", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "getDataosAddress", "Lio/dataos/commons/utils/DataOsAddress;", "matcher", "Ljava/util/regex/Matcher;", "address", "", "of", "commons"})
    @SourceDebugExtension(value={"SMAP\nDataOsAddress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataOsAddress.kt\nio/dataos/commons/utils/DataOsAddress$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataOsAddress of(@NotNull String address) {
            DataOsAddress dataOsAddress;
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            log.debug("=>DataOsAddress.of(): {}", (Object)address);
            Matcher matcher = DATAOS_ADDRESS_WITH_COLLECTION_REGEX.matcher(address);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"DATAOS_ADDRESS_WITH_COLL\u2026ON_REGEX.matcher(address)");
            Matcher matcherWithCollection = matcher;
            Matcher matcher2 = DATAOS_ADDRESS_WITHOUT_COLLECTION_REGEX.matcher(address);
            Intrinsics.checkNotNullExpressionValue((Object)matcher2, (String)"DATAOS_ADDRESS_WITHOUT_C\u2026ON_REGEX.matcher(address)");
            Matcher matcherWithoutCollection = matcher2;
            if (matcherWithCollection.find()) {
                dataOsAddress = this.getDataosAddress(matcherWithCollection, address);
            } else if (matcherWithoutCollection.find() && Intrinsics.areEqual((Object)matcherWithoutCollection.group(0), (Object)address)) {
                DataOsAddress dataOsAddress2 = new DataOsAddress(null);
                if (matcherWithoutCollection.group(1) != null) {
                    String string = matcherWithoutCollection.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcherWithoutCollection.group(1)");
                    dataOsAddress2.setDepot(string);
                }
                dataOsAddress = dataOsAddress2;
            } else {
                throw new InvalidArgumentException("Invalid dataos address - " + address);
            }
            return dataOsAddress;
        }

        @JvmStatic
        private final DataOsAddress getDataosAddress(Matcher matcher, String address) {
            String it;
            String string;
            DataOsAddress dataOsAddress;
            DataOsAddress $this$getDataosAddress_u24lambda_u245 = dataOsAddress = new DataOsAddress(null);
            boolean bl = false;
            String string2 = string = matcher.group(1);
            if (string2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(1)");
                it = string;
                boolean bl2 = false;
                $this$getDataosAddress_u24lambda_u245.setDepot(it);
            }
            String string3 = string = matcher.group(3);
            if (string3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(3)");
                it = string;
                boolean bl3 = false;
                $this$getDataosAddress_u24lambda_u245.setCollection(it);
            }
            String string4 = string = matcher.group(5);
            if (string4 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(5)");
                String group5 = string;
                boolean bl4 = false;
                if (!StringsKt.isBlank((CharSequence)group5)) {
                    int n;
                    String it2;
                    CharSequence charSequence = group5;
                    Regex regex = new Regex("/");
                    int n2 = 0;
                    String string5 = (String)CollectionsKt.firstOrNull((List)regex.split(charSequence, n2));
                    if (string5 != null) {
                        it2 = string5;
                        n = 0;
                        $this$getDataosAddress_u24lambda_u245.setDataset(it2);
                    }
                    charSequence = group5;
                    it2 = new Regex("\\?");
                    n = 0;
                    String string6 = (String)CollectionsKt.firstOrNull((List)it2.split(charSequence, n));
                    if (string6 != null) {
                        it2 = string6;
                        boolean bl5 = false;
                        $this$getDataosAddress_u24lambda_u245.setRelativePath(it2);
                    }
                }
            }
            Matcher matcher2 = DATAOS_ADDRESS_WITH_VERSION_REGEX.matcher(address);
            Intrinsics.checkNotNullExpressionValue((Object)matcher2, (String)"DATAOS_ADDRESS_WITH_VERSION_REGEX.matcher(address)");
            Matcher matcherWithVersion = matcher2;
            if (matcherWithVersion.find()) {
                String string7 = matcherWithVersion.group(3);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"matcherWithVersion.group(3)");
                dataOsAddress.setParam(string7);
            }
            return dataOsAddress;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

