/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.commons.utils;

import com.google.common.net.UrlEscapers;
import io.dataos.commons.exceptions.DataOSException;
import io.dataos.commons.mapper.ObjectMapperUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/dataos/commons/utils/CommonUtils;", "", "()V", "Companion", "commons"})
public final class CommonUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final URL toUrl(@NotNull String urlString) {
        return Companion.toUrl(urlString);
    }

    @JvmStatic
    @NotNull
    public static final String decodeUrl(@NotNull String datasetName) {
        return Companion.decodeUrl(datasetName);
    }

    @JvmStatic
    @NotNull
    public static final String encodeUrl(@NotNull String datasetName) {
        return Companion.encodeUrl(datasetName);
    }

    @JvmStatic
    @NotNull
    public static final String encodeUrlIfNot(@NotNull String str) {
        return Companion.encodeUrlIfNot(str);
    }

    @JvmStatic
    @NotNull
    public static final String getValueOrThrow(@NotNull Properties properties, @NotNull String key) {
        return Companion.getValueOrThrow(properties, key);
    }

    @JvmStatic
    @Nullable
    public static final String getValueOrNull(@NotNull Properties properties, @NotNull String key) {
        return Companion.getValueOrNull(properties, key);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0007\u00a8\u0006\u001c"}, d2={"Lio/dataos/commons/utils/CommonUtils$Companion;", "", "()V", "convertJsonStringToProperties", "Ljava/util/Properties;", "jsonString", "", "convertKeyValueStringToProperties", "keyValueString", "decodeBase64", "encoded", "decodeUrl", "datasetName", "encodeUrl", "encodeUrlIfNot", "str", "getValueOrNull", "properties", "key", "getValueOrThrow", "propertiesToMap", "", "props", "readFile", "filepath", "toUrl", "Ljava/net/URL;", "urlString", "commons"})
    @SourceDebugExtension(value={"SMAP\nCommonUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonUtils.kt\nio/dataos/commons/utils/CommonUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1179#2,2:163\n1253#2,4:165\n*S KotlinDebug\n*F\n+ 1 CommonUtils.kt\nio/dataos/commons/utils/CommonUtils$Companion\n*L\n153#1:163,2\n153#1:165,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final URL toUrl(@NotNull String urlString) {
            URL uRL;
            Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
            try {
                uRL = new URL(urlString);
            }
            catch (MalformedURLException e) {
                AssertionError error = new AssertionError((Object)("Malformed URL: " + urlString));
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
            return uRL;
        }

        @JvmStatic
        @NotNull
        public final String decodeUrl(@NotNull String datasetName) {
            Intrinsics.checkNotNullParameter((Object)datasetName, (String)"datasetName");
            String string = URI.create(datasetName).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"create(datasetName).path");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String encodeUrl(@NotNull String datasetName) {
            Intrinsics.checkNotNullParameter((Object)datasetName, (String)"datasetName");
            String string = UrlEscapers.urlPathSegmentEscaper().escape(datasetName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlPathSegmentEscaper().escape(datasetName)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String encodeUrlIfNot(@NotNull String str) {
            String string;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            try {
                this.decodeUrl(str);
                string = str;
            }
            catch (IllegalArgumentException e) {
                string = this.encodeUrl(str);
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getValueOrThrow(@NotNull Properties properties, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!properties.containsKey(key)) {
                throw new DataOSException("Key: " + key + " not found in properties");
            }
            String string = properties.getProperty(key);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"properties.getProperty(key)");
            return string;
        }

        @JvmStatic
        @Nullable
        public final String getValueOrNull(@NotNull Properties properties, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!properties.containsKey(key)) {
                return null;
            }
            return properties.getProperty(key);
        }

        @NotNull
        public final String decodeBase64(@NotNull String encoded) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            byte[] byArray = Base64.getDecoder().decode(encoded);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder().decode(encoded)");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            return new String(byArray2, charset2);
        }

        @NotNull
        public final Properties convertJsonStringToProperties(@NotNull String jsonString) {
            Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
            return ObjectMapperUtil.Companion.fromJson(jsonString, Properties.class);
        }

        @NotNull
        public final Properties convertKeyValueStringToProperties(@NotNull String keyValueString) {
            Intrinsics.checkNotNullParameter((Object)keyValueString, (String)"keyValueString");
            Properties properties = new Properties();
            String string = keyValueString;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            properties.load(new ByteArrayInputStream(byArray));
            return properties;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, String> propertiesToMap(@NotNull Properties props) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)props, (String)"props");
            Set<Map.Entry<Object, Object>> set = props.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"props.entries");
            Iterable $this$associate$iv = set;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, value)");
                Object key = entry.getKey();
                Object value = entry.getValue();
                entry = TuplesKt.to((Object)key.toString(), (Object)value.toString());
                map.put(entry.getFirst(), entry.getSecond());
            }
            return destination$iv$iv;
        }

        @NotNull
        public final String readFile(@NotNull String filepath) {
            Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
            String string = FileUtils.readFileToString((File)new File(filepath), (Charset)StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readFileToString(File(fi\u2026, StandardCharsets.UTF_8)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

