/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.commons.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/dataos/commons/mapper/ObjectMapperUtil;", "", "()V", "Companion", "commons"})
public final class ObjectMapperUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static ObjectMapper mapper = new ObjectMapper();
    @NotNull
    private static ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    @JvmStatic
    @NotNull
    public static final ObjectMapper getMapperInstance() {
        return Companion.getMapperInstance();
    }

    @JvmStatic
    @NotNull
    public static final ObjectMapper getMapperInstance(boolean isYamlReader) {
        return Companion.getMapperInstance(isYamlReader);
    }

    @JvmStatic
    @NotNull
    public static final <T> T fromJson(@NotNull String json, @NotNull Class<T> clazz) {
        return Companion.fromJson(json, clazz);
    }

    @JvmStatic
    @NotNull
    public static final <T> T fromJson(@NotNull String json, @NotNull TypeReference<T> ref) {
        return Companion.fromJson(json, ref);
    }

    @JvmStatic
    @NotNull
    public static final String toJson(@NotNull Object value) {
        return Companion.toJson(value);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.findAndRegisterModules();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ-\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0004H\u0007J\u0012\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0001H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/dataos/commons/mapper/ObjectMapperUtil$Companion;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "yamlMapper", "fromJson", "T", "json", "", "ref", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getMapperInstance", "isYamlReader", "", "toJson", "value", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ObjectMapper getMapperInstance() {
            return mapper;
        }

        @JvmStatic
        @NotNull
        public final ObjectMapper getMapperInstance(boolean isYamlReader) {
            if (isYamlReader) {
                return yamlMapper;
            }
            return mapper;
        }

        public static /* synthetic */ ObjectMapper getMapperInstance$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.getMapperInstance(bl);
        }

        @JvmStatic
        @NotNull
        public final <T> T fromJson(@NotNull String json, @NotNull Class<T> clazz) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            try {
                Object object2 = mapper.readValue(json, clazz);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                mapper\u2026son, clazz)\n            }");
                object = object2;
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
            return (T)object;
        }

        @JvmStatic
        @NotNull
        public final <T> T fromJson(@NotNull String json, @NotNull TypeReference<T> ref) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter(ref, (String)"ref");
            try {
                Object object2 = mapper.readValue(json, ref);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                mapper\u2026(json, ref)\n            }");
                object = object2;
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
            return (T)object;
        }

        @JvmStatic
        @NotNull
        public final String toJson(@NotNull Object value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                String string2 = mapper.writeValueAsString(value);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                mapper\u2026ring(value)\n            }");
                string = string2;
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

