/*
 * Decompiled with CFR 0.152.
 */
package io.dataos.commons.http.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dataos.commons.exceptions.DataOSException;
import io.dataos.commons.models.SSLConfig;
import io.dataos.commons.utils.EnvUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nl.altindag.ssl.SSLFactory;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\r\u0010\u001a\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0007H\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\r\u001a\u00020\u0005J\b\u0010\u001d\u001a\u00020\tH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\u001f\u001a\u00020\u0005H&J\b\u0010 \u001a\u00020\u0005H\u0002J\u0006\u0010!\u001a\u00020\u0007J\n\u0010\"\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010#\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010$\u001a\u0004\u0018\u00010\u0011H\u0004J\b\u0010%\u001a\u00020\tH\u0002J\b\u0010&\u001a\u00020\u0014H\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010)\u001a\u00020\u0005H\u0004J\b\u0010*\u001a\u00020\u0005H\u0002J\b\u0010+\u001a\u00020\fH\u0002J\b\u0010,\u001a\u00020\fH\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000f\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0012\u001a\u00020\tJ\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010-\u001a\u00020.J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010/\u001a\u00020\u0014J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00101\u001a\u00020\fJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0016\u001a\u00020\u0005J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0017\u001a\u00020\u0005J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0018\u001a\u00020\u0005J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\u0005R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/dataos/commons/http/client/BaseOkHttpClientBuilder;", "T", "", "()V", "apikey", "", "client", "Lokhttp3/OkHttpClient;", "connectTimeout", "", "Ljava/lang/Long;", "enableSsl", "", "envPrefix", "keystorePass", "keystorePath", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "readTimeout", "sslFactory", "Lnl/altindag/ssl/SSLFactory;", "sslVerifyHostname", "truststorePass", "truststorePath", "url", "userAgent", "build", "()Ljava/lang/Object;", "buildOkHttpClient", "getConnectTimeout", "getDefaultEnvPrefix", "getDefaultUserAgentSuffix", "getEnvPrefix", "getHttpClient", "getKeystorePass", "getKeystorePath", "getMapper", "getReadTimeout", "getSSLFactory", "getTruststorePass", "getTruststorePath", "getUrl", "getUserAgent", "isSSLEnable", "isSSLHostnameVerificationEnable", "sslConfig", "Lio/dataos/commons/models/SSLConfig;", "factory", "sslHostnameVerify", "enable", "commons"})
@SourceDebugExtension(value={"SMAP\nBaseOkHttpClientBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseOkHttpClientBuilder.kt\nio/dataos/commons/http/client/BaseOkHttpClientBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,369:1\n1#2:370\n*E\n"})
public abstract class BaseOkHttpClientBuilder<T> {
    @Nullable
    private String url;
    @Nullable
    private String apikey;
    @Nullable
    private String envPrefix;
    private boolean enableSsl;
    private boolean sslVerifyHostname = true;
    @Nullable
    private String keystorePath;
    @Nullable
    private String keystorePass;
    @Nullable
    private String truststorePath;
    @Nullable
    private String truststorePass;
    @Nullable
    private Long connectTimeout;
    @Nullable
    private Long readTimeout;
    @Nullable
    private String userAgent;
    @Nullable
    private OkHttpClient client;
    @Nullable
    private SSLFactory sslFactory;
    @Nullable
    private ObjectMapper mapper;

    @NotNull
    public final BaseOkHttpClientBuilder<T> url(@NotNull String url) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        BaseOkHttpClientBuilder $this$url_u24lambda_u240 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        String string = "%s/";
        Object[] objectArray = new Object[]{StringsKt.removeSuffix((String)url, (CharSequence)"/")};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        $this$url_u24lambda_u240.url = string2;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> apikey(@NotNull String apikey) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)apikey, (String)"apikey");
        BaseOkHttpClientBuilder $this$apikey_u24lambda_u241 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$apikey_u24lambda_u241.apikey = apikey;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> envPrefix(@NotNull String envPrefix) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)envPrefix, (String)"envPrefix");
        BaseOkHttpClientBuilder $this$envPrefix_u24lambda_u242 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$envPrefix_u24lambda_u242.envPrefix = envPrefix;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> enableSsl(boolean enableSsl) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        BaseOkHttpClientBuilder $this$enableSsl_u24lambda_u243 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$enableSsl_u24lambda_u243.enableSsl = enableSsl;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> sslHostnameVerify(boolean enable) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        BaseOkHttpClientBuilder $this$sslHostnameVerify_u24lambda_u244 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$sslHostnameVerify_u24lambda_u244.sslVerifyHostname = enable;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> keystorePath(@NotNull String keystorePath) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)keystorePath, (String)"keystorePath");
        BaseOkHttpClientBuilder $this$keystorePath_u24lambda_u245 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$keystorePath_u24lambda_u245.keystorePath = keystorePath;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> keystorePass(@NotNull String keystorePass) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)keystorePass, (String)"keystorePass");
        BaseOkHttpClientBuilder $this$keystorePass_u24lambda_u246 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$keystorePass_u24lambda_u246.keystorePass = keystorePass;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> truststorePath(@NotNull String truststorePath) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)truststorePath, (String)"truststorePath");
        BaseOkHttpClientBuilder $this$truststorePath_u24lambda_u247 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$truststorePath_u24lambda_u247.truststorePath = truststorePath;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> truststorePass(@NotNull String truststorePass) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)truststorePass, (String)"truststorePass");
        BaseOkHttpClientBuilder $this$truststorePass_u24lambda_u248 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$truststorePass_u24lambda_u248.truststorePass = truststorePass;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> readTimeout(long readTimeout) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        BaseOkHttpClientBuilder $this$readTimeout_u24lambda_u249 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$readTimeout_u24lambda_u249.readTimeout = readTimeout;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> connectTimeout(long connectTimeout) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        BaseOkHttpClientBuilder $this$connectTimeout_u24lambda_u2410 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$connectTimeout_u24lambda_u2410.connectTimeout = connectTimeout;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> userAgent(@NotNull String userAgent) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        BaseOkHttpClientBuilder $this$userAgent_u24lambda_u2411 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$userAgent_u24lambda_u2411.userAgent = userAgent;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> sslFactory(@NotNull SSLFactory factory) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        BaseOkHttpClientBuilder $this$sslFactory_u24lambda_u2412 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$sslFactory_u24lambda_u2412.sslFactory = factory;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> mapper(@NotNull ObjectMapper mapper) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        BaseOkHttpClientBuilder $this$mapper_u24lambda_u2413 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$mapper_u24lambda_u2413.mapper = mapper;
        return baseOkHttpClientBuilder;
    }

    @NotNull
    public final BaseOkHttpClientBuilder<T> sslConfig(@NotNull SSLConfig sslConfig) {
        BaseOkHttpClientBuilder baseOkHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)sslConfig, (String)"sslConfig");
        BaseOkHttpClientBuilder $this$sslConfig_u24lambda_u2414 = baseOkHttpClientBuilder = this;
        boolean bl = false;
        $this$sslConfig_u24lambda_u2414.enableSsl = sslConfig.getSsl();
        $this$sslConfig_u24lambda_u2414.truststorePass = sslConfig.getTruststorePass();
        $this$sslConfig_u24lambda_u2414.truststorePath = sslConfig.getTruststorePath();
        $this$sslConfig_u24lambda_u2414.keystorePass = sslConfig.getKeystorePass();
        $this$sslConfig_u24lambda_u2414.keystorePath = sslConfig.getKeystorePath();
        return baseOkHttpClientBuilder;
    }

    @NotNull
    protected final String getUrl() {
        String string = this.url;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String getEnvPrefix() {
        String string = this.envPrefix;
        if (string == null && (string = this.getDefaultEnvPrefix()) == null) {
            string = "SDK_";
        }
        return string;
    }

    private final boolean isSSLEnable() {
        Boolean bl = EnvUtils.Companion.getEnableSSL(this.getEnvPrefix());
        return bl != null ? bl : this.enableSsl;
    }

    private final boolean isSSLHostnameVerificationEnable() {
        Boolean bl = EnvUtils.Companion.getSSLHostnameVerification(this.getEnvPrefix());
        return bl != null ? bl : this.sslVerifyHostname;
    }

    private final String getKeystorePath() {
        String string = EnvUtils.Companion.getKeystorePath(this.getEnvPrefix());
        if (string == null) {
            string = this.keystorePath;
        }
        return string;
    }

    private final String getKeystorePass() {
        String string = EnvUtils.Companion.getKeystorePass(this.getEnvPrefix());
        if (string == null) {
            string = this.keystorePass;
        }
        return string;
    }

    private final String getTruststorePath() {
        String string = EnvUtils.Companion.getTruststorePath(this.getEnvPrefix());
        if (string == null) {
            string = this.truststorePath;
        }
        return string;
    }

    private final String getTruststorePass() {
        String string = EnvUtils.Companion.getTruststorePass(this.getEnvPrefix());
        if (string == null) {
            string = this.truststorePass;
        }
        return string;
    }

    private final long getConnectTimeout() {
        long l;
        Long l2 = EnvUtils.Companion.getConnectTimeout(this.getEnvPrefix());
        if (l2 != null) {
            l = l2;
        } else {
            Long l3 = this.connectTimeout;
            l = l3 != null ? l3 : 10000L;
        }
        return l;
    }

    private final long getReadTimeout() {
        long l;
        Long l2 = EnvUtils.Companion.getReadTimeout(this.getEnvPrefix());
        if (l2 != null) {
            l = l2;
        } else {
            Long l3 = this.readTimeout;
            l = l3 != null ? l3 : 10000L;
        }
        return l;
    }

    private final String getUserAgent() {
        String string = EnvUtils.Companion.getUserAgent(this.getEnvPrefix());
        if (string == null && (string = this.userAgent) == null) {
            String string2 = "sdk/%s/-.-.-";
            Object[] objectArray = new Object[]{this.getDefaultUserAgentSuffix()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        }
        return string;
    }

    @NotNull
    public final OkHttpClient getHttpClient() {
        OkHttpClient okHttpClient = this.client;
        if (okHttpClient == null) {
            okHttpClient = this.buildOkHttpClient();
        }
        return okHttpClient;
    }

    @Nullable
    protected final ObjectMapper getMapper() {
        return this.mapper;
    }

    @NotNull
    public abstract String getDefaultUserAgentSuffix();

    @Nullable
    public abstract String getDefaultEnvPrefix();

    private final OkHttpClient buildOkHttpClient() {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        SSLFactory sSLFactory = this.sslFactory;
        if (sSLFactory == null) {
            sSLFactory = this.getSSLFactory();
        }
        SSLFactory sslFactory = sSLFactory;
        SSLSocketFactory sSLSocketFactory = sslFactory.getSslSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslFactory.sslSocketFactory");
        Object t = sslFactory.getTrustManager().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"sslFactory.trustManager.get()");
        httpClientBuilder.sslSocketFactory(sSLSocketFactory, (X509TrustManager)t);
        httpClientBuilder.addInterceptor(arg_0 -> BaseOkHttpClientBuilder.buildOkHttpClient$lambda$15(this, arg_0));
        httpClientBuilder.connectTimeout(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        httpClientBuilder.readTimeout(this.getReadTimeout(), TimeUnit.MILLISECONDS);
        return httpClientBuilder.build();
    }

    private final SSLFactory getSSLFactory() {
        SSLFactory.Builder builder = SSLFactory.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
        SSLFactory.Builder sslFactoryBuilder = builder;
        if (this.isSSLHostnameVerificationEnable() && !this.isSSLEnable()) {
            sslFactoryBuilder.withDefaultTrustMaterial();
        }
        if (!this.isSSLHostnameVerificationEnable()) {
            sslFactoryBuilder.withUnsafeHostnameVerifier().withUnsafeTrustMaterial();
        }
        if (this.isSSLEnable()) {
            if (this.getKeystorePath() == null || this.getKeystorePass() == null || this.getTruststorePath() == null || this.getTruststorePass() == null) {
                throw new DataOSException("keystore and truststore paths and passwords must be provided");
            }
            String string = this.getKeystorePath();
            Intrinsics.checkNotNull((Object)string);
            Path path = Paths.get(string, new String[0]);
            String string2 = this.getKeystorePass();
            Intrinsics.checkNotNull((Object)string2);
            char[] cArray = string2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            SSLFactory.Builder builder2 = sslFactoryBuilder.withIdentityMaterial(path, cArray);
            String string3 = this.getTruststorePath();
            Intrinsics.checkNotNull((Object)string3);
            Path path2 = Paths.get(string3, new String[0]);
            String string4 = this.getTruststorePass();
            Intrinsics.checkNotNull((Object)string4);
            char[] cArray2 = string4.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            builder2.withTrustMaterial(path2, cArray2);
        }
        SSLFactory sSLFactory = sslFactoryBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)sSLFactory, (String)"sslFactoryBuilder.build()");
        return sSLFactory;
    }

    public abstract T build();

    private static final Response buildOkHttpClient$lambda$15(BaseOkHttpClientBuilder this$0, Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request.Builder builder = chain.request().newBuilder().addHeader("User-Agent", this$0.getUserAgent());
        if (this$0.apikey != null) {
            String string = this$0.apikey;
            Intrinsics.checkNotNull((Object)string);
            builder.addHeader("apikey", string);
        }
        return chain.proceed(builder.build());
    }
}

