import { Notification } from 'rxjs';
import { SubscriptionLog } from 'rxjs/internal/testing/SubscriptionLog';
/**
 * Represents interface for single metadata value emitted by HotObservable<T> or ColdObservable<T>
 *
 */
interface TestMessage<T = string> {
    frame: number;
    notification: Notification<T>;
}
/**
 * Represents single metadata value emitted by HotObservable<T> or ColdObservable<T>
 *
 */
declare class TestMessageValue<T = string> implements TestMessage<T> {
    readonly frame: number;
    readonly notification: Notification<T>;
    constructor(frame: number, notification: Notification<T>);
}
/**
 * Utility function to generate TestMessage represents value for Observer::next()
 * @param frame virtual frame time when value will be emitted
 * @param value
 */
declare const next: <T = string>(frame: number, value: T) => TestMessage<T>;
/**
 * Utility function to generate TestMessage represents error for Observer::error()
 * @param frame virtual frame time when value will be emitted
 * @param value
 */
declare const error: (frame: number, error?: any) => TestMessage<any>;
/**
 * Utility function to generate TestMessage represents completion for Observer::complete()
 * @param frame virtual frame time when value will be emitted
 */
declare const complete: <T = void>(frame: number) => TestMessage<T>;
declare const subscribe: (subscribedFrame?: number, unsubscribedFrame?: number) => SubscriptionLog;
export { TestMessage, TestMessageValue, next, error, complete, subscribe };
//# sourceMappingURL=TestMessage.d.ts.map