import { TestMessage } from '../message/TestMessage';
/**
 * Parse marble DSL diagram, generates array of TestMessageValue for metadata of each marble values to be scheduled into.
 *
 * @param {string} marble Marble diagram to parse
 * @param {{ [key: string]: T }} [value] Custom value for marble value
 * @param {any} [error] Custom error for marble error
 * @param {boolean} [materializeInnerObservables] Flatten inner observables in cold observable. False by default.
 * @param {number} [frameTimeFactor] Custom frametime factor for virtual time frame. 1 by default.
 */
declare const parseObservableMarble: <T = string>(marble: string, value?: {
    [key: string]: T;
} | null | undefined, error?: any, materializeInnerObservables?: boolean, frameTimeFactor?: number, maxFrame?: number) => readonly TestMessage<T | TestMessage<T>[]>[];
export { parseObservableMarble };
//# sourceMappingURL=parseObservableMarble.d.ts.map