"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bls12381g1Token = exports.Bls12381g1ValidationError = void 0;
var token_1 = require("./token");
var Bls12381g1ValidationError = /** @class */ (function (_super) {
    __extends(Bls12381g1ValidationError, _super);
    function Bls12381g1ValidationError(value, token, message) {
        var _this = _super.call(this, value, token, message) || this;
        _this.value = value;
        _this.token = token;
        _this.name = 'Bls12381g1ValidationError';
        return _this;
    }
    return Bls12381g1ValidationError;
}(token_1.TokenValidationError));
exports.Bls12381g1ValidationError = Bls12381g1ValidationError;
var Bls12381g1Token = /** @class */ (function (_super) {
    __extends(Bls12381g1Token, _super);
    function Bls12381g1Token(val, idx, fac) {
        var _this = _super.call(this, val, idx, fac) || this;
        _this.val = val;
        _this.idx = idx;
        _this.fac = fac;
        return _this;
    }
    Bls12381g1Token.prototype.isValid = function (val) {
        if (/^[0-9a-fA-F]*$/.test(val) && val.length % 2 === 0) {
            return null;
        }
        else {
            return new Bls12381g1ValidationError(val, this, "Invalid bytes: " + val);
        }
    };
    Bls12381g1Token.prototype.convertUint8ArrayToHexString = function (val) {
        return val.constructor === Uint8Array ? Buffer.from(val).toString('hex') : val;
    };
    Bls12381g1Token.prototype.Encode = function (args) {
        var val = args.pop();
        val = this.convertUint8ArrayToHexString(val);
        var err = this.isValid(val);
        if (err) {
            throw err;
        }
        return { bytes: val };
    };
    Bls12381g1Token.prototype.EncodeObject = function (val) {
        val = this.convertUint8ArrayToHexString(val);
        var err = this.isValid(val);
        if (err) {
            throw err;
        }
        return { bytes: val };
    };
    Bls12381g1Token.prototype.Execute = function (val) {
        return val.bytes;
    };
    Bls12381g1Token.prototype.ExtractSchema = function () {
        return Bls12381g1Token.prim;
    };
    // A point on the BLS12-381 curve G1
    // See https://tezos.gitlab.io/michelson-reference/#type-bls12_381_g1
    Bls12381g1Token.prim = 'bls12_381_g1';
    return Bls12381g1Token;
}(token_1.Token));
exports.Bls12381g1Token = Bls12381g1Token;
//# sourceMappingURL=bls12-381-g1.js.map