import { Prim, Expr, StringLiteral, IntLiteral } from "./micheline";
import { MichelsonData, MichelsonDataPair, MichelsonType, MichelsonTypePair } from "./michelson-types";
export declare type Tuple<N extends number, T> = N extends 1 ? [T] : N extends 2 ? [T, T] : N extends 3 ? [T, T, T] : N extends 4 ? [T, T, T, T] : N extends 5 ? [T, T, T, T, T] : N extends 6 ? [T, T, T, T, T, T] : N extends 7 ? [T, T, T, T, T, T, T] : N extends 8 ? [T, T, T, T, T, T, T, T] : T[];
declare type RequiredProp<T, K extends keyof T> = Omit<T, K> & Required<Pick<T, K>>;
declare type OmitProp<T, K extends keyof T> = Omit<T, K> & {
    [P in K]?: undefined;
};
export declare type ReqArgs<T extends Prim> = RequiredProp<T, "args">;
export declare type NoArgs<T extends Prim> = OmitProp<T, "args">;
export declare type NoAnnots<T extends Prim> = OmitProp<T, "annots">;
export declare type Nullable<T> = {
    [P in keyof T]: T[P] | null;
};
export declare class MichelsonError<T extends Expr = Expr> extends Error {
    val: T;
    /**
     * @param val Value of a AST node caused the error
     * @param path Path to a node caused the error
     * @param message An error message
     */
    constructor(val: T, message?: string);
}
export declare function isMichelsonError<T extends Expr = Expr>(err: any): err is MichelsonError<T>;
export declare class MichelsonTypeError extends MichelsonError<MichelsonType | MichelsonType[]> {
    data?: Expr;
    /**
     * @param val Value of a type node caused the error
     * @param data Value of a data node caused the error
     * @param message An error message
     */
    constructor(val: MichelsonType | MichelsonType[], data?: Expr, message?: string);
}
export declare class LongInteger {
    private neg;
    private buf;
    private append;
    constructor(arg?: string | number);
    cmp(arg: LongInteger): number;
    get sign(): number;
}
export declare function parseBytes(s: string): number[] | null;
export declare function compareBytes(a: number[] | Uint8Array, b: number[] | Uint8Array): number;
export declare function isDecimal(x: string): boolean;
export declare function isNatural(x: string): boolean;
export interface UnpackedAnnotations {
    f?: string[];
    t?: string[];
    v?: string[];
}
export interface UnpackAnnotationsOptions {
    specialVar?: boolean;
    emptyVar?: boolean;
    specialFields?: boolean;
    emptyFields?: boolean;
}
export declare function unpackAnnotations(p: Prim | Expr[], opt?: UnpackAnnotationsOptions): UnpackedAnnotations;
export declare type TezosIDType = "BlockHash" | "OperationHash" | "OperationListHash" | "OperationListListHash" | "ProtocolHash" | "ContextHash" | "ED25519PublicKeyHash" | "SECP256K1PublicKeyHash" | "P256PublicKeyHash" | "ContractHash" | "CryptoboxPublicKeyHash" | "ED25519Seed" | "ED25519PublicKey" | "SECP256K1SecretKey" | "P256SecretKey" | "ED25519EncryptedSeed" | "SECP256K1EncryptedSecretKey" | "P256EncryptedSecretKey" | "SECP256K1PublicKey" | "P256PublicKey" | "SECP256K1Scalar" | "SECP256K1Element" | "ED25519SecretKey" | "ED25519Signature" | "SECP256K1Signature" | "P256Signature" | "GenericSignature" | "ChainID";
export declare type TezosIDPrefix = [number, number[]];
export declare const tezosPrefix: Record<TezosIDType, TezosIDPrefix>;
export declare function checkDecodeTezosID<T extends TezosIDType[]>(id: string, ...types: T): [T[number], number[]] | null;
export declare function encodeTezosID(id: TezosIDType, data: number[] | Uint8Array): string;
declare type PairTypeOrDataPrim<I extends "pair" | "Pair"> = I extends "pair" ? Extract<MichelsonTypePair<MichelsonType[]>, Prim> : Extract<MichelsonDataPair<MichelsonData[]>, Prim>;
export declare function unpackComb<I extends "pair" | "Pair">(id: I, v: I extends "pair" ? MichelsonTypePair<MichelsonType[]> : MichelsonDataPair<MichelsonData[]>): PairTypeOrDataPrim<I>;
export declare function isPairType(t: MichelsonType): t is MichelsonTypePair<MichelsonType[]>;
export declare function isPairData(d: Expr): d is MichelsonDataPair<MichelsonData[]>;
export declare function parseDate(a: StringLiteral | IntLiteral): Date | null;
export declare function parseHex(s: string): number[];
export declare function hexBytes(bytes: number[]): string;
export {};
