"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.scan = exports.Literal = exports.ScanError = void 0;
var ScanError = /** @class */ (function (_super) {
    __extends(ScanError, _super);
    function ScanError(src, idx, message) {
        var _this = _super.call(this, message) || this;
        _this.src = src;
        _this.idx = idx;
        Object.setPrototypeOf(_this, ScanError.prototype);
        return _this;
    }
    return ScanError;
}(Error));
exports.ScanError = ScanError;
var Literal;
(function (Literal) {
    Literal[Literal["Comment"] = 0] = "Comment";
    Literal[Literal["Number"] = 1] = "Number";
    Literal[Literal["String"] = 2] = "String";
    Literal[Literal["Bytes"] = 3] = "Bytes";
    Literal[Literal["Ident"] = 4] = "Ident";
})(Literal = exports.Literal || (exports.Literal = {}));
var isSpace = new RegExp("\\s");
var isIdentStart = new RegExp("[:@%_A-Za-z]");
var isIdent = new RegExp("[@%_\\.A-Za-z0-9]");
var isDigit = new RegExp("[0-9]");
var isHex = new RegExp("[0-9a-fA-F]");
function scan(src, scanComments) {
    var i, s, start, ii, esc;
    if (scanComments === void 0) { scanComments = false; }
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                i = 0;
                _a.label = 1;
            case 1:
                if (!(i < src.length)) return [3 /*break*/, 19];
                // Skip space
                while (i < src.length && isSpace.test(src[i])) {
                    i++;
                }
                if (i === src.length) {
                    return [2 /*return*/];
                }
                s = src[i];
                start = i;
                if (!isIdentStart.test(s)) return [3 /*break*/, 3];
                // Identifier
                i++;
                while (i < src.length && isIdent.test(src[i])) {
                    i++;
                }
                return [4 /*yield*/, { t: Literal.Ident, v: src.slice(start, i), first: start, last: i }];
            case 2:
                _a.sent();
                return [3 /*break*/, 18];
            case 3:
                if (!(src.length - i > 1 && src.substr(i, 2) === "0x")) return [3 /*break*/, 5];
                // Bytes
                i += 2;
                while (i < src.length && isHex.test(src[i])) {
                    i++;
                }
                if (((i - start) & 1) !== 0) {
                    throw new ScanError(src, i, "Bytes literal length is expected to be power of two");
                }
                return [4 /*yield*/, { t: Literal.Bytes, v: src.slice(start, i), first: start, last: i }];
            case 4:
                _a.sent();
                return [3 /*break*/, 18];
            case 5:
                if (!(isDigit.test(s) || s === "-")) return [3 /*break*/, 7];
                // Number
                if (s === "-") {
                    i++;
                }
                ii = i;
                while (i < src.length && isDigit.test(src[i])) {
                    i++;
                }
                if (ii === i) {
                    throw new ScanError(src, i, "Number literal is too short");
                }
                return [4 /*yield*/, { t: Literal.Number, v: src.slice(start, i), first: start, last: i }];
            case 6:
                _a.sent();
                return [3 /*break*/, 18];
            case 7:
                if (!(s === "\"")) return [3 /*break*/, 9];
                // String
                i++;
                esc = false;
                for (; i < src.length && (esc || src[i] !== "\""); i++) {
                    if (!esc && src[i] === "\\") {
                        esc = true;
                    }
                    else {
                        esc = false;
                    }
                }
                if (i === src.length) {
                    throw new ScanError(src, i, "Unterminated string literal");
                }
                i++;
                return [4 /*yield*/, { t: Literal.String, v: src.slice(start, i), first: start, last: i }];
            case 8:
                _a.sent();
                return [3 /*break*/, 18];
            case 9:
                if (!(s === "#")) return [3 /*break*/, 12];
                // Comment
                i++;
                while (i < src.length && src[i] !== "\n") {
                    i++;
                }
                if (!scanComments) return [3 /*break*/, 11];
                return [4 /*yield*/, { t: Literal.Comment, v: src.slice(start, i), first: start, last: i }];
            case 10:
                _a.sent();
                _a.label = 11;
            case 11: return [3 /*break*/, 18];
            case 12:
                if (!(src.length - i > 1 && src.substr(i, 2) === "/*")) return [3 /*break*/, 15];
                // C style comment
                i += 2;
                while (i < src.length && !(src.length - i > 1 && src.substr(i, 2) === "*/")) {
                    i++;
                }
                if (i === src.length) {
                    throw new ScanError(src, i, "Unterminated C style comment");
                }
                i += 2;
                if (!scanComments) return [3 /*break*/, 14];
                return [4 /*yield*/, { t: Literal.Comment, v: src.slice(start, i), first: start, last: i }];
            case 13:
                _a.sent();
                _a.label = 14;
            case 14: return [3 /*break*/, 18];
            case 15:
                if (!(s === "(" || s === ")" || s === "{" || s === "}" || s === ";")) return [3 /*break*/, 17];
                i++;
                return [4 /*yield*/, { t: s, v: s, first: start, last: i }];
            case 16:
                _a.sent();
                return [3 /*break*/, 18];
            case 17: throw new ScanError(src, i, "Invalid character at offset " + i + ": `" + s + "'");
            case 18: return [3 /*break*/, 1];
            case 19: return [2 /*return*/];
        }
    });
}
exports.scan = scan;
//# sourceMappingURL=scan.js.map