import os
import unittest

from omrdatasettools.CapitanImageGenerator import CapitanSymbol
from omrdatasettools.ExportPath import ExportPath


class CapitanSymbolTest(unittest.TestCase):
    def setUp(self):
        self.real_content_sample = "dot:0.0000,0.0000;0.0000,0.0000;-0.5310,0.5309;-0.5899,2.2417;-0.4130," \
                                   "4.0115;1.2389,5.5453;3.0087,5.9582;4.6606,5.4273;5.3095,4.5424;5.6045," \
                                   "2.8906;5.0735,1.7698;4.1296,0.9439;3.0677,0.7079;2.0058,0.7079;1.1799," \
                                   "1.4158;1.0619,2.8906;2.1238,4.3065;3.7756,5.0734;5.5455,4.1885;5.5455,4.1885:122," \
                                   "122,119,109,109,92,87,87,88,95,95,89,94,94,105,120,120,125,123,123,113,99,99,95," \
                                   "104,104,114,130,130,142,122,122,119,109,109,92,87,87,88,95,95,89,94,94,105,120," \
                                   "120,125,123,123,113,99,99,95,104,104,114,130,130,142,170,170,169,156,156,134,125," \
                                   "125,129,147,147,151,147,147,145,153,153,161,158,158,146,136,136,136,152,152,166," \
                                   "179,179,184,194,194,196,191,191,177,172,172,178,194,194,196,191,191,178,181,181," \
                                   "190,191,191,185,177,177,176,182,182,196,205,205,203,194,194,196,191,191,177,172," \
                                   "172,178,194,194,196,191,191,178,181,181,190,191,191,185,177,177,176,182,182,196," \
                                   "205,205,203,200,200,202,202,202,199,204,204,212,222,222,218,201,201,186,186,186," \
                                   "194,199,199,202,196,196,189,194,194,206,211,211,207,194,194,195,195,195,196,206," \
                                   "206,215,219,219,208,190,190,171,165,165,163,167,167,176,179,179,182,192,192,204," \
                                   "208,208,206,194,194,195,195,195,196,206,206,215,219,219,208,190,190,171,165,165," \
                                   "163,167,167,176,179,179,182,192,192,204,208,208,206,192,192,193,190,190,188,198," \
                                   "198,207,206,206,189,159,159,129,110,110,98,96,96,109,129,129,155,178,178,194,204," \
                                   "204,210,203,203,197,187,187,183,195,195,199,185,185,155,106,106,71,48,48,33,29," \
                                   "29,39,60,60,95,128,128,143,169,169,199,203,203,197,187,187,183,195,195,199,185," \
                                   "185,155,106,106,71,48,48,33,29,29,39,60,60,95,128,128,143,169,169,199,213,213," \
                                   "205,193,193,194,209,209,203,165,165,113,61,61,30,11,11,3,2,2,4,10,10,36,59,59,73," \
                                   "114,114,168,225,225,207,203,203,208,218,218,199,153,153,89,35,35,10,5,5,1,1,1,1," \
                                   "4,4,4,8,8,17,51,51,125,225,225,207,203,203,208,218,218,199,153,153,89,35,35,10,5," \
                                   "5,1,1,1,1,4,4,4,8,8,17,51,51,125,222,222,219,213,213,211,217,217,202,166,166,106," \
                                   "44,44,9,5,5,1,1,1,1,3,3,0,0,0,0,19,19,80,183,183,205,210,210,207,213,213,210,200," \
                                   "200,160,92,92,29,10,10,2,4,4,1,3,3,1,3,3,1,11,11,64,183,183,205,210,210,207,213," \
                                   "213,210,200,200,160,92,92,29,10,10,2,4,4,1,3,3,1,3,3,1,11,11,64,121,121,168,201," \
                                   "201,207,211,211,215,221,221,209,154,154,80,34,34,6,2,2,1,1,1,3,5,5,8,31,31,85,54," \
                                   "54,115,180,180,205,208,208,206,211,211,218,195,195,146,88,88,34,10,10,11,7,7,10," \
                                   "17,17,38,75,75,123,54,54,115,180,180,205,208,208,206,211,211,218,195,195,146,88," \
                                   "88,34,10,10,11,7,7,10,17,17,38,75,75,123,7,7,62,140,140,186,201,201,202,201,201," \
                                   "214,215,215,196,154,154,103,66,66,54,43,43,48,67,67,93,127,127,156,1,1,32,94,94," \
                                   "155,192,192,206,209,209,214,217,217,212,196,196,175,151,151,130,118,118,118,131," \
                                   "131,146,164,164,175,1,1,32,94,94,155,192,192,206,209,209,214,217,217,212,196,196," \
                                   "175,151,151,130,118,118,118,131,131,146,164,164,175,1,1,16,59,59,127,183,183,209," \
                                   "217,217,213,214,214,212,213,213,215,213,213,201,192,192,178,177,177,178,181,181," \
                                   "187,5,5,6,30,30,92,162,162,209,214,214,220,219,219,218,220,220,229,237,237,234," \
                                   "222,222,212,203,203,193,193,193,200,5,5,6,30,30,92,162,162,209,214,214,220,219," \
                                   "219,218,220,220,229,237,237,234,222,222,212,203,203,193,193,193,200,9,9,4,13,13," \
                                   "60,132,132,195,216,216,226,225,225,221,219,219,219,223,223,222,219,219,217,207," \
                                   "207,199,199,199,204,3,3,4,8,8,37,100,100,170,202,202,215,221,221,220,217,217,213," \
                                   "209,209,207,210,210,212,213,213,207,204,204,205,3,3,4,8,8,37,100,100,170,202,202," \
                                   "215,221,221,220,217,217,213,209,209,207,210,210,212,213,213,207,204,204,205,2,2," \
                                   "2,2,2,8,58,58,134,182,182,206,212,212,215,216,216,212,204,204,200,202,202,206," \
                                   "207,207,205,202,202,200 "

    def test_initialize_from_empty_string_expect_empty_symbol(self):
        # Arrange

        # Act
        symbol = CapitanSymbol.initialize_from_string("")

        # Assert
        self.assertIsNone(symbol)

    def test_initialize_with_real_symbol(self):
        # Act
        symbol = CapitanSymbol.initialize_from_string(self.real_content_sample)

        # Assert
        self.assertIsNotNone(symbol)
        self.assertEqual("dot", symbol.symbol_class)
        self.assertEqual(self.real_content_sample, symbol.content)
        self.assertEqual(20, len(symbol.stroke))
        self.assertIsNotNone(symbol.image_data)
        self.assertEqual((30, 30), symbol.image_data.shape)

    def test_draw_capitan_score_bitmap(self):
        # Arrange
        symbol = CapitanSymbol.initialize_from_string(self.real_content_sample)
        export_path = ExportPath("", "", "bitmap", "png", 2)

        # Act
        symbol.draw_capitan_score_bitmap(export_path)

        # Assert
        self.assertTrue(os.path.exists(export_path.get_full_path()))

        # Cleanup
        os.remove(export_path.get_full_path())

    def test_draw_capitan_stroke_onto_canvas(self):
        # Arrange
        symbol = CapitanSymbol.initialize_from_string(self.real_content_sample)
        export_path = ExportPath("", "", "bitmap", "png", 2)

        # Act
        symbol.draw_capitan_stroke_onto_canvas(export_path, stroke_thickness=2, margin=2)

        # Assert
        self.assertTrue(os.path.exists(export_path.get_full_path()))

        # Cleanup
        os.remove(export_path.get_full_path())


if __name__ == '__main__':
    unittest.main()
