# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nonebot_plugin_trace_moe']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.3,<4.0.0',
 'nonebot-adapter-onebot>=2.1.3,<3.0.0',
 'nonebot2>=2.0.0b5,<3.0.0']

setup_kwargs = {
    'name': 'nonebot-plugin-trace-moe',
    'version': '0.1.0',
    'description': '适用于nonebot2 v11的基于trace.moe的动画截图场景追溯插件',
    'long_description': '<div align="center">\n  <a href="https://v2.nonebot.dev/store"><img src="https://github.com/A-kirami/nonebot-plugin-template/blob/resources/nbp_logo.png" width="180" height="180" alt="NoneBotPluginLogo"></a>\n  <br>\n  <p><img src="https://github.com/A-kirami/nonebot-plugin-template/blob/resources/NoneBotPlugin.svg" width="240" alt="NoneBotPluginText"></p>\n</div>\n\n<div align="center">\n\n# nonebot_plugin_trace_moe\n  \n_✨ NoneBot 基于trace.moe的动画截图场景追溯插件 ✨_\n  \n<a href="https://github.com/Ikaros-521/nonebot_plugin_trace_moe/stargazers">\n    <img alt="GitHub stars" src="https://img.shields.io/github/stars/Ikaros-521/nonebot_plugin_trace_moe?color=%09%2300BFFF&style=flat-square">\n</a>\n<a href="https://github.com/Ikaros-521/nonebot_plugin_trace_moe/issues">\n    <img alt="GitHub issues" src="https://img.shields.io/github/issues/Ikaros-521/nonebot_plugin_trace_moe?color=Emerald%20green&style=flat-square">\n</a>\n<a href="https://github.com/Ikaros-521/nonebot_plugin_trace_moe/network">\n    <img alt="GitHub forks" src="https://img.shields.io/github/forks/Ikaros-521/nonebot_plugin_trace_moe?color=%2300BFFF&style=flat-square">\n</a>\n<a href="./LICENSE">\n    <img src="https://img.shields.io/github/license/Ikaros-521/nonebot_plugin_trace_moe.svg" alt="license">\n</a>\n<a href="https://pypi.python.org/pypi/nonebot_plugin_trace_moe">\n    <img src="https://img.shields.io/pypi/v/nonebot_plugin_trace_moe.svg" alt="pypi">\n</a>\n<a href="https://www.python.org">\n    <img src="https://img.shields.io/badge/python-3.8+-blue.svg" alt="python">\n</a>\n\n</div>\n\n适用于nonebot2 v11的基于trace.moe的动画截图场景追溯插件  \n调用的相关API源自:https://soruly.github.io/trace.moe-api/#/  \nps:查询结果可能会有H，请自行注意  \n\n<!-- START doctoc generated TOC please keep comment here to allow auto update -->\n<!-- DON\'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->\n## 目录\n\n- [nonebot_plugin_trace_moe](#nonebot_plugin_trace_moe)\n  - [🔧 开发环境](#-%E5%BC%80%E5%8F%91%E7%8E%AF%E5%A2%83)\n  - [💿 安装](#-%E5%AE%89%E8%A3%85)\n    - [1. nb-cli安装（推荐）](#1-nb-cli%E5%AE%89%E8%A3%85%E6%8E%A8%E8%8D%90)\n    - [2. 本地安装](#2-%E6%9C%AC%E5%9C%B0%E5%AE%89%E8%A3%85)\n    - [3. pip安装](#3-pip%E5%AE%89%E8%A3%85)\n    - [更新版本](#%E6%9B%B4%E6%96%B0%E7%89%88%E6%9C%AC)\n  - [🔧 配置](#-%E9%85%8D%E7%BD%AE)\n    - [env配置](#env%E9%85%8D%E7%BD%AE)\n  - [🎉 功能](#-%E5%8A%9F%E8%83%BD)\n  - [👉 命令](#-%E5%91%BD%E4%BB%A4)\n    - [1、先发送命令，再发送图片（命令前缀请自行替换）](#1%E5%85%88%E5%8F%91%E9%80%81%E5%91%BD%E4%BB%A4%E5%86%8D%E5%8F%91%E9%80%81%E5%9B%BE%E7%89%87%E5%91%BD%E4%BB%A4%E5%89%8D%E7%BC%80%E8%AF%B7%E8%87%AA%E8%A1%8C%E6%9B%BF%E6%8D%A2)\n    - [2、命令+图片](#2%E5%91%BD%E4%BB%A4%E5%9B%BE%E7%89%87)\n    - [3、回复图片+命令](#3%E5%9B%9E%E5%A4%8D%E5%9B%BE%E7%89%87%E5%91%BD%E4%BB%A4)\n  - [⚙ 拓展](#-%E6%8B%93%E5%B1%95)\n  - [📝 更新日志](#-%E6%9B%B4%E6%96%B0%E6%97%A5%E5%BF%97)\n  - [致谢](#%E8%87%B4%E8%B0%A2)\n  - [项目打包上传至pypi](#%E9%A1%B9%E7%9B%AE%E6%89%93%E5%8C%85%E4%B8%8A%E4%BC%A0%E8%87%B3pypi)\n\n<!-- END doctoc generated TOC please keep comment here to allow auto update -->\n\n\n## 🔧 开发环境\nNonebot2：2.0.0b5  \npython：3.8.13  \n操作系统：Windows10（Linux兼容性问题不大）  \n编辑器：pycharm  \n\n## 💿 安装\n环境依赖`aiohttp、asyncio`库   \n\n### 1. nb-cli安装（推荐）\n在你bot工程的文件夹下，运行cmd（运行路径要对啊），执行nb命令安装插件，插件配置会自动添加至配置文件  \n```\nnb plugin install nonebot_plugin_trace_moe\n```\n\n### 2. 本地安装\n先安装下 `aiohttp`  \n```\npip install aiohttp\n```\n将项目clone到你的机器人插件下的对应插件目录内（一般为机器人文件夹下的`src/plugins`），然后把`nonebot_plugin_trace_moe`文件夹里的内容拷贝至上一级目录即可。  \nclone命令参考（得先装`git`，懂的都懂）：\n```\ngit clone https://github.com/Ikaros-521/nonebot_plugin_trace_moe.git\n``` \n也可以直接下载压缩包到插件目录解压，然后同样提取`nonebot_plugin_trace_moe`至上一级目录。  \n目录结构： ```你的bot/src/plugins/nonebot_plugin_trace_moe/__init__.py```  \n\n\n### 3. pip安装\n```\npip install nonebot_plugin_trace_moe\n```  \n打开 nonebot2 项目的 ```bot.py``` 文件, 在其中写入  \n```nonebot.load_plugin(\'nonebot_plugin_trace_moe\')```  \n当然，如果是默认nb-cli创建的nonebot2的话，在bot路径```pyproject.toml```的```[tool.nonebot]```的```plugins```中添加```nonebot_plugin_trace_moe```即可  \npyproject.toml配置例如：  \n``` \n[tool.nonebot]\nplugin_dirs = ["src/plugins"]\nplugins = ["nonebot_plugin_trace_moe"]\n``` \n\n### 更新版本\n```\nnb plugin update nonebot_plugin_trace_moe\n```\n\n## 🔧 配置  \n\n### env配置\n```\n# nonebot_plugin_trace_moe\n# 最大返回查询结果数\ntrace_moe_max_ret=3\n# 自动撤回时间（秒）\ntrace_moe_withdraw_time=100\n```\n|       配置项        | 必填 | 默认值  |                      说明                      |\n|:----------------:|:----:|:----:|:----------------------------:|\n| `trace_moe_max_ret` | 否 | `3` | 最大返回查询结果数 |\n| `trace_moe_withdraw_time` | 否 | `0` | 自动撤回延时（秒），为0是不撤回 |\n\n\n## 🎉 功能\n调用trace.moe的API查询动画截图源自的作品名和时间段  \n\n## 👉 命令\n\n### 1、先发送命令，再发送图片（命令前缀请自行替换）\n先发送`/图片来源`或`/trace`或`/图片定位`，等bot返回`请发送需要识别的图片喵~`后，发送需要识别的图片即可。  \n\n### 2、命令+图片\n编辑消息`/图片来源[待识别的图片]`或`/trace[待识别的图片]`或`/图片定位[待识别的图片]`发送即可。  \nbot返回内容：  \n![](docs/result.png)  \n\n### 3、回复图片+命令\n回复需要处理的图片，发送`/图片来源`或`/trace`或`/图片定位`即可。  \n\n## ⚙ 拓展\n修改`__init__.py`中的`catch_str = on_command("图片来源", aliases={"trace", "图片定位"})`来自定义命令触发关键词。  \n\n## 📝 更新日志\n\n<details>\n<summary>展开/收起</summary>\n\n### 0.0.1\n\n- 插件初次发布\n\n### 0.0.2\n\n- 向上兼容rc2  \n\n### 0.0.3\n\n- 可以通过回复图片触发  \n\n### 0.0.4\n\n- 插件补充元信息  \n- 优化异常报错\n\n### 0.1.0\n\n- 实现自动撤回功能（保号）  \n\n</details>\n\n## 致谢\n\n- [trace.moe](https://trace.moe) - API来源  \n\n## 项目打包上传至pypi\n\n官网：https://pypi.org，注册账号，在系统用户根目录下创建`.pypirc`，配置  \n``` \n[distutils] \nindex-servers=pypi \n \n[pypi] repository = https://upload.pypi.org/legacy/ \nusername = 用户名 \npassword = 密码\n```\n\n### poetry\n\n```\n# 参考 https://www.freesion.com/article/58051228882/\n# poetry config pypi-token.pypi\n\n# 1、安装poetry\npip install poetry\n\n# 2、初始化配置文件（根据提示填写）\npoetry init\n\n# 3、微调配置文件pyproject.toml\n\n# 4、运行 poetry install, 可生成 “poetry.lock” 文件（可跳过）\npoetry install\n\n# 5、编译，生成dist\npoetry build\n\n# 6、发布(poetry config pypi-token.pypi 配置token)\npoetry publish\n\n```\n\n### twine\n\n```\n# 参考 https://www.cnblogs.com/danhuai/p/14915042.html\n#创建setup.py文件 填写相关信息\n\n# 1、可以先升级打包工具\npip install --upgrade setuptools wheel twine\n\n# 2、打包\npython setup.py sdist bdist_wheel\n\n# 3、可以先检查一下包\ntwine check dist/*\n\n# 4、上传包到pypi（需输入用户名、密码）\ntwine upload dist/*\n```',
    'author': 'Ikaros',
    'author_email': '327209194@qq.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Ikaros-521/nonebot_plugin_trace_moe',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
