"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNodeListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * (experimental) Defines listener for a VirtualNode.
 *
 * @experimental
 */
class VirtualNodeListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualNode.
     *
     * @experimental
     */
    static http(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection);
    }
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualNode.
     *
     * @experimental
     */
    static http2(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP2, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection);
    }
    /**
     * (experimental) Returns an GRPC Listener for a VirtualNode.
     *
     * @experimental
     */
    static grpc(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.GRPC, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection);
    }
    /**
     * (experimental) Returns an TCP Listener for a VirtualNode.
     *
     * @experimental
     */
    static tcp(props = {}) {
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.TCP, props.healthCheck, props.timeout, props.port, props.tlsCertificate, props.outlierDetection);
    }
}
exports.VirtualNodeListener = VirtualNodeListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualNodeListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualNodeListener", version: "1.98.0" };
class VirtualNodeListenerImpl extends VirtualNodeListener {
    constructor(protocol, healthCheck, timeout, port = 8080, tlsCertificate, outlierDetection) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.timeout = timeout;
        this.port = port;
        this.tlsCertificate = tlsCertificate;
        this.outlierDetection = outlierDetection;
    }
    bind(scope) {
        var _b;
        const tlsConfig = (_b = this.tlsCertificate) === null || _b === void 0 ? void 0 : _b.bind(scope);
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: this.healthCheck ? this.renderHealthCheck(this.healthCheck) : undefined,
                timeout: this.timeout ? this.renderTimeout(this.timeout) : undefined,
                tls: tlsConfig ? this.renderTls(tlsConfig) : undefined,
                outlierDetection: this.outlierDetection ? this.renderOutlierDetection(this.outlierDetection) : undefined,
            },
        };
    }
    /**
     * Renders the TLS config for a listener
     */
    renderTls(tlsCertificateConfig) {
        return {
            certificate: tlsCertificateConfig.tlsCertificate,
            mode: tlsCertificateConfig.tlsMode.toString(),
        };
    }
    renderHealthCheck(hc) {
        if (hc === undefined) {
            return undefined;
        }
        if (hc.protocol === shared_interfaces_1.Protocol.TCP && hc.path) {
            throw new Error('The path property cannot be set with Protocol.TCP');
        }
        if (hc.protocol === shared_interfaces_1.Protocol.GRPC && hc.path) {
            throw new Error('The path property cannot be set with Protocol.GRPC');
        }
        const healthCheck = {
            healthyThreshold: hc.healthyThreshold || 2,
            intervalMillis: (hc.interval || cdk.Duration.seconds(5)).toMilliseconds(),
            path: hc.path || (hc.protocol === shared_interfaces_1.Protocol.HTTP ? '/' : undefined),
            port: hc.port || this.port,
            protocol: hc.protocol || this.protocol,
            timeoutMillis: (hc.timeout || cdk.Duration.seconds(2)).toMilliseconds(),
            unhealthyThreshold: hc.unhealthyThreshold || 2,
        };
        utils_1.validateHealthChecks(healthCheck);
        return healthCheck;
    }
    renderTimeout(timeout) {
        return ({
            [this.protocol]: {
                idle: (timeout === null || timeout === void 0 ? void 0 : timeout.idle) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.idle.toMilliseconds(),
                } : undefined,
                perRequest: (timeout === null || timeout === void 0 ? void 0 : timeout.perRequest) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.perRequest.toMilliseconds(),
                } : undefined,
            },
        });
    }
    renderOutlierDetection(outlierDetection) {
        return {
            baseEjectionDuration: {
                unit: 'ms',
                value: outlierDetection.baseEjectionDuration.toMilliseconds(),
            },
            interval: {
                unit: 'ms',
                value: outlierDetection.interval.toMilliseconds(),
            },
            maxEjectionPercent: outlierDetection.maxEjectionPercent,
            maxServerErrors: outlierDetection.maxServerErrors,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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