"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Backend = exports.AccessLog = exports.Protocol = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Enum of supported AppMesh protocols.
 *
 * @experimental
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "http";
    Protocol["TCP"] = "tcp";
    Protocol["HTTP2"] = "http2";
    Protocol["GRPC"] = "grpc";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * (experimental) Configuration for Envoy Access logs for mesh endpoints.
 *
 * @experimental
 */
class AccessLog {
    /**
     * (experimental) Path to a file to write access logs to.
     *
     * @default - no file based access logging
     * @experimental
     */
    static fromFilePath(filePath) {
        return new FileAccessLog(filePath);
    }
}
exports.AccessLog = AccessLog;
_a = JSII_RTTI_SYMBOL_1;
AccessLog[_a] = { fqn: "@aws-cdk/aws-appmesh.AccessLog", version: "1.98.0" };
/**
 * Configuration for Envoy Access logs for mesh endpoints
 */
class FileAccessLog extends AccessLog {
    constructor(filePath) {
        super();
        this.filePath = filePath;
    }
    bind(_scope) {
        return {
            virtualNodeAccessLog: {
                file: {
                    path: this.filePath,
                },
            },
            virtualGatewayAccessLog: {
                file: {
                    path: this.filePath,
                },
            },
        };
    }
}
/**
 * (experimental) Contains static factory methods to create backends.
 *
 * @experimental
 */
class Backend {
    /**
     * (experimental) Construct a Virtual Service backend.
     *
     * @experimental
     */
    static virtualService(virtualService, props = {}) {
        return new VirtualServiceBackend(virtualService, props.clientPolicy);
    }
}
exports.Backend = Backend;
_b = JSII_RTTI_SYMBOL_1;
Backend[_b] = { fqn: "@aws-cdk/aws-appmesh.Backend", version: "1.98.0" };
/**
 * Represents the properties needed to define a Virtual Service backend
 */
class VirtualServiceBackend extends Backend {
    constructor(virtualService, clientPolicy) {
        super();
        this.virtualService = virtualService;
        this.clientPolicy = clientPolicy;
    }
    /**
     * Return config for a Virtual Service backend
     */
    bind(_scope) {
        var _c;
        return {
            virtualServiceBackend: {
                virtualService: {
                    virtualServiceName: this.virtualService.virtualServiceName,
                    clientPolicy: (_c = this.clientPolicy) === null || _c === void 0 ? void 0 : _c.bind(_scope).clientPolicy,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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