"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRepositoryAccess = exports.CfnRepositoryAccessPropsPermission = exports.toJson_CfnRepositoryAccessProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnRepositoryAccessProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnRepositoryAccessProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Org': obj.org,
        'Team': obj.team,
        'Owner': obj.owner,
        'Repository': obj.repository,
        'Permission': obj.permission,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnRepositoryAccessProps = toJson_CfnRepositoryAccessProps;
/* eslint-enable max-len, quote-props */
/**
 * The permission to grant the team on this repository. In addition to the enumerated values, you can also specify a custom repository role name, if the owning organization has defined any. If no permission is specified, the team's permission attribute will be used to determine what permission to grant the team on this repository.
 *
 * @schema CfnRepositoryAccessPropsPermission
 */
var CfnRepositoryAccessPropsPermission;
(function (CfnRepositoryAccessPropsPermission) {
    /** pull */
    CfnRepositoryAccessPropsPermission["PULL"] = "pull";
    /** push */
    CfnRepositoryAccessPropsPermission["PUSH"] = "push";
    /** admin */
    CfnRepositoryAccessPropsPermission["ADMIN"] = "admin";
    /** maintain */
    CfnRepositoryAccessPropsPermission["MAINTAIN"] = "maintain";
    /** triage */
    CfnRepositoryAccessPropsPermission["TRIAGE"] = "triage";
})(CfnRepositoryAccessPropsPermission = exports.CfnRepositoryAccessPropsPermission || (exports.CfnRepositoryAccessPropsPermission = {}));
/**
 * A CloudFormation `GitHub::Teams::RepositoryAccess`
 *
 * @cloudformationResource GitHub::Teams::RepositoryAccess
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
class CfnRepositoryAccess extends cdk.CfnResource {
    /**
     * Create a new `GitHub::Teams::RepositoryAccess`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRepositoryAccess.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnRepositoryAccessProps(props) });
        this.props = props;
    }
}
exports.CfnRepositoryAccess = CfnRepositoryAccess;
_a = JSII_RTTI_SYMBOL_1;
CfnRepositoryAccess[_a] = { fqn: "@cdk-cloudformation/github-teams-repositoryaccess.CfnRepositoryAccess", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnRepositoryAccess.CFN_RESOURCE_TYPE_NAME = "GitHub::Teams::RepositoryAccess";
//# sourceMappingURL=data:application/json;base64,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