import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a team access to a repository in GitHub.
 *
 * @schema CfnRepositoryAccessProps
 */
export interface CfnRepositoryAccessProps {
    /**
     * The organization name. The name is not case sensitive.
     *
     * @schema CfnRepositoryAccessProps#Org
     */
    readonly org: string;
    /**
     * The slug of the team name.
     *
     * @schema CfnRepositoryAccessProps#Team
     */
    readonly team: string;
    /**
     * The account owner of the repository. The name is not case sensitive.
     *
     * @schema CfnRepositoryAccessProps#Owner
     */
    readonly owner: string;
    /**
     * The name of the repository. The name is not case sensitive.
     *
     * @schema CfnRepositoryAccessProps#Repository
     */
    readonly repository: string;
    /**
     * The permission to grant the team on this repository. In addition to the enumerated values, you can also specify a custom repository role name, if the owning organization has defined any. If no permission is specified, the team's permission attribute will be used to determine what permission to grant the team on this repository.
     *
     * @schema CfnRepositoryAccessProps#Permission
     */
    readonly permission?: CfnRepositoryAccessPropsPermission;
}
/**
 * Converts an object of type 'CfnRepositoryAccessProps' to JSON representation.
 */
export declare function toJson_CfnRepositoryAccessProps(obj: CfnRepositoryAccessProps | undefined): Record<string, any> | undefined;
/**
 * The permission to grant the team on this repository. In addition to the enumerated values, you can also specify a custom repository role name, if the owning organization has defined any. If no permission is specified, the team's permission attribute will be used to determine what permission to grant the team on this repository.
 *
 * @schema CfnRepositoryAccessPropsPermission
 */
export declare enum CfnRepositoryAccessPropsPermission {
    /** pull */
    PULL = "pull",
    /** push */
    PUSH = "push",
    /** admin */
    ADMIN = "admin",
    /** maintain */
    MAINTAIN = "maintain",
    /** triage */
    TRIAGE = "triage"
}
/**
 * A CloudFormation `GitHub::Teams::RepositoryAccess`
 *
 * @cloudformationResource GitHub::Teams::RepositoryAccess
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
export declare class CfnRepositoryAccess extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitHub::Teams::RepositoryAccess";
    /**
     * Resource props.
     */
    readonly props: CfnRepositoryAccessProps;
    /**
     * Create a new `GitHub::Teams::RepositoryAccess`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnRepositoryAccessProps);
}
