# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtOpenGL, except for defaults which are replaced by "...".
"""

# Module PySide2.QtOpenGL
import PySide2
import typing

import shiboken2 as Shiboken

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import PySide2.QtOpenGL


class QGL(Shiboken.Object):
    DoubleBuffer             : QGL = ... # 0x1
    DepthBuffer              : QGL = ... # 0x2
    Rgba                     : QGL = ... # 0x4
    AlphaChannel             : QGL = ... # 0x8
    AccumBuffer              : QGL = ... # 0x10
    StencilBuffer            : QGL = ... # 0x20
    StereoBuffers            : QGL = ... # 0x40
    DirectRendering          : QGL = ... # 0x80
    HasOverlay               : QGL = ... # 0x100
    SampleBuffers            : QGL = ... # 0x200
    DeprecatedFunctions      : QGL = ... # 0x400
    SingleBuffer             : QGL = ... # 0x10000
    NoDepthBuffer            : QGL = ... # 0x20000
    ColorIndex               : QGL = ... # 0x40000
    NoAlphaChannel           : QGL = ... # 0x80000
    NoAccumBuffer            : QGL = ... # 0x100000
    NoStencilBuffer          : QGL = ... # 0x200000
    NoStereoBuffers          : QGL = ... # 0x400000
    IndirectRendering        : QGL = ... # 0x800000
    NoOverlay                : QGL = ... # 0x1000000
    NoSampleBuffers          : QGL = ... # 0x2000000
    NoDeprecatedFunctions    : QGL = ... # 0x4000000

    class FormatOption(object):
        DoubleBuffer             : QGL.FormatOption = ... # 0x1
        DepthBuffer              : QGL.FormatOption = ... # 0x2
        Rgba                     : QGL.FormatOption = ... # 0x4
        AlphaChannel             : QGL.FormatOption = ... # 0x8
        AccumBuffer              : QGL.FormatOption = ... # 0x10
        StencilBuffer            : QGL.FormatOption = ... # 0x20
        StereoBuffers            : QGL.FormatOption = ... # 0x40
        DirectRendering          : QGL.FormatOption = ... # 0x80
        HasOverlay               : QGL.FormatOption = ... # 0x100
        SampleBuffers            : QGL.FormatOption = ... # 0x200
        DeprecatedFunctions      : QGL.FormatOption = ... # 0x400
        SingleBuffer             : QGL.FormatOption = ... # 0x10000
        NoDepthBuffer            : QGL.FormatOption = ... # 0x20000
        ColorIndex               : QGL.FormatOption = ... # 0x40000
        NoAlphaChannel           : QGL.FormatOption = ... # 0x80000
        NoAccumBuffer            : QGL.FormatOption = ... # 0x100000
        NoStencilBuffer          : QGL.FormatOption = ... # 0x200000
        NoStereoBuffers          : QGL.FormatOption = ... # 0x400000
        IndirectRendering        : QGL.FormatOption = ... # 0x800000
        NoOverlay                : QGL.FormatOption = ... # 0x1000000
        NoSampleBuffers          : QGL.FormatOption = ... # 0x2000000
        NoDeprecatedFunctions    : QGL.FormatOption = ... # 0x4000000

    class FormatOptions(object): ...


class QGLBuffer(Shiboken.Object):
    VertexBuffer             : QGLBuffer = ... # 0x8892
    IndexBuffer              : QGLBuffer = ... # 0x8893
    ReadOnly                 : QGLBuffer = ... # 0x88b8
    WriteOnly                : QGLBuffer = ... # 0x88b9
    ReadWrite                : QGLBuffer = ... # 0x88ba
    StreamDraw               : QGLBuffer = ... # 0x88e0
    StreamRead               : QGLBuffer = ... # 0x88e1
    StreamCopy               : QGLBuffer = ... # 0x88e2
    StaticDraw               : QGLBuffer = ... # 0x88e4
    StaticRead               : QGLBuffer = ... # 0x88e5
    StaticCopy               : QGLBuffer = ... # 0x88e6
    DynamicDraw              : QGLBuffer = ... # 0x88e8
    DynamicRead              : QGLBuffer = ... # 0x88e9
    DynamicCopy              : QGLBuffer = ... # 0x88ea
    PixelPackBuffer          : QGLBuffer = ... # 0x88eb
    PixelUnpackBuffer        : QGLBuffer = ... # 0x88ec

    class Access(object):
        ReadOnly                 : QGLBuffer.Access = ... # 0x88b8
        WriteOnly                : QGLBuffer.Access = ... # 0x88b9
        ReadWrite                : QGLBuffer.Access = ... # 0x88ba

    class Type(object):
        VertexBuffer             : QGLBuffer.Type = ... # 0x8892
        IndexBuffer              : QGLBuffer.Type = ... # 0x8893
        PixelPackBuffer          : QGLBuffer.Type = ... # 0x88eb
        PixelUnpackBuffer        : QGLBuffer.Type = ... # 0x88ec

    class UsagePattern(object):
        StreamDraw               : QGLBuffer.UsagePattern = ... # 0x88e0
        StreamRead               : QGLBuffer.UsagePattern = ... # 0x88e1
        StreamCopy               : QGLBuffer.UsagePattern = ... # 0x88e2
        StaticDraw               : QGLBuffer.UsagePattern = ... # 0x88e4
        StaticRead               : QGLBuffer.UsagePattern = ... # 0x88e5
        StaticCopy               : QGLBuffer.UsagePattern = ... # 0x88e6
        DynamicDraw              : QGLBuffer.UsagePattern = ... # 0x88e8
        DynamicRead              : QGLBuffer.UsagePattern = ... # 0x88e9
        DynamicCopy              : QGLBuffer.UsagePattern = ... # 0x88ea

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtOpenGL.QGLBuffer) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtOpenGL.QGLBuffer.Type) -> None: ...

    @typing.overload
    def allocate(self, count:int) -> None: ...
    @typing.overload
    def allocate(self, data:int, count:int=...) -> None: ...
    def bind(self) -> bool: ...
    def bufferId(self) -> int: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def map(self, access:PySide2.QtOpenGL.QGLBuffer.Access) -> int: ...
    def read(self, offset:int, data:int, count:int) -> bool: ...
    @typing.overload
    def release(self) -> None: ...
    @typing.overload
    @staticmethod
    def release(type:PySide2.QtOpenGL.QGLBuffer.Type) -> None: ...
    def setUsagePattern(self, value:PySide2.QtOpenGL.QGLBuffer.UsagePattern) -> None: ...
    def size(self) -> int: ...
    def type(self) -> PySide2.QtOpenGL.QGLBuffer.Type: ...
    def unmap(self) -> bool: ...
    def usagePattern(self) -> PySide2.QtOpenGL.QGLBuffer.UsagePattern: ...
    def write(self, offset:int, data:int, count:int=...) -> None: ...


class QGLColormap(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtOpenGL.QGLColormap) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def entryColor(self, idx:int) -> PySide2.QtGui.QColor: ...
    def entryRgb(self, idx:int) -> int: ...
    def find(self, color:int) -> int: ...
    def findNearest(self, color:int) -> int: ...
    def handle(self) -> int: ...
    def isEmpty(self) -> bool: ...
    @typing.overload
    def setEntry(self, idx:int, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setEntry(self, idx:int, color:int) -> None: ...
    def setHandle(self, ahandle:int) -> None: ...
    def size(self) -> int: ...


class QGLContext(Shiboken.Object):
    NoBindOption             : QGLContext = ... # 0x0
    InvertedYBindOption      : QGLContext = ... # 0x1
    MipmapBindOption         : QGLContext = ... # 0x2
    PremultipliedAlphaBindOption: QGLContext = ... # 0x4
    LinearFilteringBindOption: QGLContext = ... # 0x8
    DefaultBindOption        : QGLContext = ... # 0xb
    MemoryManagedBindOption  : QGLContext = ... # 0x10
    InternalBindOption       : QGLContext = ... # 0x14
    CanFlipNativePixmapBindOption: QGLContext = ... # 0x20
    TemporarilyCachedBindOption: QGLContext = ... # 0x40

    class BindOption(object):
        NoBindOption             : QGLContext.BindOption = ... # 0x0
        InvertedYBindOption      : QGLContext.BindOption = ... # 0x1
        MipmapBindOption         : QGLContext.BindOption = ... # 0x2
        PremultipliedAlphaBindOption: QGLContext.BindOption = ... # 0x4
        LinearFilteringBindOption: QGLContext.BindOption = ... # 0x8
        DefaultBindOption        : QGLContext.BindOption = ... # 0xb
        MemoryManagedBindOption  : QGLContext.BindOption = ... # 0x10
        InternalBindOption       : QGLContext.BindOption = ... # 0x14
        CanFlipNativePixmapBindOption: QGLContext.BindOption = ... # 0x20
        TemporarilyCachedBindOption: QGLContext.BindOption = ... # 0x40

    class BindOptions(object): ...

    def __init__(self, format:PySide2.QtOpenGL.QGLFormat) -> None: ...

    @staticmethod
    def areSharing(context1:PySide2.QtOpenGL.QGLContext, context2:PySide2.QtOpenGL.QGLContext) -> bool: ...
    @typing.overload
    def bindTexture(self, fileName:str) -> int: ...
    @typing.overload
    def bindTexture(self, image:PySide2.QtGui.QImage, target:int, format:int, options:PySide2.QtOpenGL.QGLContext.BindOptions) -> int: ...
    @typing.overload
    def bindTexture(self, image:PySide2.QtGui.QImage, target:int=..., format:int=...) -> int: ...
    @typing.overload
    def bindTexture(self, pixmap:PySide2.QtGui.QPixmap, target:int, format:int, options:PySide2.QtOpenGL.QGLContext.BindOptions) -> int: ...
    @typing.overload
    def bindTexture(self, pixmap:PySide2.QtGui.QPixmap, target:int=..., format:int=...) -> int: ...
    def chooseContext(self, shareContext:typing.Optional[PySide2.QtOpenGL.QGLContext]=...) -> bool: ...
    def colorIndex(self, c:PySide2.QtGui.QColor) -> int: ...
    def contextHandle(self) -> PySide2.QtGui.QOpenGLContext: ...
    def create(self, shareContext:typing.Optional[PySide2.QtOpenGL.QGLContext]=...) -> bool: ...
    @staticmethod
    def currentContext() -> PySide2.QtOpenGL.QGLContext: ...
    def deleteTexture(self, tx_id:int) -> None: ...
    def device(self) -> PySide2.QtGui.QPaintDevice: ...
    def deviceIsPixmap(self) -> bool: ...
    def doneCurrent(self) -> None: ...
    @typing.overload
    def drawTexture(self, point:PySide2.QtCore.QPointF, textureId:int, textureTarget:int=...) -> None: ...
    @typing.overload
    def drawTexture(self, target:PySide2.QtCore.QRectF, textureId:int, textureTarget:int=...) -> None: ...
    def format(self) -> PySide2.QtOpenGL.QGLFormat: ...
    @staticmethod
    def fromOpenGLContext(platformContext:PySide2.QtGui.QOpenGLContext) -> PySide2.QtOpenGL.QGLContext: ...
    def initialized(self) -> bool: ...
    def isSharing(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> None: ...
    def moveToThread(self, thread:PySide2.QtCore.QThread) -> None: ...
    def overlayTransparentColor(self) -> PySide2.QtGui.QColor: ...
    def requestedFormat(self) -> PySide2.QtOpenGL.QGLFormat: ...
    def reset(self) -> None: ...
    def setDevice(self, pDev:PySide2.QtGui.QPaintDevice) -> None: ...
    def setFormat(self, format:PySide2.QtOpenGL.QGLFormat) -> None: ...
    def setInitialized(self, on:bool) -> None: ...
    @staticmethod
    def setTextureCacheLimit(size:int) -> None: ...
    def setValid(self, valid:bool) -> None: ...
    def setWindowCreated(self, on:bool) -> None: ...
    def swapBuffers(self) -> None: ...
    @staticmethod
    def textureCacheLimit() -> int: ...
    def windowCreated(self) -> bool: ...


class QGLFormat(Shiboken.Object):
    NoProfile                : QGLFormat = ... # 0x0
    OpenGL_Version_None      : QGLFormat = ... # 0x0
    CoreProfile              : QGLFormat = ... # 0x1
    OpenGL_Version_1_1       : QGLFormat = ... # 0x1
    CompatibilityProfile     : QGLFormat = ... # 0x2
    OpenGL_Version_1_2       : QGLFormat = ... # 0x2
    OpenGL_Version_1_3       : QGLFormat = ... # 0x4
    OpenGL_Version_1_4       : QGLFormat = ... # 0x8
    OpenGL_Version_1_5       : QGLFormat = ... # 0x10
    OpenGL_Version_2_0       : QGLFormat = ... # 0x20
    OpenGL_Version_2_1       : QGLFormat = ... # 0x40
    OpenGL_ES_Common_Version_1_0: QGLFormat = ... # 0x80
    OpenGL_ES_CommonLite_Version_1_0: QGLFormat = ... # 0x100
    OpenGL_ES_Common_Version_1_1: QGLFormat = ... # 0x200
    OpenGL_ES_CommonLite_Version_1_1: QGLFormat = ... # 0x400
    OpenGL_ES_Version_2_0    : QGLFormat = ... # 0x800
    OpenGL_Version_3_0       : QGLFormat = ... # 0x1000
    OpenGL_Version_3_1       : QGLFormat = ... # 0x2000
    OpenGL_Version_3_2       : QGLFormat = ... # 0x4000
    OpenGL_Version_3_3       : QGLFormat = ... # 0x8000
    OpenGL_Version_4_0       : QGLFormat = ... # 0x10000
    OpenGL_Version_4_1       : QGLFormat = ... # 0x20000
    OpenGL_Version_4_2       : QGLFormat = ... # 0x40000
    OpenGL_Version_4_3       : QGLFormat = ... # 0x80000

    class OpenGLContextProfile(object):
        NoProfile                : QGLFormat.OpenGLContextProfile = ... # 0x0
        CoreProfile              : QGLFormat.OpenGLContextProfile = ... # 0x1
        CompatibilityProfile     : QGLFormat.OpenGLContextProfile = ... # 0x2

    class OpenGLVersionFlag(object):
        OpenGL_Version_None      : QGLFormat.OpenGLVersionFlag = ... # 0x0
        OpenGL_Version_1_1       : QGLFormat.OpenGLVersionFlag = ... # 0x1
        OpenGL_Version_1_2       : QGLFormat.OpenGLVersionFlag = ... # 0x2
        OpenGL_Version_1_3       : QGLFormat.OpenGLVersionFlag = ... # 0x4
        OpenGL_Version_1_4       : QGLFormat.OpenGLVersionFlag = ... # 0x8
        OpenGL_Version_1_5       : QGLFormat.OpenGLVersionFlag = ... # 0x10
        OpenGL_Version_2_0       : QGLFormat.OpenGLVersionFlag = ... # 0x20
        OpenGL_Version_2_1       : QGLFormat.OpenGLVersionFlag = ... # 0x40
        OpenGL_ES_Common_Version_1_0: QGLFormat.OpenGLVersionFlag = ... # 0x80
        OpenGL_ES_CommonLite_Version_1_0: QGLFormat.OpenGLVersionFlag = ... # 0x100
        OpenGL_ES_Common_Version_1_1: QGLFormat.OpenGLVersionFlag = ... # 0x200
        OpenGL_ES_CommonLite_Version_1_1: QGLFormat.OpenGLVersionFlag = ... # 0x400
        OpenGL_ES_Version_2_0    : QGLFormat.OpenGLVersionFlag = ... # 0x800
        OpenGL_Version_3_0       : QGLFormat.OpenGLVersionFlag = ... # 0x1000
        OpenGL_Version_3_1       : QGLFormat.OpenGLVersionFlag = ... # 0x2000
        OpenGL_Version_3_2       : QGLFormat.OpenGLVersionFlag = ... # 0x4000
        OpenGL_Version_3_3       : QGLFormat.OpenGLVersionFlag = ... # 0x8000
        OpenGL_Version_4_0       : QGLFormat.OpenGLVersionFlag = ... # 0x10000
        OpenGL_Version_4_1       : QGLFormat.OpenGLVersionFlag = ... # 0x20000
        OpenGL_Version_4_2       : QGLFormat.OpenGLVersionFlag = ... # 0x40000
        OpenGL_Version_4_3       : QGLFormat.OpenGLVersionFlag = ... # 0x80000

    class OpenGLVersionFlags(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, options:PySide2.QtOpenGL.QGL.FormatOptions, plane:int=...) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtOpenGL.QGLFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def accum(self) -> bool: ...
    def accumBufferSize(self) -> int: ...
    def alpha(self) -> bool: ...
    def alphaBufferSize(self) -> int: ...
    def blueBufferSize(self) -> int: ...
    @staticmethod
    def defaultFormat() -> PySide2.QtOpenGL.QGLFormat: ...
    @staticmethod
    def defaultOverlayFormat() -> PySide2.QtOpenGL.QGLFormat: ...
    def depth(self) -> bool: ...
    def depthBufferSize(self) -> int: ...
    def directRendering(self) -> bool: ...
    def doubleBuffer(self) -> bool: ...
    @staticmethod
    def fromSurfaceFormat(format:PySide2.QtGui.QSurfaceFormat) -> PySide2.QtOpenGL.QGLFormat: ...
    def greenBufferSize(self) -> int: ...
    @staticmethod
    def hasOpenGL() -> bool: ...
    @staticmethod
    def hasOpenGLOverlays() -> bool: ...
    def hasOverlay(self) -> bool: ...
    def majorVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    @staticmethod
    def openGLVersionFlags() -> PySide2.QtOpenGL.QGLFormat.OpenGLVersionFlags: ...
    def plane(self) -> int: ...
    def profile(self) -> PySide2.QtOpenGL.QGLFormat.OpenGLContextProfile: ...
    def redBufferSize(self) -> int: ...
    def rgba(self) -> bool: ...
    def sampleBuffers(self) -> bool: ...
    def samples(self) -> int: ...
    def setAccum(self, enable:bool) -> None: ...
    def setAccumBufferSize(self, size:int) -> None: ...
    def setAlpha(self, enable:bool) -> None: ...
    def setAlphaBufferSize(self, size:int) -> None: ...
    def setBlueBufferSize(self, size:int) -> None: ...
    @staticmethod
    def setDefaultFormat(f:PySide2.QtOpenGL.QGLFormat) -> None: ...
    @staticmethod
    def setDefaultOverlayFormat(f:PySide2.QtOpenGL.QGLFormat) -> None: ...
    def setDepth(self, enable:bool) -> None: ...
    def setDepthBufferSize(self, size:int) -> None: ...
    def setDirectRendering(self, enable:bool) -> None: ...
    def setDoubleBuffer(self, enable:bool) -> None: ...
    def setGreenBufferSize(self, size:int) -> None: ...
    def setOption(self, opt:PySide2.QtOpenGL.QGL.FormatOptions) -> None: ...
    def setOverlay(self, enable:bool) -> None: ...
    def setPlane(self, plane:int) -> None: ...
    def setProfile(self, profile:PySide2.QtOpenGL.QGLFormat.OpenGLContextProfile) -> None: ...
    def setRedBufferSize(self, size:int) -> None: ...
    def setRgba(self, enable:bool) -> None: ...
    def setSampleBuffers(self, enable:bool) -> None: ...
    def setSamples(self, numSamples:int) -> None: ...
    def setStencil(self, enable:bool) -> None: ...
    def setStencilBufferSize(self, size:int) -> None: ...
    def setStereo(self, enable:bool) -> None: ...
    def setSwapInterval(self, interval:int) -> None: ...
    def setVersion(self, major:int, minor:int) -> None: ...
    def stencil(self) -> bool: ...
    def stencilBufferSize(self) -> int: ...
    def stereo(self) -> bool: ...
    def swapInterval(self) -> int: ...
    def testOption(self, opt:PySide2.QtOpenGL.QGL.FormatOptions) -> bool: ...
    @staticmethod
    def toSurfaceFormat(format:PySide2.QtOpenGL.QGLFormat) -> PySide2.QtGui.QSurfaceFormat: ...


class QGLFramebufferObject(PySide2.QtGui.QPaintDevice):
    NoAttachment             : QGLFramebufferObject = ... # 0x0
    CombinedDepthStencil     : QGLFramebufferObject = ... # 0x1
    Depth                    : QGLFramebufferObject = ... # 0x2

    class Attachment(object):
        NoAttachment             : QGLFramebufferObject.Attachment = ... # 0x0
        CombinedDepthStencil     : QGLFramebufferObject.Attachment = ... # 0x1
        Depth                    : QGLFramebufferObject.Attachment = ... # 0x2

    @typing.overload
    def __init__(self, size:PySide2.QtCore.QSize, attachment:PySide2.QtOpenGL.QGLFramebufferObject.Attachment, target:int=..., internal_format:int=...) -> None: ...
    @typing.overload
    def __init__(self, size:PySide2.QtCore.QSize, format:PySide2.QtOpenGL.QGLFramebufferObjectFormat) -> None: ...
    @typing.overload
    def __init__(self, size:PySide2.QtCore.QSize, target:int=...) -> None: ...
    @typing.overload
    def __init__(self, width:int, height:int, attachment:PySide2.QtOpenGL.QGLFramebufferObject.Attachment, target:int=..., internal_format:int=...) -> None: ...
    @typing.overload
    def __init__(self, width:int, height:int, format:PySide2.QtOpenGL.QGLFramebufferObjectFormat) -> None: ...
    @typing.overload
    def __init__(self, width:int, height:int, target:int=...) -> None: ...

    def attachment(self) -> PySide2.QtOpenGL.QGLFramebufferObject.Attachment: ...
    def bind(self) -> bool: ...
    @staticmethod
    def bindDefault() -> bool: ...
    @staticmethod
    def blitFramebuffer(target:PySide2.QtOpenGL.QGLFramebufferObject, targetRect:PySide2.QtCore.QRect, source:PySide2.QtOpenGL.QGLFramebufferObject, sourceRect:PySide2.QtCore.QRect, buffers:int=..., filter:int=...) -> None: ...
    def devType(self) -> int: ...
    @typing.overload
    def drawTexture(self, point:PySide2.QtCore.QPointF, textureId:int, textureTarget:int=...) -> None: ...
    @typing.overload
    def drawTexture(self, target:PySide2.QtCore.QRectF, textureId:int, textureTarget:int=...) -> None: ...
    def format(self) -> PySide2.QtOpenGL.QGLFramebufferObjectFormat: ...
    def handle(self) -> int: ...
    @staticmethod
    def hasOpenGLFramebufferBlit() -> bool: ...
    @staticmethod
    def hasOpenGLFramebufferObjects() -> bool: ...
    def isBound(self) -> bool: ...
    def isValid(self) -> bool: ...
    def metric(self, metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def release(self) -> bool: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def texture(self) -> int: ...
    def toImage(self) -> PySide2.QtGui.QImage: ...


class QGLFramebufferObjectFormat(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtOpenGL.QGLFramebufferObjectFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def attachment(self) -> PySide2.QtOpenGL.QGLFramebufferObject.Attachment: ...
    def internalTextureFormat(self) -> int: ...
    def mipmap(self) -> bool: ...
    def samples(self) -> int: ...
    def setAttachment(self, attachment:PySide2.QtOpenGL.QGLFramebufferObject.Attachment) -> None: ...
    def setInternalTextureFormat(self, internalTextureFormat:int) -> None: ...
    def setMipmap(self, enabled:bool) -> None: ...
    def setSamples(self, samples:int) -> None: ...
    def setTextureTarget(self, target:int) -> None: ...
    def textureTarget(self) -> int: ...


class QGLPixelBuffer(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self, size:PySide2.QtCore.QSize, format:PySide2.QtOpenGL.QGLFormat=..., shareWidget:typing.Optional[PySide2.QtOpenGL.QGLWidget]=...) -> None: ...
    @typing.overload
    def __init__(self, width:int, height:int, format:PySide2.QtOpenGL.QGLFormat=..., shareWidget:typing.Optional[PySide2.QtOpenGL.QGLWidget]=...) -> None: ...

    @typing.overload
    def bindTexture(self, fileName:str) -> int: ...
    @typing.overload
    def bindTexture(self, image:PySide2.QtGui.QImage, target:int=...) -> int: ...
    @typing.overload
    def bindTexture(self, pixmap:PySide2.QtGui.QPixmap, target:int=...) -> int: ...
    def bindToDynamicTexture(self, texture:int) -> bool: ...
    def context(self) -> PySide2.QtOpenGL.QGLContext: ...
    def deleteTexture(self, texture_id:int) -> None: ...
    def devType(self) -> int: ...
    def doneCurrent(self) -> bool: ...
    @typing.overload
    def drawTexture(self, point:PySide2.QtCore.QPointF, textureId:int, textureTarget:int=...) -> None: ...
    @typing.overload
    def drawTexture(self, target:PySide2.QtCore.QRectF, textureId:int, textureTarget:int=...) -> None: ...
    def format(self) -> PySide2.QtOpenGL.QGLFormat: ...
    def generateDynamicTexture(self) -> int: ...
    def handle(self) -> int: ...
    @staticmethod
    def hasOpenGLPbuffers() -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> bool: ...
    def metric(self, metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def releaseFromDynamicTexture(self) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def toImage(self) -> PySide2.QtGui.QImage: ...
    def updateDynamicTexture(self, texture_id:int) -> None: ...


class QGLShader(PySide2.QtCore.QObject):
    Vertex                   : QGLShader = ... # 0x1
    Fragment                 : QGLShader = ... # 0x2
    Geometry                 : QGLShader = ... # 0x4

    class ShaderType(object): ...

    class ShaderTypeBit(object):
        Vertex                   : QGLShader.ShaderTypeBit = ... # 0x1
        Fragment                 : QGLShader.ShaderTypeBit = ... # 0x2
        Geometry                 : QGLShader.ShaderTypeBit = ... # 0x4

    @typing.overload
    def __init__(self, type:PySide2.QtOpenGL.QGLShader.ShaderType, context:PySide2.QtOpenGL.QGLContext, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtOpenGL.QGLShader.ShaderType, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    @typing.overload
    def compileSourceCode(self, source:PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def compileSourceCode(self, source:str) -> bool: ...
    @typing.overload
    def compileSourceCode(self, source:bytes) -> bool: ...
    def compileSourceFile(self, fileName:str) -> bool: ...
    @staticmethod
    def hasOpenGLShaders(type:PySide2.QtOpenGL.QGLShader.ShaderType, context:typing.Optional[PySide2.QtOpenGL.QGLContext]=...) -> bool: ...
    def isCompiled(self) -> bool: ...
    def log(self) -> str: ...
    def shaderId(self) -> int: ...
    def shaderType(self) -> PySide2.QtOpenGL.QGLShader.ShaderType: ...
    def sourceCode(self) -> PySide2.QtCore.QByteArray: ...


class QGLShaderProgram(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, context:PySide2.QtOpenGL.QGLContext, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def addShader(self, shader:PySide2.QtOpenGL.QGLShader) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type:PySide2.QtOpenGL.QGLShader.ShaderType, source:PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type:PySide2.QtOpenGL.QGLShader.ShaderType, source:str) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type:PySide2.QtOpenGL.QGLShader.ShaderType, source:bytes) -> bool: ...
    def addShaderFromSourceFile(self, type:PySide2.QtOpenGL.QGLShader.ShaderType, fileName:str) -> bool: ...
    @typing.overload
    def attributeLocation(self, name:PySide2.QtCore.QByteArray) -> int: ...
    @typing.overload
    def attributeLocation(self, name:str) -> int: ...
    @typing.overload
    def attributeLocation(self, name:bytes) -> int: ...
    def bind(self) -> bool: ...
    @typing.overload
    def bindAttributeLocation(self, name:PySide2.QtCore.QByteArray, location:int) -> None: ...
    @typing.overload
    def bindAttributeLocation(self, name:str, location:int) -> None: ...
    @typing.overload
    def bindAttributeLocation(self, name:bytes, location:int) -> None: ...
    @typing.overload
    def disableAttributeArray(self, location:int) -> None: ...
    @typing.overload
    def disableAttributeArray(self, name:bytes) -> None: ...
    @typing.overload
    def enableAttributeArray(self, location:int) -> None: ...
    @typing.overload
    def enableAttributeArray(self, name:bytes) -> None: ...
    def geometryInputType(self) -> int: ...
    def geometryOutputType(self) -> int: ...
    def geometryOutputVertexCount(self) -> int: ...
    @staticmethod
    def hasOpenGLShaderPrograms(context:typing.Optional[PySide2.QtOpenGL.QGLContext]=...) -> bool: ...
    def isLinked(self) -> bool: ...
    def link(self) -> bool: ...
    def log(self) -> str: ...
    def maxGeometryOutputVertices(self) -> int: ...
    def programId(self) -> int: ...
    def release(self) -> None: ...
    def removeAllShaders(self) -> None: ...
    def removeShader(self, shader:PySide2.QtOpenGL.QGLShader) -> None: ...
    @typing.overload
    def setAttributeArray2D(self, location:int, values:PySide2.QtGui.QVector2D, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeArray2D(self, name:bytes, values:PySide2.QtGui.QVector2D, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeArray3D(self, location:int, values:PySide2.QtGui.QVector3D, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeArray3D(self, name:bytes, values:PySide2.QtGui.QVector3D, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeArray4D(self, location:int, values:PySide2.QtGui.QVector4D, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeArray4D(self, name:bytes, values:PySide2.QtGui.QVector4D, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeBuffer(self, location:int, type:int, offset:int, tupleSize:int, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeBuffer(self, name:bytes, type:int, offset:int, tupleSize:int, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, x:float, y:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, x:float, y:float, z:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, x:float, y:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, x:float, y:float, z:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, x:float, y:float, z:float, w:float) -> None: ...
    def setGeometryInputType(self, inputType:int) -> None: ...
    def setGeometryOutputType(self, outputType:int) -> None: ...
    def setGeometryOutputVertexCount(self, count:int) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, point:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, point:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, size:PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, size:PySide2.QtCore.QSizeF) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:float) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:int) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:int) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix2x2) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix2x3) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix2x4) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix3x2) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix3x3) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix3x4) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix4x2) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix4x3) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QTransform) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, x:float, y:float) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, x:float, y:float, z:float) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, point:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, point:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, size:PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, size:PySide2.QtCore.QSizeF) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:float) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:int) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:int) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix2x2) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix2x3) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix2x4) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix3x2) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix3x3) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix3x4) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix4x2) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix4x3) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QTransform) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, x:float, y:float) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, x:float, y:float, z:float) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, x:float, y:float, z:float, w:float) -> None: ...
    @typing.overload
    def setUniformValueArray2D(self, location:int, values:PySide2.QtGui.QVector2D, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray2D(self, name:bytes, values:PySide2.QtGui.QVector2D, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray2x2(self, location:int, values:PySide2.QtGui.QMatrix2x2, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray2x2(self, name:bytes, values:PySide2.QtGui.QMatrix2x2, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray2x3(self, location:int, values:PySide2.QtGui.QMatrix2x3, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray2x3(self, name:bytes, values:PySide2.QtGui.QMatrix2x3, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray2x4(self, location:int, values:PySide2.QtGui.QMatrix2x4, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray2x4(self, name:bytes, values:PySide2.QtGui.QMatrix2x4, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray3D(self, location:int, values:PySide2.QtGui.QVector3D, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray3D(self, name:bytes, values:PySide2.QtGui.QVector3D, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray3x2(self, location:int, values:PySide2.QtGui.QMatrix3x2, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray3x2(self, name:bytes, values:PySide2.QtGui.QMatrix3x2, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray3x3(self, location:int, values:PySide2.QtGui.QMatrix3x3, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray3x3(self, name:bytes, values:PySide2.QtGui.QMatrix3x3, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray3x4(self, location:int, values:PySide2.QtGui.QMatrix3x4, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray3x4(self, name:bytes, values:PySide2.QtGui.QMatrix3x4, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray4D(self, location:int, values:PySide2.QtGui.QVector4D, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray4D(self, name:bytes, values:PySide2.QtGui.QVector4D, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray4x2(self, location:int, values:PySide2.QtGui.QMatrix4x2, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray4x2(self, name:bytes, values:PySide2.QtGui.QMatrix4x2, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray4x3(self, location:int, values:PySide2.QtGui.QMatrix4x3, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray4x3(self, name:bytes, values:PySide2.QtGui.QMatrix4x3, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray4x4(self, location:int, values:PySide2.QtGui.QMatrix4x4, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray4x4(self, name:bytes, values:PySide2.QtGui.QMatrix4x4, count:int) -> None: ...
    @typing.overload
    def setUniformValueArrayInt(self, location:int, values:typing.Sequence, count:int) -> None: ...
    @typing.overload
    def setUniformValueArrayInt(self, name:bytes, values:typing.Sequence, count:int) -> None: ...
    @typing.overload
    def setUniformValueArrayUint(self, location:int, values:typing.Sequence, count:int) -> None: ...
    @typing.overload
    def setUniformValueArrayUint(self, name:bytes, values:typing.Sequence, count:int) -> None: ...
    def shaders(self) -> typing.List: ...
    @typing.overload
    def uniformLocation(self, name:PySide2.QtCore.QByteArray) -> int: ...
    @typing.overload
    def uniformLocation(self, name:str) -> int: ...
    @typing.overload
    def uniformLocation(self, name:bytes) -> int: ...


class QGLWidget(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, context:PySide2.QtOpenGL.QGLContext, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., shareWidget:typing.Optional[PySide2.QtOpenGL.QGLWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...) -> None: ...
    @typing.overload
    def __init__(self, format:PySide2.QtOpenGL.QGLFormat, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., shareWidget:typing.Optional[PySide2.QtOpenGL.QGLWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., shareWidget:typing.Optional[PySide2.QtOpenGL.QGLWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...) -> None: ...

    def autoBufferSwap(self) -> bool: ...
    @typing.overload
    def bindTexture(self, fileName:str) -> int: ...
    @typing.overload
    def bindTexture(self, image:PySide2.QtGui.QImage, target:int, format:int, options:PySide2.QtOpenGL.QGLContext.BindOptions) -> int: ...
    @typing.overload
    def bindTexture(self, image:PySide2.QtGui.QImage, target:int=..., format:int=...) -> int: ...
    @typing.overload
    def bindTexture(self, pixmap:PySide2.QtGui.QPixmap, target:int, format:int, options:PySide2.QtOpenGL.QGLContext.BindOptions) -> int: ...
    @typing.overload
    def bindTexture(self, pixmap:PySide2.QtGui.QPixmap, target:int=..., format:int=...) -> int: ...
    def colormap(self) -> PySide2.QtOpenGL.QGLColormap: ...
    def context(self) -> PySide2.QtOpenGL.QGLContext: ...
    @staticmethod
    def convertToGLFormat(img:PySide2.QtGui.QImage) -> PySide2.QtGui.QImage: ...
    def deleteTexture(self, tx_id:int) -> None: ...
    def doneCurrent(self) -> None: ...
    def doubleBuffer(self) -> bool: ...
    @typing.overload
    def drawTexture(self, point:PySide2.QtCore.QPointF, textureId:int, textureTarget:int=...) -> None: ...
    @typing.overload
    def drawTexture(self, target:PySide2.QtCore.QRectF, textureId:int, textureTarget:int=...) -> None: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> PySide2.QtOpenGL.QGLFormat: ...
    def glDraw(self) -> None: ...
    def glInit(self) -> None: ...
    def grabFrameBuffer(self, withAlpha:bool=...) -> PySide2.QtGui.QImage: ...
    def initializeGL(self) -> None: ...
    def initializeOverlayGL(self) -> None: ...
    def isSharing(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> None: ...
    def makeOverlayCurrent(self) -> None: ...
    def overlayContext(self) -> PySide2.QtOpenGL.QGLContext: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent) -> None: ...
    def paintGL(self) -> None: ...
    def paintOverlayGL(self) -> None: ...
    def qglClearColor(self, c:PySide2.QtGui.QColor) -> None: ...
    def qglColor(self, c:PySide2.QtGui.QColor) -> None: ...
    def renderPixmap(self, w:int=..., h:int=..., useContext:bool=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def renderText(self, x:float, y:float, z:float, str:str, fnt:PySide2.QtGui.QFont=...) -> None: ...
    @typing.overload
    def renderText(self, x:int, y:int, str:str, fnt:PySide2.QtGui.QFont=...) -> None: ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeGL(self, w:int, h:int) -> None: ...
    def resizeOverlayGL(self, w:int, h:int) -> None: ...
    def setAutoBufferSwap(self, on:bool) -> None: ...
    def setColormap(self, map:PySide2.QtOpenGL.QGLColormap) -> None: ...
    def swapBuffers(self) -> None: ...
    def updateGL(self) -> None: ...
    def updateOverlayGL(self) -> None: ...

# eof
