"""Add Job.execution_id

Revision ID: d4af139b6f53
Revises: 71ec303c90e4
Create Date: 2021-08-01 05:30:58.615654

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "d4af139b6f53"
down_revision = "71ec303c90e4"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("job", schema=None) as batch_op:
        batch_op.add_column(sa.Column("execution_id", sa.String(), nullable=True))
        batch_op.create_index(batch_op.f("ix_job_execution_id"), ["execution_id"], unique=False)
        batch_op.create_foreign_key(
            "ct_job_execution_id",
            "execution",
            ["execution_id"],
            ["id"],
            deferrable=True,
            initially="DEFERRED",
        )

    if op.get_bind().dialect.name == "postgresql":
        op.execute(
            """
            alter table execution
            alter constraint execution_job_id_fkey deferrable initially deferred;
            """
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("job", schema=None) as batch_op:
        batch_op.drop_constraint("ct_job_execution_id", type_="foreignkey")
        batch_op.drop_index(batch_op.f("ix_job_execution_id"))
        batch_op.drop_column("execution_id")

    # ### end Alembic commands ###
