# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['talked']

package_data = \
{'': ['*'], 'talked': ['static/*']}

install_requires = \
['Flask>=2.0.1,<3.0.0',
 'PyVirtualDisplay>=2.2,<3.0',
 'selenium>=3.141.0,<4.0.0',
 'uWSGI>=2.0.19,<3.0.0']

setup_kwargs = {
    'name': 'talked',
    'version': '0.1.4',
    'description': 'Call recording for Nextcloud Talk',
    'long_description': '# Talked\n\nCall recording for Nextcloud Talk\n\n## How it works\n\nTalked works by launching a Firefox instance in a virtual framebuffer, joining the Talk call, and then recording whatever is on screen using FFmpeg. The call is in fullscreen and using the speaker view. During your call, the recording user will be visible while the recording is active. Some custom CSS is added to the page so, when recording in speaker view, the recording user is completely hidden from the recording itself.\n\n## Hardware requirements\n\nThe default configuration has been designed to run on a 2 core / 2\xa0GB ram VPS. If you have beefier hardware and would like better recording quality, then you can play around with the settings to increase the resolution, crf and encoding preset.\n\n## Current limitations\n\nThese are the current limitations of Talked. They will be worked on for future releases.\n\n* Only one recording can be active at a time.\n* The HTTP API is design to be single threaded and only handle one request at a time.\n* Recording only works with rooms that are public (Allows guest access through a link).\n* The recording is set up to use speaker view, but if the recorder is started while a screen share is active and then the screen share is ended the recording will use grid view from that point on. This mainly means the recording user will be visible in the recording. The recording user is completely hidden from the recording when using speaker view.\n\n## Installation\n\nThese instructions are made for Ubuntu 20.04, but they should hopefully be fairly easy to use for other distros, if you\'re familiar with them. These instructions are mainly intended to help you get started and should be adapted to your needs.\n\nFirst let\'s install the required dependencies\n```\nsudo apt install build-essential python3 python3-dev python3-venv python3-wheel firefox-geckodriver pulseaudio xvfb ffmpeg\n```\n\nThen let\'s create an unprivileged user to run Talked with.\n```\nsudo useradd --system --shell /bin/bash --home-dir /opt/talked --create-home talked\n```\n\nThen change to the newly created user with `sudo su talked` as it will be easier to set up the virtual env. To set up the virtual env run the following\n```\npython3 -m venv /opt/talked/talked\n```\nThen activate it\n```\nsource /opt/talked/talked/bin/activate\n```\nAnd install wheel and talked\n```\npip3 install wheel talked\n```\n\nNow let\'s create the config file at `/opt/talked/config.json`. The only required parameter is `base_url` but it might be useful to change some of the other options as well. You can see a list of the available options further down. The most basic config would look like this:\n```\n{\n    "base_url": "talked.example.com"\n}\n```\n\nTalked uses the environment variable `TALKED_CONFIG_PATH` to find the config file. The easiest way to set it is to put it in the systemd service file used to start the talked server.\n\nFurther down you can find an example systemd unit file that can be used to start and stop the Talked server. You can use the following command to test the Talked server. Please note the command binds to localhost, you can change it to whatever you need.\n```\nuwsgi --http 127.0.0.1:5000 --master --manage-script-name --mount /=talked.main:app\n```\n\nIt\'s recommended to set up Nginx or Apache in front of uwsgi to handle TLS and HTTP Basic auth. Currently, there isn\'t any authentication system built into the Talked server, so it\'s recommend to set up HTTP Basic auth. It\'s also recommended to only allow requests from your Nextcloud server to the Talked server, this can either be configured in your firewall or web server config.\n\nYou can have a look at the following instructions for nginx: https://docs.nginx.com/nginx/admin-guide/security-controls/configuring-http-basic-authentication/\n\n## Configuration options\n\n| option                  | default    | description                                                                                         |\n| ----------------------- | ---------- | --------------------------------------------------------------------------------------------------- |\n| base_url                | ""         | The base URL of your Nextcloud instance. Should include the http / https and have no leading slash. |\n| log_level               | "warning"  | The log level that should be used.                                                                  |\n| recording_dir           | "."        | The directory where the recordings should be stored.                                                |\n| video_width             | 1280       | The virtual display and recording width in pixels.                                                  |\n| video_height            | 720        | The virtual display and recording height in pixels.                                                 |\n| color_depth             | 24         | The color depth to use for the virtual framebuffer.                                                 |\n| framerate               | 30         | The framerate that should be used for the recording.                                                |\n| audio_codec             | "aac"      | The audio codec to use for the recording.                                                           |\n| audio_bitrate           | "160k"     | The audio bitrate to use.                                                                           |\n| audio_thread_queue_size | 128        |                                                                                                     |\n| video_codec             | "libx264"  | The video codec to use for the recording.                                                           |\n| crf                     | 25         | The crf to use for the H.264 encoding.                                                              |\n| video_thread_queue_size | 32         |                                                                                                     |\n| encoding_preset         | "veryfast" | The encoding preset used for the H.264 encoding.                                                    |\n| encoding_threads        | 0          | How many threads to use for the encoding. 0 is auto.                                                |\n\n## Development setup\n\nMake sure you have docker installed for your OS. Then build the generic docker container using this command\n```\ndocker build docker -f docker/Dockerfile.dev -t talked\n```\n\nThen start the container using this command, it will take over the current terminal you have open. The command will start the docker container giving you a bash shell and a user with the same ID as your user on the host. The root of this project will also be passed through to the container in the /home/talked/talked folder. The container will get removed when you exit out of it, so you don\'t manually have to do it.\n```\ndocker run --rm -it -v "$(pwd):/home/talked/talked" -e "UID=$(id -u)" -e "GID=$(id -g)" -p "5000:5000" talked\n```\n\nWhen you enter the container you will be placed in the /home/talked/talked folder, to get started first install the python dependencies using poetry.\n```\npoetry install\n```\n\nThen create a config file called `config.json` in the root of the project which contains the base URL for your Nextcloud instance. Below you can see the boilerplate:\n```\n{\n  "base_url": "https://nextcloud.example.com"\n}\n```\nThe config file location is controlled by the `TALKED_CONFIG_PATH` env var and by default, in the container, it is set to the root of the project folder.\n\nNow you can run the program either using:\n```\npoetry run python3 -m talked\n```\nOr by entering the virtualenv and then running the program:\n```\npoetry shell\n\npython3 -m talked\n```\n\nLastly remember to join the call before starting the program, as it will only join if there is a call in progress.\n\n## Example systemd service\n\n```\n[Unit]\nDescription=talked\nRequires=network.target\nAfter=network.target\n\n[Service]\nWorkingDirectory=/opt/talked\nUser=talked\nGroup=talked\n\nEnvironment=TALKED_CONFIG_PATH=/opt/talked/config.json\n\nProtectSystem=full\nProtectHome=true\nProtectKernelTunables=true\nProtectKernelModules=true\nProtectControlGroups=true\nPrivateTmp=yes\nNoNewPrivileges=yes\n\nSyslogIdentifier=talked\nStandardOutput=syslog\nStandardError=syslog\n\nExecStart=/opt/talked/talked/bin/uwsgi --http 127.0.0.1:5000 --die-on-term --master --manage-script-name --mount /=talked.main:app\nRestart=always\n\n[Install]\nWantedBy=multi-user.target\n```\n\n## License\n\nThis program is licensed under the AGPLv3 or later.\n',
    'author': 'Magnus Walbeck',
    'author_email': 'mw@mwalbeck.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/MetaProvide/talked',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
