import * as codepipeline from '@aws-cdk/aws-codepipeline';
import * as lambda from '@aws-cdk/aws-lambda';
import { Construct } from '@aws-cdk/core';
import { Action } from '../action';
/**
 * Construction properties of the {@link LambdaInvokeAction Lambda invoke CodePipeline Action}.
 */
export interface LambdaInvokeActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * The optional input Artifacts of the Action.
     * A Lambda Action can have up to 5 inputs.
     * The inputs will appear in the event passed to the Lambda,
     * under the `'CodePipeline.job'.data.inputArtifacts` path.
     *
     * @default the Action will not have any inputs
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
     */
    readonly inputs?: codepipeline.Artifact[];
    /**
     * The optional names of the output Artifacts of the Action.
     * A Lambda Action can have up to 5 outputs.
     * The outputs will appear in the event passed to the Lambda,
     * under the `'CodePipeline.job'.data.outputArtifacts` path.
     * It is the responsibility of the Lambda to upload ZIP files with the Artifact contents to the provided locations.
     *
     * @default the Action will not have any outputs
     */
    readonly outputs?: codepipeline.Artifact[];
    /**
     * A set of key-value pairs that will be accessible to the invoked Lambda
     * inside the event that the Pipeline will call it with.
     *
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
     */
    readonly userParameters?: {
        [key: string]: any;
    };
    /**
     * The lambda function to invoke.
     */
    readonly lambda: lambda.IFunction;
}
/**
 * CodePipeline invoke Action that is provided by an AWS Lambda function.
 *
 * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html
 */
export declare class LambdaInvokeAction extends Action {
    private readonly props;
    constructor(props: LambdaInvokeActionProps);
    /**
     * Reference a CodePipeline variable defined by the Lambda function this action points to.
     * Variables in Lambda invoke actions are defined by calling the PutJobSuccessResult CodePipeline API call
     * with the 'outputVariables' property filled.
     *
     * @param variableName the name of the variable to reference.
     *   A variable by this name must be present in the 'outputVariables' section of the PutJobSuccessResult
     *   request that the Lambda function calls when the action is invoked
     *
     * @see https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_PutJobSuccessResult.html
     */
    variable(variableName: string): string;
    protected bound(scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
