#! /usr/bin/python3.5
# -*- coding: utf-8 -*-

"""
Mini-array measurements from (https://confluence2.obs-nancay.fr/pages/viewpage.action?pageId=3997697&preview=/3997697/11600353/Coordonnees_MR00-MR51_20180613_LD.xls)
        by A. Loh
"""

import numpy as np

__author__ = 'Alan Loh'
__copyright__ = 'Copyright 2018, nenupy'
__credits__ = ['Alan Loh']
__license__ = 'MIT'
__version__ = '0.0.1'
__maintainer__ = 'Alan Loh'
__email__ = 'alan.loh@obspm.fr'
__status__ = 'WIP'
__all__ = ['antpos', 'ma']


antpos = np.array([
    -5.50000000e+00, -9.52627850e+00,  0.00000000e+00,
     0.00000000e+00, -9.52627850e+00,  0.00000000e+00,
     5.50000000e+00, -9.52627850e+00,  0.00000000e+00,
    -8.25000000e+00, -4.76313877e+00,  0.00000000e+00,
    -2.75000000e+00, -4.76313877e+00,  0.00000000e+00,
     2.75000000e+00, -4.76313877e+00,  0.00000000e+00,
     8.25000000e+00, -4.76313877e+00,  0.00000000e+00,
    -1.10000000e+01,  9.53674316e-07,  0.00000000e+00,
    -5.50000000e+00,  9.53674316e-07,  0.00000000e+00,
     0.00000000e+00,  9.53674316e-07,  0.00000000e+00,
     5.50000000e+00,  9.53674316e-07,  0.00000000e+00,
     1.10000000e+01,  9.53674316e-07,  0.00000000e+00,
    -8.25000000e+00,  4.76314068e+00,  0.00000000e+00,
    -2.75000000e+00,  4.76314068e+00,  0.00000000e+00,
     2.75000000e+00,  4.76314068e+00,  0.00000000e+00,
     8.25000000e+00,  4.76314068e+00,  0.00000000e+00,
    -5.50000000e+00,  9.52628040e+00,  0.00000000e+00,
     0.00000000e+00,  9.52628040e+00,  0.00000000e+00,
     5.50000000e+00,  9.52628040e+00,  0.00000000e+00
    ]).reshape(19, 3)


# noMA, rot, pos_x (L93 measured), pos_y, pos_z, delay (ns), att (dB) 
ma = np.array([
    [0 , 0  , 639113.316, 6697663.473, 181.735, 440.5 , 29.5],
    [1 , 30 , 639094.578, 6697644.715, 181.750, 364   , 30  ],
    [2 , 300, 639069.472, 6697634.429, 181.761, 150   , 31  ],
    [3 , 200, 639038.120, 6697619.754, 181.757, 145.5 , 31  ],
    [4 , 20 , 639020.122, 6697598.922, 181.762, 464.5 , 28.5],
    [5 , 180, 639062.298, 6697659.113, 181.671, 384.5 , 30  ],
    [6 , 180, 639039.218, 6697646.381, 181.718, 276.5 , 31  ],
    [7 , 230, 638985.155, 6697627.952, 181.620, 471   , 28.5],
    [8 , 150, 639002.711, 6697647.883, 181.677, 411.5 , 29.5],
    [9 , 240, 639006.567, 6697674.708, 181.737, 428.5 , 29.5],
    [10, 290, 639033.717, 6697697.363, 181.762, 496   , 28.5],
    [11, 310, 639040.955, 6697728.209, 181.813, 663   , 27.5],
    [12, 250, 639061.482, 6697709.858, 181.727, 659.5 , 25  ],
    [13, 40 , 639081.586, 6697747.997, 181.997, 958   , 24.5],
    [14, 330, 639099.636, 6697780.199, 182.152, 1032  , 24.5],
    [15, 280, 639098.493, 6697726.359, 181.912, 793   , 26.5],
    [16, 60 , 639128.375, 6697745.064, 182.005, 1054.5, 24  ],
    [17, 110, 639153.064, 6697760.961, 182.062, 1233  , 23  ],
    [18, 10 , 639201.475, 6697767.744, 182.083, 1355  , 22  ],
    [19, 210, 639146.673, 6697790.436, 182.199, 1249.5, 22.5],
    [20, 320, 639191.912, 6697807.839, 182.057, 1352.5, 21.5],
    [21, 260, 639158.373, 6697844.968, 182.201, 1461  , 21.5],
    [22, 250, 639007.359, 6697734.730, 181.967, 662   , 27.5],
    [23, 170, 638994.637, 6697780.061, 182.016, 969.5 , 25  ],
    [24, 180, 638974.900, 6697797.705, 182.057, 1082.5, 24.5],
    [25, 50 , 639039.664, 6697796.029, 182.092, 1052  , 23.5],
    [26, 300, 639051.439, 6697828.330, 182.133, 1112  , 23.5],
    [27, 210, 639037.314, 6697862.392, 182.535, 1387  , 21  ],
    [28, 320, 639106.516, 6697880.517, 182.416, 1527.5, 20.5],
    [29, 330, 639085.345, 6697826.937, 182.164, 1226  , 22  ],
    [30, 60 , 639124.407, 6697813.619, 182.277, 1530.5, 20.5],
    [31, 20 , 639118.439, 6697846.786, 182.334, 1462  , 21  ],
    [32, 290, 638980.493, 6697661.622, 181.773, 573   , 28  ],
    [33, 240, 638955.067, 6697653.896, 181.787, 616.5 , 27.5],
    [34, 230, 638917.110, 6697642.462, 181.723, 770.5 , 26  ],
    [35, 340, 638901.511, 6697665.620, 181.722, 1024  , 24.5],
    [36, 170, 638842.551, 6697684.224, 181.915, 1182.5, 23  ],
    [37, 350, 638881.893, 6697706.134, 181.971, 1231  , 23  ],
    [38, 260, 638828.310, 6697731.499, 182.165, 1365  , 21.5],
    [39, 160, 638798.998, 6697676.964, 182.180, 1472  , 21  ],
    [40, 220, 638828.026, 6697644.185, 182.034, 1115.5, 24  ],
    [41, 120, 638994.603, 6697699.384, 181.819, 661.5 , 26.5],
    [42, 140, 638973.994, 6697731.272, 181.940, 802.5 , 25.5],
    [43, 130, 638963.888, 6697756.816, 182.315, 932   , 24.5],
    [44, 110, 638907.143, 6697757.070, 182.406, 1187  , 23  ],
    [45, 150, 638934.310, 6697762.760, 182.306, 1030  , 23.5],
    [46, 300, 638947.300, 6697795.415, 182.257, 1096  , 23.5],
    [47, 190, 638957.218, 6697683.457, 181.905, 721.5 , 26.5],
    [48, 100, 638932.724, 6697691.062, 181.967, 898   , 26  ],
    [49, 340, 638924.357, 6697729.083, 182.312, 1029  , 23.5],
    [50, 160, 638865.831, 6697782.977, 182.415, 1339.5, 23  ],
    [51, 240, 638881.847, 6697760.090, 182.376, 1138.5, 23.5]
])