### Feature
* Add support for tags based on atlas terms ([#466](https://github.com/amundsen-io/amundsendatabuilder/issues/466)) ([`cc1caf3`](https://github.com/amundsen-io/amundsendatabuilder/commit/cc1caf37f87b140a393aedfd0a07fd17c58e8ac4))
* Make DescriptionMetadata inherit from GraphSerializable ([#461](https://github.com/amundsen-io/amundsendatabuilder/issues/461)) ([`7f095fb`](https://github.com/amundsen-io/amundsendatabuilder/commit/7f095fb368dc8b6fba5f65f3870c1dd2444b0413))
* Add TableSerializable and mysql_serializer ([#459](https://github.com/amundsen-io/amundsendatabuilder/issues/459)) ([`4bb4452`](https://github.com/amundsen-io/amundsendatabuilder/commit/4bb44528d6e17a4a2fed32bb449a21c35591ecbf))
* Neptune Data builder Integration ([#438](https://github.com/amundsen-io/amundsendatabuilder/issues/438)) ([`303e8aa`](https://github.com/amundsen-io/amundsendatabuilder/commit/303e8aa2a42779070f5d6260faac010ba86a216c))
* Add config key for connect_arg for SqlAlchemyExtractor ([#434](https://github.com/amundsen-io/amundsendatabuilder/issues/434)) ([`7f3be0f`](https://github.com/amundsen-io/amundsendatabuilder/commit/7f3be0fe58ec863679169e945441e01fcdc0e64c))
* Vertica metadata extractor ([#433](https://github.com/amundsen-io/amundsendatabuilder/issues/433)) ([`f4bd207`](https://github.com/amundsen-io/amundsendatabuilder/commit/f4bd2071cf9c31ae6ff9a51bb5983f5c18e4a0bf))
* Multi-yield transformers ([#396](https://github.com/amundsen-io/amundsendatabuilder/issues/396)) ([`49ae0ed`](https://github.com/amundsen-io/amundsendatabuilder/commit/49ae0ed253aabec38346d0f26479218dec62081f))
* Atlas_search_extractor | :tada: Initial commit. ([#415](https://github.com/amundsen-io/amundsendatabuilder/issues/415)) ([`8c63307`](https://github.com/amundsen-io/amundsendatabuilder/commit/8c633072da81b7fb2e343aa31e6e7f9c3bfae07d))
* Sample Feast job with ES publisher ([#425](https://github.com/amundsen-io/amundsendatabuilder/issues/425)) ([`453a18b`](https://github.com/amundsen-io/amundsendatabuilder/commit/453a18b9f70b94226bf01180d7e44b915ca2ddcf))
* Adding CsvTableBadgeExtractor ([#417](https://github.com/amundsen-io/amundsendatabuilder/issues/417)) ([`592ee71`](https://github.com/amundsen-io/amundsendatabuilder/commit/592ee7139070c6e86ab8c3050ab72465ec9ee688))
* Feast extractor ([#414](https://github.com/amundsen-io/amundsendatabuilder/issues/414)) ([`2343a90`](https://github.com/amundsen-io/amundsendatabuilder/commit/2343a90b09932a173cbef13ad912bd2e7864dea0))
* Adding first pass of delta lake metadata extractor as well as a sample script on how it would be used. ([#351](https://github.com/amundsen-io/amundsendatabuilder/issues/351)) ([`e8679aa`](https://github.com/amundsen-io/amundsendatabuilder/commit/e8679aadbcf940fb1b422b1d44298a314f2e5f12))
* Use parameters to allow special characters in neo4j cypher statement ([#382](https://github.com/amundsen-io/amundsendatabuilder/issues/382)) ([`6fd5035`](https://github.com/amundsen-io/amundsendatabuilder/commit/6fd503563d49157a4a2611ad66fca2680dc62c68))
* Column level badges cont. ([#381](https://github.com/amundsen-io/amundsendatabuilder/issues/381)) ([`af4b512`](https://github.com/amundsen-io/amundsendatabuilder/commit/af4b51265e11d1ee9e8651cebeb0d00592eec2d5))
* Support dashboard chart in search ([#383](https://github.com/amundsen-io/amundsendatabuilder/issues/383)) ([`6cced36`](https://github.com/amundsen-io/amundsendatabuilder/commit/6cced36bdccd7a007872928f4075f7528daa8449))
* Column level badges ([#375](https://github.com/amundsen-io/amundsendatabuilder/issues/375)) ([`8beee3e`](https://github.com/amundsen-io/amundsendatabuilder/commit/8beee3ea2ba0a81f4cc321791b9185a4316d9193))
* Added Dremio extractor ([#377](https://github.com/amundsen-io/amundsendatabuilder/issues/377)) ([`63f239f`](https://github.com/amundsen-io/amundsendatabuilder/commit/63f239fd793e6b362f1d9aa064862f23b4718c09))
* Add an extractor for pulling user information from BambooHR ([#369](https://github.com/amundsen-io/amundsendatabuilder/issues/369)) ([`6802ab1`](https://github.com/amundsen-io/amundsendatabuilder/commit/6802ab13d18d9a3f27d54dd7a7e43b4c3606da39))
* Add sample_glue_loader script ([#366](https://github.com/amundsen-io/amundsendatabuilder/issues/366)) ([`fa3f11b`](https://github.com/amundsen-io/amundsendatabuilder/commit/fa3f11b32560fe43d95bfcdab402832898858b44))
* Parameterize Snowflake Schema in Snowflake Metadata Extractor ([#361](https://github.com/amundsen-io/amundsendatabuilder/issues/361)) ([`aa4416c`](https://github.com/amundsen-io/amundsendatabuilder/commit/aa4416c51668e887817d197edd5a7365f83446d3))
* Mode Batch dashboard charrt API ([#362](https://github.com/amundsen-io/amundsendatabuilder/issues/362)) ([`87213c5`](https://github.com/amundsen-io/amundsendatabuilder/commit/87213c5ae45e1cbe116295eafa568a775d21a889))
* Create a RedshiftMetadataExtractor that supports late binding views ([#356](https://github.com/amundsen-io/amundsendatabuilder/issues/356)) ([`4113cfd`](https://github.com/amundsen-io/amundsendatabuilder/commit/4113cfd309ddf633b42ae511b0f0215bd3642621))
* Add MySQL sample data loader ([#359](https://github.com/amundsen-io/amundsendatabuilder/issues/359)) ([`871a176`](https://github.com/amundsen-io/amundsendatabuilder/commit/871a1763a7b0837bb6c0ba12810b9264aaa67d59))
* Add Snowflake table last updated timestamp extractor ([#348](https://github.com/amundsen-io/amundsendatabuilder/issues/348)) ([`0bac11b`](https://github.com/amundsen-io/amundsendatabuilder/commit/0bac11bcb7cd1de974548d7d3428d209fb65d4f4))
* Add Tableau dashboard metadata extractors ([#333](https://github.com/amundsen-io/amundsendatabuilder/issues/333)) ([`46207ee`](https://github.com/amundsen-io/amundsendatabuilder/commit/46207eee9bc50b7cb09e0effbff61edcb34e5d3b))
* Add github actions for databuilder ([#336](https://github.com/amundsen-io/amundsendatabuilder/issues/336)) ([`236e7de`](https://github.com/amundsen-io/amundsendatabuilder/commit/236e7dec1d6f059e0227bf92ed6df457b448ee56))
* Allow hive sql to be provided as config ([#312](https://github.com/amundsen-io/amundsendatabuilder/issues/312)) ([`8075a6c`](https://github.com/amundsen-io/amundsendatabuilder/commit/8075a6c7604c0f9c3491cdd85c0e1e97a7fd5b99))
* Enhance glue extractor ([#306](https://github.com/amundsen-io/amundsendatabuilder/issues/306)) ([`faa795c`](https://github.com/amundsen-io/amundsendatabuilder/commit/faa795ce335e12323fb69b1041435df38034b158))
* Add RedashDashboardExtractor for extracting dashboards from redash.io ([#300](https://github.com/amundsen-io/amundsendatabuilder/issues/300)) ([`f1b0dfa`](https://github.com/amundsen-io/amundsendatabuilder/commit/f1b0dfa399295124484242a666ddf2f20791aff7))
* Add a transformer that adds tags to all tables created in a job ([#287](https://github.com/amundsen-io/amundsendatabuilder/issues/287)) ([`d2f4bd3`](https://github.com/amundsen-io/amundsendatabuilder/commit/d2f4bd308c1ef92ea2bbfb7a7443cb42113f03f9))

### Fix
* Add support for Tableau multi-site deployment ([#463](https://github.com/amundsen-io/amundsendatabuilder/issues/463)) ([`e35af58`](https://github.com/amundsen-io/amundsendatabuilder/commit/e35af5808a40512aac09735711c3ab75c578d018))
* Avoid error by checking for existence before close. ([#454](https://github.com/amundsen-io/amundsendatabuilder/issues/454)) ([`5cd0dc8`](https://github.com/amundsen-io/amundsendatabuilder/commit/5cd0dc83d31409de1d81e38a087a1347392e6f16))
* Correct config getter ([#455](https://github.com/amundsen-io/amundsendatabuilder/issues/455)) ([`4b37746`](https://github.com/amundsen-io/amundsendatabuilder/commit/4b377465b5ee195c39a0c23b746c2ad9ebd7619f))
* Close SQL Alchemy connections. ([#453](https://github.com/amundsen-io/amundsendatabuilder/issues/453)) ([`25124c1`](https://github.com/amundsen-io/amundsendatabuilder/commit/25124c169faee6c2e48f47326fcfcbaf19e32e9e))
* Add comma between bigquery requirements listings ([#452](https://github.com/amundsen-io/amundsendatabuilder/issues/452)) ([`027edb9`](https://github.com/amundsen-io/amundsendatabuilder/commit/027edb948195f3ad032548f9f3ab0868a57263a3))
* Increase the compatibility of id structure between the Databuilder and the Metadata Library ([#445](https://github.com/amundsen-io/amundsendatabuilder/issues/445)) ([`6a13762`](https://github.com/amundsen-io/amundsendatabuilder/commit/6a13762ddaea1226f54d289f2b3011c4cb1e43c7))
* Move 'grouped_tables' into `_retrieve_tables` ([#430](https://github.com/amundsen-io/amundsendatabuilder/issues/430)) ([`26a0d0a`](https://github.com/amundsen-io/amundsendatabuilder/commit/26a0d0a4ffe5bf004507c9d1598a5f08b30ecdf0))
* Address PyAthena version ([#429](https://github.com/amundsen-io/amundsendatabuilder/issues/429)) ([`7157c24`](https://github.com/amundsen-io/amundsendatabuilder/commit/7157c24305a48e124ac873529f54c0eabe5d5190))
* Add csv badges back in Quickstart ([#418](https://github.com/amundsen-io/amundsendatabuilder/issues/418)) ([`c0296b7`](https://github.com/amundsen-io/amundsendatabuilder/commit/c0296b70de8aae4116fd3869233cd9de0d08fbbc))
* Typo in Readme ([#424](https://github.com/amundsen-io/amundsendatabuilder/issues/424)) ([`29bd72f`](https://github.com/amundsen-io/amundsendatabuilder/commit/29bd72f442ce8feb002a6b56b39f38b099186604))
* Fix redash dashboard exporter ([#422](https://github.com/amundsen-io/amundsendatabuilder/issues/422)) ([`fa626f5`](https://github.com/amundsen-io/amundsendatabuilder/commit/fa626f5cb2f92e5627c1a62ba5834b458ad0994d))
* Update the key format of set 'grouped_tables' ([#421](https://github.com/amundsen-io/amundsendatabuilder/issues/421)) ([`4c9e5f7`](https://github.com/amundsen-io/amundsendatabuilder/commit/4c9e5f753bab6a21f116337005e995e1d38ef268))
* Retry loop for exception caused by deadlock on badge node ([#404](https://github.com/amundsen-io/amundsendatabuilder/issues/404)) ([`9fd1513`](https://github.com/amundsen-io/amundsendatabuilder/commit/9fd1513b0eb0b7426d9ba8852f1e61457536adee))
* FsNeo4jCSVLoader fails if nodes have disjoint keys ([#408](https://github.com/amundsen-io/amundsendatabuilder/issues/408)) ([`c07cec9`](https://github.com/amundsen-io/amundsendatabuilder/commit/c07cec9588e30e8c87682882417a72dca1d1866d))
* Cast dashboard usage to be int ([#412](https://github.com/amundsen-io/amundsendatabuilder/issues/412)) ([`8bcc489`](https://github.com/amundsen-io/amundsendatabuilder/commit/8bcc4894c15d2de7f57e838668ff9709b97239ed))
* Pandas 'nan' values ([#409](https://github.com/amundsen-io/amundsendatabuilder/issues/409)) ([`3a28f46`](https://github.com/amundsen-io/amundsendatabuilder/commit/3a28f46915e3757c8445f2dfe6b7714a7789820a))
* Add databuilder missing dependencies ([#400](https://github.com/amundsen-io/amundsendatabuilder/issues/400)) ([`6718396`](https://github.com/amundsen-io/amundsendatabuilder/commit/6718396ed0aca467f61638c307822c18fbec6f65))
* Allow BigQuery Usage Extractor to extract usage for views ([#399](https://github.com/amundsen-io/amundsendatabuilder/issues/399)) ([`8779229`](https://github.com/amundsen-io/amundsendatabuilder/commit/8779229ce8446408fff310fc9bb50f472f0eca87))
* Hive metadata extractor not work on postgresql ([#394](https://github.com/amundsen-io/amundsendatabuilder/issues/394)) ([`2992618`](https://github.com/amundsen-io/amundsendatabuilder/commit/2992618d5d29e7061755dd62acba0eb53635fc1b))
* Issues with inconsistency in case conversion ([#388](https://github.com/amundsen-io/amundsendatabuilder/issues/388)) ([`9595866`](https://github.com/amundsen-io/amundsendatabuilder/commit/95958660e72b9c17f491f6e09994a47a84b55697))
* Update elasticsearch table index mapping ([#373](https://github.com/amundsen-io/amundsendatabuilder/issues/373)) ([`88c0552`](https://github.com/amundsen-io/amundsendatabuilder/commit/88c055228412aa36ab0f9d82b57b6442d7064b7c))
* Fix programmatic source data ([#367](https://github.com/amundsen-io/amundsendatabuilder/issues/367)) ([`4f5df39`](https://github.com/amundsen-io/amundsendatabuilder/commit/4f5df39cd6ddf05d2347b6d2b280f5cf0fdda5b9))
* Update connection string in Snowflake extractor to include wareh… ([#357](https://github.com/amundsen-io/amundsendatabuilder/issues/357)) ([`a11d206`](https://github.com/amundsen-io/amundsendatabuilder/commit/a11d20698fce49fbba97040d12411181aff0b194))
* Edge case in Snowflake information_schema.last_altered value ([#360](https://github.com/amundsen-io/amundsendatabuilder/issues/360)) ([`c3e713e`](https://github.com/amundsen-io/amundsendatabuilder/commit/c3e713e7f39e7240f3038daa3a3937fb060dbecb))
* Correct typo in Snowflake Last Updated extract query ([#358](https://github.com/amundsen-io/amundsendatabuilder/issues/358)) ([`5c2e98e`](https://github.com/amundsen-io/amundsendatabuilder/commit/5c2e98eb81aa9875f48b3e20eb5bef84ed9c481f))
* Set Tableau URLs (base + API) via config ([#349](https://github.com/amundsen-io/amundsendatabuilder/issues/349)) ([`1baec33`](https://github.com/amundsen-io/amundsendatabuilder/commit/1baec33899df8394b42b6a667ff2a5d1224b8528))
* Fix invalid timestamp handling in dashboard transformer ([#339](https://github.com/amundsen-io/amundsendatabuilder/issues/339)) ([`030ef49`](https://github.com/amundsen-io/amundsendatabuilder/commit/030ef4995d16711c35e205c213f90b3d72ff1499))
* Update postgres_sample_dag to set table extract job as upstream for elastic search publisher ([#340](https://github.com/amundsen-io/amundsendatabuilder/issues/340)) ([`c79935e`](https://github.com/amundsen-io/amundsendatabuilder/commit/c79935e01efdc8c9734727e07238f25c545bfd5d))
* **deps:** Unpin attrs ([#332](https://github.com/amundsen-io/amundsendatabuilder/issues/332)) ([`86f658d`](https://github.com/amundsen-io/amundsendatabuilder/commit/86f658d1ea9750ad916a91056a678e34a71654fb))
* Cypher statement param issue in Neo4jStalenessRemovalTask ([#307](https://github.com/amundsen-io/amundsendatabuilder/issues/307)) ([`0078761`](https://github.com/amundsen-io/amundsendatabuilder/commit/0078761dc94c33c785557df09bb86411ef8f6f46))
* Added missing job tag key in hive_sample_dag.py ([#308](https://github.com/amundsen-io/amundsendatabuilder/issues/308)) ([`d6714b7`](https://github.com/amundsen-io/amundsendatabuilder/commit/d6714b72c75328195a51a6a456d1ab46063243b0))
* Fix sql for missing columns and mysql based dialects (#550) ([#305](https://github.com/amundsen-io/amundsendatabuilder/issues/305)) ([`4b7b147`](https://github.com/amundsen-io/amundsendatabuilder/commit/4b7b147b1d32cd8fce6aa7c24fa1db8d823b8038))
* Escape backslashes in Neo4jCsvPublisher  ([`1faa713`](https://github.com/amundsen-io/amundsendatabuilder/commit/1faa713374c88cf0eb04f744908756c1ef70206e))
* Variable organization in Model URL ([#293](https://github.com/amundsen-io/amundsendatabuilder/issues/293)) ([`b4c24ef`](https://github.com/amundsen-io/amundsendatabuilder/commit/b4c24ef891ba13fc4678faef0faaa5c7bf4c5cb6))

### Documentation
* Minor fixes to README ([#457](https://github.com/amundsen-io/amundsendatabuilder/issues/457)) ([`54e89ce`](https://github.com/amundsen-io/amundsendatabuilder/commit/54e89ce74b70ade742edc77d4e76b9fc8241d8ab))
* Update DashboardMetadata docs ([#402](https://github.com/amundsen-io/amundsendatabuilder/issues/402)) ([`093b3d6`](https://github.com/amundsen-io/amundsendatabuilder/commit/093b3d6fbe40040b6f720c030aa6d8504178b0ea))
* Fix broken doc link to dashboard_execution model ([#296](https://github.com/amundsen-io/amundsendatabuilder/issues/296)) ([`24b3b0a`](https://github.com/amundsen-io/amundsendatabuilder/commit/24b3b0afdf4ad3c6b13f9677d9f805ff43f42de7))
* Fix README.md ([#301](https://github.com/amundsen-io/amundsendatabuilder/issues/301)) ([`ad5765a`](https://github.com/amundsen-io/amundsendatabuilder/commit/ad5765a1cb0ae5fceffb1168876031801b44a79f))
