# This is the client library generated by this plugin.
from google.api_core.gapic_v1.client_info import ClientInfo
from oceanbolt.com import tonnage, portcalls, drydock, congestion, tradeflows, entities
from google.auth import credentials, _helpers  # type: ignore
import os
import getpass


class ObCredentials(credentials.Credentials):
    @property
    def expired(self):
        """Returns `False`, OB credentials never expire."""
        return False

    @property
    def valid(self):
        """Returns `True`, OB credentials are always valid."""
        return True

    def refresh(self, request):
        """Raises :class:`ValueError``, anonymous credentials cannot be
        refreshed."""
        raise ValueError("OB credentials cannot be refreshed.")

    def apply(self, headers, token=None):
        """Sets the token in the header."""
        headers["authorization"] = "Bearer {}".format(
            _helpers.from_bytes(token or self.token)
        )

    def before_request(self, request, method, url, headers):
        """OB credentials applies headers to the request."""
        self.apply(headers)


def APIClientInteractive():
    return APIClient(getpass.getpass())


METRICS_METADATA_KEY = "x-goog-api-client"


class OBClientInfo(ClientInfo):
    def to_user_agent(self):
        return "oceanbolt-python-sdk"

    def to_grpc_metadata(self):
        """Returns the gRPC metadata for this client info."""
        return (METRICS_METADATA_KEY, self.to_user_agent())


class APIClient:

    def __init__(self, token=None):
        api_key = os.getenv("OCEANBOLT_API_KEY")
        if api_key is None and token is None:
            raise KeyError(
                "You must either set the OCEANBOLT_API_KEY environment variable, or supply enter your Oceanbolt API key as a string argument."
                " You can create API keys at https://app.oceanbolt.com"
            )

        creds = ObCredentials()

        if token is not None:
            creds.token = token
        else:
            creds.token = api_key

        self.tonnageClient = tonnage.TonnageServiceClient(credentials=creds, client_info=OBClientInfo())
        self.portCallsClient = portcalls.PortCallServiceClient(credentials=creds, client_info=OBClientInfo())
        self.tradeFlowsClient = tradeflows.TradeFlowServiceClient(credentials=creds, client_info=OBClientInfo())
        self.congestionClient = congestion.CongestionServiceClient(credentials=creds, client_info=OBClientInfo())
        self.drydockClient = drydock.DrydockServiceClient(credentials=creds, client_info=OBClientInfo())
        self.entitiesClient = entities.EntityServiceClient(credentials=creds, client_info=OBClientInfo())

    def _tonnage_client(self):
        return self.tonnageClient

    def _congestion_client(self):
        return self.congestionClient

    def _tradeflows_client(self):
        return self.tradeFlowsClient

    def _drydock_client(self):
        return self.drydockClient

    def _portcalls_client(self):
        return self.portCallsClient

    def _entities_client(self):
        return self.entitiesClient
