# numbers
ONE_THOUSAND = 1_000
FIVE_THOUSAND = 5_000
TEN_THOUSAND = 10_000
ONE_HUNDRED_THOUSAND = 100_000
FIVE_HUNDRED_THOUSAND = 500_000
ONE_MILLION = 1_000_000
TEN_MILLION = 10_000_000
ONE_HUNDRED_MILLION = 100_000_000
ONE_BILLION = 1_000_000_000
TEN_BILLION = 10_000_000_000


# PRECISIONS
AMM_RESERVE_PRECISION = ONE_BILLION
BASE_PRECISION = AMM_RESERVE_PRECISION
PRICE_PRECISION = ONE_MILLION
PEG_PRECISION = ONE_MILLION
QUOTE_PRECISION = ONE_MILLION
FUNDING_RATE_BUFFER = ONE_THOUSAND
MARGIN_PRECISION = TEN_THOUSAND
BID_ASK_SPREAD_PRECISION = ONE_MILLION
TEN_BPS = BID_ASK_SPREAD_PRECISION
PERP_DECIMALS = 9
CONCENTRATION_PRECISION = ONE_MILLION
IF_FACTOR_PRECISION = ONE_MILLION

SPOT_BALANCE_PRECISION = ONE_BILLION
SPOT_CUMULATIVE_INTEREST_PRECISION = TEN_BILLION
SPOT_UTILIZATION_PRECISION = ONE_MILLION
SPOT_RATE_PRECISION = ONE_MILLION
LIQUIDATION_FEE_PRECISION = ONE_MILLION
SPOT_WEIGHT_PRECISION = MARGIN_PRECISION
SPOT_IMF_PRECISION = ONE_MILLION
FUNDING_RATE_PRECISION = PRICE_PRECISION * FUNDING_RATE_BUFFER
FUNDING_RATE_OFFSET_DENOMINATOR = FIVE_THOUSAND

# PRECISION CONVERSIONS
PRICE_TO_PEG_PRECISION_RATIO = PRICE_PRECISION / PEG_PRECISION
AMM_TO_QUOTE_PRECISION_RATIO = AMM_RESERVE_PRECISION / QUOTE_PRECISION
AMM_TIMES_PEG_TO_QUOTE_PRECISION_RATIO = (
    AMM_RESERVE_PRECISION * PEG_PRECISION / QUOTE_PRECISION
)
QUOTE_TO_BASE_AMT_FUNDING_PRECISION = (
    AMM_RESERVE_PRECISION * FUNDING_RATE_PRECISION / QUOTE_PRECISION
)
PRICE_TO_QUOTE_PRECISION_RATIO = PRICE_PRECISION / QUOTE_PRECISION
PRICE_TIMES_AMM_TO_QUOTE_PRECISION_RATIO = (
    PRICE_PRECISION * AMM_TO_QUOTE_PRECISION_RATIO
)
LIQUIDATION_FEE_TO_MARGIN_PRECISION_RATIO = LIQUIDATION_FEE_PRECISION / MARGIN_PRECISION
FUNDING_RATE_TO_QUOTE_PRECISION_PRECISION_RATIO = (
    FUNDING_RATE_PRECISION / QUOTE_PRECISION
)
FUNDING_RATE_PRECISION = PRICE_PRECISION * FUNDING_RATE_BUFFER
PRICE_DIV_PEG = PRICE_PRECISION / PEG_PRECISION
SPOT_MARKET_WEIGHT_PRECISION = TEN_THOUSAND
SPOT_MARKET_CUMULATIVE_INTEREST_PRECISION_EXP = 10
SPOT_MARKET_CUMULATIVE_INTEREST_PRECISION = (
    10**SPOT_MARKET_CUMULATIVE_INTEREST_PRECISION_EXP
)
AMM_TO_QUOTE_PRECISION_RATIO = AMM_RESERVE_PRECISION // QUOTE_PRECISION

# FEE REBATES
SHARE_OF_FEES_ALLOCATED_TO_CLEARING_HOUSE_NUMERATOR = 1
SHARE_OF_FEES_ALLOCATED_TO_CLEARING_HOUSE_DENOMINATOR = 2

SHARE_OF_IF_ESCROW_ALLOCATED_TO_PROTOCOL_NUMERATOR = 1
SHARE_OF_IF_ESCROW_ALLOCATED_TO_PROTOCOL_DENOMINATOR = 2

SHARE_OF_REVENUE_ALLOCATED_TO_INSURANCE_FUND_VAULT_NUMERATOR = 1
SHARE_OF_REVENUE_ALLOCATED_TO_INSURANCE_FUND_VAULT_DENOMINATOR = 1

MAX_APR_PER_REVENUE_SETTLE_TO_INSURANCE_FUND_VAULT = ONE_THOUSAND
MAX_APR_PER_REVENUE_SETTLE_PRECISION = 10
UPDATE_K_ALLOWED_PRICE_CHANGE = PRICE_PRECISION / TEN_THOUSAND

# TIME PERIODS
ONE_HOUR = 3600
ONE_HOUR_I128 = ONE_HOUR
FIVE_MINUTE = 60 * 5
TWENTY_FOUR_HOUR = 3600 * 24
ONE_YEAR = 31536000
EPOCH_DURATION = TWENTY_FOUR_HOUR * 28

# FEES
ONE_BPS_DENOMINATOR = TEN_THOUSAND
ONE_HUNDRED_MILLION_QUOTE = ONE_HUNDRED_MILLION * QUOTE_PRECISION
FIFTY_MILLION_QUOTE = 50_000_000 * QUOTE_PRECISION
TEN_MILLION_QUOTE = TEN_MILLION * QUOTE_PRECISION
FIVE_MILLION_QUOTE = TEN_MILLION * QUOTE_PRECISION
ONE_MILLION_QUOTE = ONE_MILLION * QUOTE_PRECISION
TWO_HUNDRED_FIFTY_THOUSAND_QUOTE = 250_000 * QUOTE_PRECISION
ONE_HUNDRED_THOUSAND_QUOTE = ONE_HUNDRED_THOUSAND * QUOTE_PRECISION
TWENTY_FIVE_THOUSAND_QUOTE = 25_000 * QUOTE_PRECISION
TEN_THOUSAND_QUOTE = TEN_THOUSAND * QUOTE_PRECISION
ONE_THOUSAND_QUOTE = ONE_THOUSAND * QUOTE_PRECISION
MAX_REFERRER_REWARD_EPOCH_UPPER_BOUND = 4000 * QUOTE_PRECISION
LP_FEE_SLICE_NUMERATOR = 8
LP_FEE_SLICE_DENOMINATOR = 10
FEE_DENOMINATOR = 10 * ONE_BPS_DENOMINATOR
FEE_PERCENTAGE_DENOMINATOR = 100

# CONSTRAINTS
MAX_CONCENTRATION_COEFFICIENT = 1_414_200
MAX_LIQUIDATION_SLIPPAGE = TEN_THOUSAND
MAX_LIQUIDATION_SLIPPAGE_U128 = TEN_THOUSAND
MAX_MARK_TWAP_DIVERGENCE = FIVE_HUNDRED_THOUSAND
MAXIMUM_MARGIN_RATIO = MARGIN_PRECISION
MINIMUM_MARGIN_RATIO = MARGIN_PRECISION / 50
DEFAULT_LARGE_BID_ASK_FACTOR = 10 * BID_ASK_SPREAD_PRECISION
MAX_BID_ASK_INVENTORY_SKEW_FACTOR = 10 * BID_ASK_SPREAD_PRECISION

# FORMULAIC REPEG / K
K_BPS_UPDATE_SCALE = ONE_MILLION
K_BPS_DECREASE_MAX = 22000
K_BPS_INCREASE_MAX = ONE_THOUSAND

PEG_BPS_UPDATE_SCALE = ONE_MILLION
PEG_BPS_DECREASE_MAX = ONE_THOUSAND
PEG_BPS_INCREASE_MAX = ONE_THOUSAND

QUOTE_SPOT_MARKET_INDEX = 0

PERCENTAGE_PRECISION_EXP = 6
PERCENTAGE_PRECISION = 10**PERCENTAGE_PRECISION_EXP

DEFAULT_REVENUE_SINCE_LAST_FUNDING_SPREAD_RETREAT = -25 * QUOTE_PRECISION

OPEN_ORDER_MARGIN_REQUIREMENT = QUOTE_PRECISION / 100

LIQUIDATION_PCT_PRECISION = TEN_THOUSAND

FUEL_START_TS = 1722384000
FUEL_WINDOW = 60 * 60 * 24 * 28

GOV_SPOT_MARKET_INDEX = 15

SWB_PRECISION = 10**12

MAX_PREDICTION_PRICE = PRICE_PRECISION
