/**
 * Class to validate that inputs match requirements.
 */
export declare class InputValidator {
    /**
     * Validates length is between allowed min and max lengths.
     */
    static validateLength(resourceName: string, inputName: string, minLength: number, maxLength: number, inputString?: string): void;
    /**
     * Validates a regex.
     */
    static validateRegex(resourceName: string, inputName: string, regex: RegExp, inputString?: string): void;
    private static truncateString;
}
